/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.CallSiteBinder;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.util.CompilerUtils;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Objects;

public class VarArgsToArrayAdapterGenerator {
    private VarArgsToArrayAdapterGenerator() {
    }

    public static VarArgMethodHandle generateVarArgsToArrayAdapter(Class<?> returnType, Class<?> javaType, int argsLength, MethodHandle function) {
        Objects.requireNonNull(returnType, "returnType is null");
        Objects.requireNonNull(javaType, "javaType is null");
        Objects.requireNonNull(function, "function is null");
        Failures.checkCondition(argsLength <= 254, (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Too many arguments for vararg function", new Object[0]);
        MethodType methodType = function.type();
        Class<?> javaArrayType = VarArgsToArrayAdapterGenerator.toArrayClass(javaType);
        Preconditions.checkArgument((methodType.returnType() == returnType ? 1 : 0) != 0, (Object)"returnType does not match");
        Preconditions.checkArgument((boolean)methodType.parameterList().equals(ImmutableList.of(javaArrayType)), (Object)"parameter types do not match");
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("VarArgsToListAdapter"), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        classDefinition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PRIVATE}));
        ImmutableList.Builder parameterListBuilder = ImmutableList.builder();
        for (int i = 0; i < argsLength; ++i) {
            parameterListBuilder.add((Object)Parameter.arg((String)("input_" + i), javaType));
        }
        ImmutableList parameterList = parameterListBuilder.build();
        MethodDefinition methodDefinition = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "varArgsToArray", ParameterizedType.type(returnType), (Iterable)parameterList);
        BytecodeBlock body = methodDefinition.getBody();
        body.append((BytecodeNode)BytecodeUtils.loadConstant(callSiteBinder, function, MethodHandle.class).invoke("invokeExact", returnType, new BytecodeExpression[]{BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(javaArrayType), (Iterable)parameterList)}).ret());
        Class<Object> generatedClass = CompilerUtils.defineClass(classDefinition, Object.class, callSiteBinder.getBindings(), VarArgsToArrayAdapterGenerator.class.getClassLoader());
        return new VarArgMethodHandle(Reflection.methodHandle(generatedClass, "varArgsToArray", (Class[])ImmutableList.builder().addAll(Collections.nCopies(argsLength, javaType)).build().toArray((Object[])new Class[argsLength])));
    }

    private static Class<?> toArrayClass(Class<?> elementType) {
        return Array.newInstance(elementType, 0).getClass();
    }

    public static class VarArgMethodHandle {
        private final MethodHandle methodHandle;

        private VarArgMethodHandle(MethodHandle methodHandle) {
            this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
        }

        public MethodHandle getMethodHandle() {
            return this.methodHandle;
        }
    }
}

