/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.relational.Expressions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CommonSubExpressionRewriter {
    private CommonSubExpressionRewriter() {
    }

    public static Map<Integer, Map<RowExpression, VariableReferenceExpression>> collectCSEByLevel(List<? extends RowExpression> expressions) {
        if (expressions.isEmpty()) {
            return ImmutableMap.of();
        }
        CommonSubExpressionCollector expressionCollector = new CommonSubExpressionCollector();
        expressions.forEach(expression -> {
            Integer cfr_ignored_0 = (Integer)expression.accept((RowExpressionVisitor)expressionCollector, null);
        });
        if (expressionCollector.cseByLevel.isEmpty()) {
            return ImmutableMap.of();
        }
        Map<Integer, Map<RowExpression, Integer>> cseByLevel = CommonSubExpressionRewriter.removeRedundantCSE(expressionCollector.cseByLevel, expressionCollector.expressionCount);
        PlanVariableAllocator variableAllocator = new PlanVariableAllocator();
        ImmutableMap.Builder commonSubExpressions = ImmutableMap.builder();
        HashMap<RowExpression, VariableReferenceExpression> rewriteWith = new HashMap<RowExpression, VariableReferenceExpression>();
        int startCSELevel = (Integer)cseByLevel.keySet().stream().reduce(Math::min).get();
        int maxCSELevel = (Integer)cseByLevel.keySet().stream().reduce(Math::max).get();
        for (int i = startCSELevel; i <= maxCSELevel; ++i) {
            if (!cseByLevel.containsKey(i)) continue;
            ExpressionRewriter rewriter = new ExpressionRewriter(rewriteWith);
            ImmutableMap.Builder expressionVariableMapBuilder = ImmutableMap.builder();
            for (Map.Entry<RowExpression, Integer> entry2 : cseByLevel.get(i).entrySet()) {
                RowExpression rewrittenExpression = (RowExpression)entry2.getKey().accept((RowExpressionVisitor)rewriter, null);
                expressionVariableMapBuilder.put((Object)rewrittenExpression, (Object)variableAllocator.newVariable(rewrittenExpression, "cse"));
            }
            ImmutableMap expressionVariableMap = expressionVariableMapBuilder.build();
            commonSubExpressions.put((Object)i, (Object)expressionVariableMap);
            rewriteWith.putAll((Map)expressionVariableMap.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (VariableReferenceExpression)entry.getValue())));
        }
        return commonSubExpressions.build();
    }

    public static Map<Integer, Map<RowExpression, VariableReferenceExpression>> collectCSEByLevel(RowExpression expression) {
        return CommonSubExpressionRewriter.collectCSEByLevel((List<? extends RowExpression>)ImmutableList.of((Object)expression));
    }

    public static Map<List<RowExpression>, Boolean> getExpressionsPartitionedByCSE(Collection<? extends RowExpression> expressions, int expressionGroupSize) {
        if (expressions.isEmpty()) {
            return ImmutableMap.of();
        }
        CommonSubExpressionCollector expressionCollector = new CommonSubExpressionCollector();
        expressions.forEach(expression -> {
            Integer cfr_ignored_0 = (Integer)expression.accept((RowExpressionVisitor)expressionCollector, null);
        });
        Set cse = (Set)expressionCollector.cseByLevel.values().stream().flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
        if (cse.isEmpty()) {
            return (Map)expressions.stream().collect(ImmutableMap.toImmutableMap(ImmutableList::of, m -> false));
        }
        ImmutableMap.Builder expressionsPartitionedByCse = ImmutableMap.builder();
        SubExpressionChecker subExpressionChecker = new SubExpressionChecker(cse);
        Map<Boolean, List<RowExpression>> expressionsWithCseFlag = expressions.stream().collect(Collectors.partitioningBy(expression -> (Boolean)expression.accept((RowExpressionVisitor)subExpressionChecker, null)));
        expressionsWithCseFlag.get(false).forEach(expression -> expressionsPartitionedByCse.put((Object)ImmutableList.of((Object)expression), (Object)false));
        List<RowExpression> expressionsWithCse = expressionsWithCseFlag.get(true);
        if (expressionsWithCse.size() == 1) {
            RowExpression expression2 = expressionsWithCse.get(0);
            expressionsPartitionedByCse.put((Object)ImmutableList.of((Object)expression2), (Object)true);
            return expressionsPartitionedByCse.build();
        }
        List cseDependency = (List)expressionsWithCse.stream().map(expression -> (ImmutableSet)Expressions.subExpressions(expression).stream().filter(cse::contains).collect(ImmutableSet.toImmutableSet())).collect(ImmutableList.toImmutableList());
        boolean[] merged = new boolean[expressionsWithCse.size()];
        int i = 0;
        while (i < merged.length) {
            while (i < merged.length && merged[i]) {
                ++i;
            }
            if (i >= merged.length) break;
            merged[i] = true;
            ArrayList<RowExpression> newList = new ArrayList<RowExpression>();
            newList.add(expressionsWithCse.get(i));
            HashSet dependencies = new HashSet();
            Set first = (Set)cseDependency.get(i);
            dependencies.addAll(first);
            int j = i + 1;
            while (j < merged.length && newList.size() < expressionGroupSize) {
                while (j < merged.length && merged[j]) {
                    ++j;
                }
                if (j >= merged.length) break;
                Set second = (Set)cseDependency.get(j);
                if (!Sets.intersection(dependencies, (Set)second).isEmpty()) {
                    RowExpression expression3 = expressionsWithCse.get(j);
                    newList.add(expression3);
                    dependencies.addAll(second);
                    merged[j] = true;
                    j = i + 1;
                    continue;
                }
                ++j;
            }
            expressionsPartitionedByCse.put((Object)ImmutableList.copyOf(newList), (Object)true);
        }
        return expressionsPartitionedByCse.build();
    }

    public static RowExpression rewriteExpressionWithCSE(RowExpression expression, Map<RowExpression, VariableReferenceExpression> rewriteWith) {
        ExpressionRewriter rewriter = new ExpressionRewriter(rewriteWith);
        return (RowExpression)expression.accept((RowExpressionVisitor)rewriter, null);
    }

    private static Map<Integer, Map<RowExpression, Integer>> removeRedundantCSE(Map<Integer, Set<RowExpression>> cseByLevel, Map<RowExpression, Integer> expressionCount) {
        HashMap<Integer, Map<RowExpression, Integer>> results = new HashMap<Integer, Map<RowExpression, Integer>>();
        int startCSELevel = (Integer)cseByLevel.keySet().stream().reduce(Math::max).get();
        int stopCSELevel = (Integer)cseByLevel.keySet().stream().reduce(Math::min).get();
        for (int i = startCSELevel; i > stopCSELevel; --i) {
            if (!cseByLevel.containsKey(i)) continue;
            Map expressions = (Map)cseByLevel.get(i).stream().filter(expression -> (Integer)expressionCount.get(expression) > 0).collect(ImmutableMap.toImmutableMap(Function.identity(), expressionCount::get));
            if (!expressions.isEmpty()) {
                results.put(i, expressions);
            }
            for (RowExpression expression2 : expressions.keySet()) {
                int expressionOccurrence = expressionCount.get(expression2);
                Expressions.subExpressions(expression2).stream().filter(subExpression -> !subExpression.equals((Object)expression2)).forEach(subExpression -> {
                    if (expressionCount.containsKey(subExpression)) {
                        expressionCount.put((RowExpression)subExpression, (Integer)expressionCount.get(subExpression) - expressionOccurrence);
                    }
                });
            }
        }
        Map expressions = (Map)cseByLevel.get(stopCSELevel).stream().filter(expression -> (Integer)expressionCount.get(expression) > 0).collect(ImmutableMap.toImmutableMap(Function.identity(), expression -> (Integer)expressionCount.get(expression) + 1));
        if (!expressions.isEmpty()) {
            results.put(stopCSELevel, expressions);
        }
        return results;
    }

    static class CommonSubExpressionFields {
        private final FieldDefinition evaluatedField;
        private final FieldDefinition resultField;
        private final Class<?> resultType;
        private final String methodName;

        public CommonSubExpressionFields(FieldDefinition evaluatedField, FieldDefinition resultField, Class<?> resultType, String methodName) {
            this.evaluatedField = evaluatedField;
            this.resultField = resultField;
            this.resultType = resultType;
            this.methodName = methodName;
        }

        public FieldDefinition getEvaluatedField() {
            return this.evaluatedField;
        }

        public FieldDefinition getResultField() {
            return this.resultField;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Class<?> getResultType() {
            return this.resultType;
        }

        public static Map<VariableReferenceExpression, CommonSubExpressionFields> declareCommonSubExpressionFields(ClassDefinition classDefinition, Map<Integer, Map<RowExpression, VariableReferenceExpression>> commonSubExpressionsByLevel) {
            ImmutableMap.Builder fields = ImmutableMap.builder();
            commonSubExpressionsByLevel.values().stream().map(Map::values).flatMap(Collection::stream).forEach(variable -> {
                Class type = Primitives.wrap((Class)variable.getType().getJavaType());
                fields.put(variable, (Object)new CommonSubExpressionFields(classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), variable.getName() + "Evaluated", Boolean.TYPE), classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), variable.getName() + "Result", type), type, "get" + variable.getName()));
            });
            return fields.build();
        }

        public static void initializeCommonSubExpressionFields(Collection<CommonSubExpressionFields> cseFields, Variable thisVariable, BytecodeBlock body) {
            cseFields.forEach(fields -> {
                body.append((BytecodeNode)thisVariable.setField(fields.getEvaluatedField(), BytecodeExpressions.constantBoolean((boolean)false)));
                body.append((BytecodeNode)thisVariable.setField(fields.getResultField(), BytecodeExpressions.constantNull(fields.getResultType())));
            });
        }
    }

    static class CommonSubExpressionCollector
    implements RowExpressionVisitor<Integer, Void> {
        private final Map<Integer, Set<RowExpression>> expressionsByLevel = new HashMap<Integer, Set<RowExpression>>();
        private final Map<Integer, Set<RowExpression>> cseByLevel = new HashMap<Integer, Set<RowExpression>>();
        private final Map<RowExpression, Integer> expressionCount = new HashMap<RowExpression, Integer>();

        CommonSubExpressionCollector() {
        }

        private int addAtLevel(int level, RowExpression expression) {
            Set<RowExpression> rowExpressions = CommonSubExpressionCollector.getExpresssionsAtLevel(level, this.expressionsByLevel);
            this.expressionCount.putIfAbsent(expression, 1);
            if (rowExpressions.contains(expression)) {
                CommonSubExpressionCollector.getExpresssionsAtLevel(level, this.cseByLevel).add(expression);
                int count = this.expressionCount.get(expression) + 1;
                this.expressionCount.put(expression, count);
            }
            rowExpressions.add(expression);
            return level;
        }

        private static Set<RowExpression> getExpresssionsAtLevel(int level, Map<Integer, Set<RowExpression>> expressionsByLevel) {
            expressionsByLevel.putIfAbsent(level, new HashSet());
            return expressionsByLevel.get(level);
        }

        public Integer visitCall(CallExpression call, Void collect) {
            if (call.getArguments().isEmpty()) {
                return 0;
            }
            return this.addAtLevel(call.getArguments().stream().map(argument -> (Integer)argument.accept((RowExpressionVisitor)this, (Object)collect)).reduce(Math::max).get() + 1, (RowExpression)call);
        }

        public Integer visitInputReference(InputReferenceExpression reference, Void collect) {
            return 0;
        }

        public Integer visitConstant(ConstantExpression literal, Void collect) {
            return 0;
        }

        public Integer visitLambda(LambdaDefinitionExpression lambda, Void collect) {
            return 0;
        }

        public Integer visitVariableReference(VariableReferenceExpression reference, Void collect) {
            return 0;
        }

        public Integer visitSpecialForm(SpecialFormExpression specialForm, Void collect) {
            int level = specialForm.getArguments().stream().map(argument -> (Integer)argument.accept((RowExpressionVisitor)this, null)).reduce(Math::max).get() + 1;
            if (specialForm.getForm() != SpecialFormExpression.Form.WHEN && specialForm.getForm() != SpecialFormExpression.Form.BIND) {
                this.addAtLevel(level, (RowExpression)specialForm);
            }
            return level;
        }
    }

    static class ExpressionRewriter
    implements RowExpressionVisitor<RowExpression, Void> {
        private final Map<RowExpression, VariableReferenceExpression> expressionMap;

        public ExpressionRewriter(Map<RowExpression, VariableReferenceExpression> expressionMap) {
            this.expressionMap = ImmutableMap.copyOf(expressionMap);
        }

        public RowExpression visitCall(CallExpression call, Void context) {
            CallExpression rewritten = new CallExpression(call.getSourceLocation(), call.getDisplayName(), call.getFunctionHandle(), call.getType(), (List)call.getArguments().stream().map(argument -> (RowExpression)argument.accept((RowExpressionVisitor)this, null)).collect(ImmutableList.toImmutableList()));
            if (this.expressionMap.containsKey(rewritten)) {
                return (RowExpression)this.expressionMap.get(rewritten);
            }
            return rewritten;
        }

        public RowExpression visitInputReference(InputReferenceExpression reference, Void context) {
            return reference;
        }

        public RowExpression visitConstant(ConstantExpression literal, Void context) {
            return literal;
        }

        public RowExpression visitLambda(LambdaDefinitionExpression lambda, Void context) {
            return lambda;
        }

        public RowExpression visitVariableReference(VariableReferenceExpression reference, Void context) {
            return reference;
        }

        public RowExpression visitSpecialForm(SpecialFormExpression specialForm, Void context) {
            SpecialFormExpression rewritten = new SpecialFormExpression(specialForm.getForm(), specialForm.getType(), (List)specialForm.getArguments().stream().map(argument -> (RowExpression)argument.accept((RowExpressionVisitor)this, null)).collect(ImmutableList.toImmutableList()));
            if (this.expressionMap.containsKey(rewritten)) {
                return (RowExpression)this.expressionMap.get(rewritten);
            }
            return rewritten;
        }
    }

    static class SubExpressionChecker
    implements RowExpressionVisitor<Boolean, Void> {
        private final Set<RowExpression> subExpressions;

        SubExpressionChecker(Set<RowExpression> subExpressions) {
            this.subExpressions = subExpressions;
        }

        public Boolean visitCall(CallExpression call, Void context) {
            if (this.subExpressions.contains(call)) {
                return true;
            }
            if (call.getArguments().isEmpty()) {
                return false;
            }
            return call.getArguments().stream().anyMatch(expression -> (Boolean)expression.accept((RowExpressionVisitor)this, null));
        }

        public Boolean visitInputReference(InputReferenceExpression reference, Void context) {
            return this.subExpressions.contains(reference);
        }

        public Boolean visitConstant(ConstantExpression literal, Void context) {
            return this.subExpressions.contains(literal);
        }

        public Boolean visitLambda(LambdaDefinitionExpression lambda, Void context) {
            return false;
        }

        public Boolean visitVariableReference(VariableReferenceExpression reference, Void context) {
            return this.subExpressions.contains(reference);
        }

        public Boolean visitSpecialForm(SpecialFormExpression specialForm, Void context) {
            if (this.subExpressions.contains(specialForm)) {
                return true;
            }
            if (specialForm.getArguments().isEmpty()) {
                return false;
            }
            return specialForm.getArguments().stream().anyMatch(expression -> (Boolean)expression.accept((RowExpressionVisitor)this, null));
        }
    }
}

