/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.JoinCriteria;
import com.facebook.presto.sql.tree.JoinOn;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.Unnest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class MaterializedViewPlanValidator
extends DefaultTraversalVisitor<Void, MaterializedViewPlanValidatorContext> {
    protected MaterializedViewPlanValidator() {
    }

    public static void validate(Query viewQuery) {
        new MaterializedViewPlanValidator().process((Node)viewQuery, new MaterializedViewPlanValidatorContext());
    }

    protected Void visitTable(Table node, MaterializedViewPlanValidatorContext context) {
        if (!context.addTable(node)) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Materialized View definition does not support multiple instances of same table", new Object[0]);
        }
        return (Void)super.visitTable(node, (Object)context);
    }

    protected Void visitJoin(Join node, MaterializedViewPlanValidatorContext context) {
        context.pushJoinNode(node);
        if (context.getJoinNodes().size() > 1) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "More than one join in materialized view is not supported yet.", new Object[0]);
        }
        switch (node.getType()) {
            case INNER: {
                if (!node.getCriteria().isPresent()) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Inner join with no criteria is not supported for materialized view.", new Object[0]);
                }
                JoinCriteria joinCriteria = (JoinCriteria)node.getCriteria().get();
                if (!(joinCriteria instanceof JoinOn)) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Only join-on is supported for materialized view.", new Object[0]);
                }
                this.process((Node)node.getLeft(), context);
                this.process((Node)node.getRight(), context);
                context.setWithinJoinOn(true);
                this.process((Node)((JoinOn)joinCriteria).getExpression(), context);
                context.setWithinJoinOn(false);
                break;
            }
            case CROSS: {
                if (!(node.getRight() instanceof AliasedRelation)) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Cross join is supported only with unnest for materialized view.", new Object[0]);
                }
                AliasedRelation right = (AliasedRelation)node.getRight();
                if (!(right.getRelation() instanceof Unnest)) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Cross join is supported only with unnest for materialized view.", new Object[0]);
                }
                this.process((Node)node.getLeft(), context);
                break;
            }
            case LEFT: {
                if (!node.getCriteria().isPresent()) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Outer join with no criteria is not supported for materialized view.", new Object[0]);
                }
                JoinCriteria joinCriteria = (JoinCriteria)node.getCriteria().get();
                if (!(joinCriteria instanceof JoinOn)) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Only join-on is supported for materialized view.", new Object[0]);
                }
                this.process((Node)node.getLeft(), context);
                boolean wasWithinOuterJoin = context.isWithinOuterJoin();
                context.setWithinOuterJoin(true);
                this.process((Node)node.getRight(), context);
                context.setWithinOuterJoin(wasWithinOuterJoin);
                context.setWithinJoinOn(true);
                this.process((Node)((JoinOn)joinCriteria).getExpression(), context);
                context.setWithinJoinOn(false);
                break;
            }
            default: {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Only inner join, left join and cross join unnested are supported for materialized view.", new Object[0]);
            }
        }
        context.popJoinNode();
        return null;
    }

    protected Void visitLogicalBinaryExpression(LogicalBinaryExpression node, MaterializedViewPlanValidatorContext context) {
        if (context.isWithinJoinOn() && !node.getOperator().equals((Object)LogicalBinaryExpression.Operator.AND)) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Only AND operator is supported for join criteria for materialized view.", new Object[0]);
        }
        return (Void)super.visitLogicalBinaryExpression(node, (Object)context);
    }

    protected Void visitComparisonExpression(ComparisonExpression node, MaterializedViewPlanValidatorContext context) {
        if (context.isWithinJoinOn() && !node.getOperator().equals((Object)ComparisonExpression.Operator.EQUAL)) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Only EQUAL join is supported for materialized view.", new Object[0]);
        }
        return (Void)super.visitComparisonExpression(node, (Object)context);
    }

    protected Void visitSubqueryExpression(SubqueryExpression node, MaterializedViewPlanValidatorContext context) {
        throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Subqueries are not supported for materialized view.", new Object[0]);
    }

    public static final class MaterializedViewPlanValidatorContext {
        private boolean isWithinJoinOn = false;
        private final LinkedList<Join> joinNodeStack = new LinkedList();
        private boolean isWithinOuterJoin = false;
        private final HashSet<Table> tables = new HashSet();

        public boolean isWithinJoinOn() {
            return this.isWithinJoinOn;
        }

        public void setWithinJoinOn(boolean withinJoinOn) {
            this.isWithinJoinOn = withinJoinOn;
        }

        public boolean isWithinOuterJoin() {
            return this.isWithinOuterJoin;
        }

        public void setWithinOuterJoin(boolean withinOuterJoin) {
            this.isWithinOuterJoin = withinOuterJoin;
        }

        public void pushJoinNode(Join join) {
            this.joinNodeStack.push(join);
        }

        public Join popJoinNode() {
            return this.joinNodeStack.pop();
        }

        public Join getTopJoinNode() {
            return this.joinNodeStack.getFirst();
        }

        public List<Join> getJoinNodes() {
            return ImmutableList.copyOf(this.joinNodeStack);
        }

        public boolean addTable(Table table) {
            return this.tables.add(table);
        }

        public Set<Table> getTables() {
            return ImmutableSet.copyOf(this.tables);
        }
    }
}

