/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.server.QueryStateInfo;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupState;
import com.facebook.presto.spi.resourceGroups.SchedulingPolicy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class ResourceGroupInfo {
    private final ResourceGroupId id;
    private final ResourceGroupState state;
    private final SchedulingPolicy schedulingPolicy;
    private final int schedulingWeight;
    private final DataSize softMemoryLimit;
    private final int softConcurrencyLimit;
    private final int hardConcurrencyLimit;
    private final int maxQueuedQueries;
    private final DataSize memoryUsage;
    private final int numQueuedQueries;
    private final int numRunningQueries;
    private final int numEligibleSubGroups;
    private final List<ResourceGroupInfo> subGroups;
    private final List<QueryStateInfo> runningQueries;

    @JsonCreator
    public ResourceGroupInfo(@JsonProperty(value="id") ResourceGroupId id, @JsonProperty(value="state") ResourceGroupState state, @JsonProperty(value="schedulingPolicy") SchedulingPolicy schedulingPolicy, @JsonProperty(value="schedulingWeight") int schedulingWeight, @JsonProperty(value="softMemoryLimit") DataSize softMemoryLimit, @JsonProperty(value="softConcurrencyLimit") int softConcurrencyLimit, @JsonProperty(value="hardConcurrencyLimit") int hardConcurrencyLimit, @JsonProperty(value="maxQueuedQueries") int maxQueuedQueries, @JsonProperty(value="memoryUsage") DataSize memoryUsage, @JsonProperty(value="numQueuedQueries") int numQueuedQueries, @JsonProperty(value="numRunningQueries") int numRunningQueries, @JsonProperty(value="numEligibleSubGroups") int numEligibleSubGroups, @JsonProperty(value="subGroups") List<ResourceGroupInfo> subGroups, @JsonProperty(value="runningQueries") List<QueryStateInfo> runningQueries) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.state = Objects.requireNonNull(state, "state is null");
        this.schedulingPolicy = Objects.requireNonNull(schedulingPolicy, "schedulingPolicy is null");
        this.schedulingWeight = schedulingWeight;
        this.softMemoryLimit = Objects.requireNonNull(softMemoryLimit, "softMemoryLimit is null");
        this.softConcurrencyLimit = softConcurrencyLimit;
        this.hardConcurrencyLimit = hardConcurrencyLimit;
        this.maxQueuedQueries = maxQueuedQueries;
        this.memoryUsage = Objects.requireNonNull(memoryUsage, "memoryUsage is null");
        this.numQueuedQueries = numQueuedQueries;
        this.numRunningQueries = numRunningQueries;
        this.numEligibleSubGroups = numEligibleSubGroups;
        this.runningQueries = runningQueries;
        this.subGroups = subGroups;
    }

    @JsonProperty
    public ResourceGroupId getId() {
        return this.id;
    }

    @JsonProperty
    public ResourceGroupState getState() {
        return this.state;
    }

    @JsonProperty
    public SchedulingPolicy getSchedulingPolicy() {
        return this.schedulingPolicy;
    }

    @JsonProperty
    public int getSchedulingWeight() {
        return this.schedulingWeight;
    }

    @JsonProperty
    public DataSize getSoftMemoryLimit() {
        return this.softMemoryLimit;
    }

    @JsonProperty
    public DataSize getMemoryUsage() {
        return this.memoryUsage;
    }

    @JsonProperty
    public int getSoftConcurrencyLimit() {
        return this.softConcurrencyLimit;
    }

    @JsonProperty
    public int getHardConcurrencyLimit() {
        return this.hardConcurrencyLimit;
    }

    @JsonProperty
    public int getMaxQueuedQueries() {
        return this.maxQueuedQueries;
    }

    @JsonProperty
    public int getNumQueuedQueries() {
        return this.numQueuedQueries;
    }

    @JsonProperty
    public int getNumRunningQueries() {
        return this.numRunningQueries;
    }

    @JsonProperty
    @Deprecated
    public int numAggregatedQueuedQueries() {
        return this.numQueuedQueries;
    }

    @JsonProperty
    @Deprecated
    public int numAggregatedRunningQueries() {
        return this.numRunningQueries;
    }

    @Deprecated
    @JsonProperty
    public int getNumEligibleSubGroups() {
        return this.numEligibleSubGroups;
    }

    @JsonProperty
    @Nullable
    public List<QueryStateInfo> getRunningQueries() {
        return this.runningQueries;
    }

    @JsonProperty
    @Nullable
    public List<ResourceGroupInfo> getSubGroups() {
        return this.subGroups;
    }
}

