/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.dispatcher.DispatchManager;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.resourceGroups.ResourceGroupManager;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.resourcemanager.ResourceManagerProxy;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.QueryStateInfo;
import com.facebook.presto.server.ServerConfig;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1/queryState")
@RolesAllowed(value={"admin", "user"})
public class QueryStateInfoResource {
    private final DispatchManager dispatchManager;
    private final ResourceGroupManager<?> resourceGroupManager;
    private final boolean resourceManagerEnabled;
    private final InternalNodeManager internalNodeManager;
    private final Optional<ResourceManagerProxy> proxyHelper;

    @Inject
    public QueryStateInfoResource(DispatchManager dispatchManager, ResourceGroupManager<?> resourceGroupManager, InternalNodeManager internalNodeManager, ServerConfig serverConfig, Optional<ResourceManagerProxy> proxyHelper) {
        this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
        this.resourceGroupManager = Objects.requireNonNull(resourceGroupManager, "resourceGroupManager is null");
        this.internalNodeManager = Objects.requireNonNull(internalNodeManager, "internalNodeManager is null");
        this.resourceManagerEnabled = Objects.requireNonNull(serverConfig, "serverConfig is null").isResourceManagerEnabled();
        this.proxyHelper = Objects.requireNonNull(proxyHelper, "proxyHelper is null");
    }

    @GET
    @Produces(value={"application/json"})
    public void getQueryStateInfos(@QueryParam(value="user") String user, @QueryParam(value="includeLocalQueryOnly") @DefaultValue(value="false") boolean isIncludeLocalQueryOnly, @HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @Context UriInfo uriInfo, @Context HttpServletRequest servletRequest, @Suspended AsyncResponse asyncResponse) {
        if (this.resourceManagerEnabled && !isIncludeLocalQueryOnly) {
            this.proxyQueryStateInfo(servletRequest, asyncResponse, xForwardedProto, uriInfo);
        } else {
            List queryInfos = this.dispatchManager.getQueries();
            if (!Strings.isNullOrEmpty((String)user)) {
                queryInfos = (List)queryInfos.stream().filter(queryInfo -> Pattern.matches(user, queryInfo.getSession().getUser())).collect(ImmutableList.toImmutableList());
            }
            asyncResponse.resume((Object)Response.ok(queryInfos.stream().filter(queryInfo -> !queryInfo.getState().isDone()).map(this::getQueryStateInfo).collect(ImmutableList.toImmutableList())).build());
        }
    }

    private QueryStateInfo getQueryStateInfo(BasicQueryInfo queryInfo) {
        Optional<ResourceGroupId> groupId = queryInfo.getResourceGroupId();
        if (queryInfo.getState() == QueryState.QUEUED) {
            return QueryStateInfo.createQueuedQueryStateInfo(queryInfo, groupId, groupId.map(this.resourceGroupManager::getPathToRoot));
        }
        return QueryStateInfo.createQueryStateInfo(queryInfo, groupId);
    }

    @GET
    @Path(value="{queryId}")
    @Produces(value={"application/json"})
    public void getQueryStateInfo(@PathParam(value="queryId") String queryId, @HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @Context UriInfo uriInfo, @Context HttpServletRequest servletRequest, @Suspended AsyncResponse asyncResponse) throws WebApplicationException {
        try {
            QueryId queryID = new QueryId(queryId);
            if (this.resourceManagerEnabled && !this.dispatchManager.isQueryPresent(queryID)) {
                this.proxyQueryStateInfo(servletRequest, asyncResponse, xForwardedProto, uriInfo);
            } else {
                BasicQueryInfo queryInfo = this.dispatchManager.getQueryInfo(queryID);
                asyncResponse.resume((Object)Response.ok((Object)this.getQueryStateInfo(queryInfo)).build());
            }
        }
        catch (NoSuchElementException e) {
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
        }
    }

    private void proxyQueryStateInfo(HttpServletRequest servletRequest, AsyncResponse asyncResponse, String xForwardedProto, UriInfo uriInfo) {
        try {
            Preconditions.checkState((boolean)this.proxyHelper.isPresent());
            Iterator<InternalNode> resourceManagers = this.internalNodeManager.getResourceManagers().iterator();
            if (!resourceManagers.hasNext()) {
                asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build());
                return;
            }
            InternalNode resourceManagerNode = resourceManagers.next();
            URI uri = uriInfo.getRequestUriBuilder().scheme(resourceManagerNode.getInternalUri().getScheme()).host(resourceManagerNode.getHostAndPort().toInetAddress().getHostName()).port(resourceManagerNode.getInternalUri().getPort()).build(new Object[0]);
            this.proxyHelper.get().performRequest(servletRequest, asyncResponse, uri);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)e);
        }
    }
}

