/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.http.client.HttpRequestFilter;
import com.facebook.airlift.http.client.Request;
import com.google.common.annotations.VisibleForTesting;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class GenerateTraceTokenRequestFilter
implements HttpRequestFilter {
    private static final int SEQUENCE_NUMBER_HEX_LENGTH = 10;
    private final String prefix = UUID.randomUUID().toString().toLowerCase(Locale.ENGLISH).replace("-", "");
    private final AtomicLong sequence = new AtomicLong();

    public Request filterRequest(Request request) {
        Objects.requireNonNull(request, "request is null");
        return Request.Builder.fromRequest((Request)request).setHeader("X-Airlift-Tracetoken", this.createToken(this.sequence.getAndIncrement())).build();
    }

    private String createToken(long value) {
        StringBuilder builder = new StringBuilder(this.prefix.length() + 10).append(this.prefix);
        String sequenceNumHex = Long.toHexString(value);
        for (int i = sequenceNumHex.length(); i < 10; ++i) {
            builder.append('0');
        }
        return builder.append(sequenceNumHex).toString();
    }

    @VisibleForTesting
    String getLastToken() {
        long value = this.sequence.get();
        return this.createToken(value - 1L);
    }
}

