/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.operator.BlockedReason;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;

@ThriftStruct
@Immutable
public class BasicQueryStats {
    private final DateTime createTime;
    private final DateTime endTime;
    private final Duration waitingForPrerequisitesTime;
    private final Duration queuedTime;
    private final Duration elapsedTime;
    private final Duration executionTime;
    private final int runningTasks;
    private final int peakRunningTasks;
    private final int totalDrivers;
    private final int queuedDrivers;
    private final int runningDrivers;
    private final int completedDrivers;
    private final DataSize rawInputDataSize;
    private final long rawInputPositions;
    private final double cumulativeUserMemory;
    private final double cumulativeTotalMemory;
    private final DataSize userMemoryReservation;
    private final DataSize totalMemoryReservation;
    private final DataSize peakUserMemoryReservation;
    private final DataSize peakTotalMemoryReservation;
    private final DataSize peakTaskTotalMemoryReservation;
    private final DataSize peakNodeTotalMemoryReservation;
    private final Duration totalCpuTime;
    private final Duration totalScheduledTime;
    private final boolean fullyBlocked;
    private final Set<BlockedReason> blockedReasons;
    private final DataSize totalAllocation;
    private final OptionalDouble progressPercentage;

    @ThriftConstructor
    @JsonCreator
    public BasicQueryStats(@JsonProperty(value="createTime") DateTime createTime, @JsonProperty(value="endTime") DateTime endTime, @JsonProperty(value="waitingForPrerequisitesTime") Duration waitingForPrerequisitesTime, @JsonProperty(value="queuedTime") Duration queuedTime, @JsonProperty(value="elapsedTime") Duration elapsedTime, @JsonProperty(value="executionTime") Duration executionTime, @JsonProperty(value="runningTasks") int runningTasks, @JsonProperty(value="peakRunningTasks") int peakRunningTasks, @JsonProperty(value="totalDrivers") int totalDrivers, @JsonProperty(value="queuedDrivers") int queuedDrivers, @JsonProperty(value="runningDrivers") int runningDrivers, @JsonProperty(value="completedDrivers") int completedDrivers, @JsonProperty(value="rawInputDataSize") DataSize rawInputDataSize, @JsonProperty(value="rawInputPositions") long rawInputPositions, @JsonProperty(value="cumulativeUserMemory") double cumulativeUserMemory, @JsonProperty(value="cumulativeTotalMemory") double cumulativeTotalMemory, @JsonProperty(value="userMemoryReservation") DataSize userMemoryReservation, @JsonProperty(value="totalMemoryReservation") DataSize totalMemoryReservation, @JsonProperty(value="peakUserMemoryReservation") DataSize peakUserMemoryReservation, @JsonProperty(value="peakTotalMemoryReservation") DataSize peakTotalMemoryReservation, @JsonProperty(value="peakTaskTotalMemoryReservation") DataSize peakTaskTotalMemoryReservation, @JsonProperty(value="peakNodeTotalMemoryReservation") DataSize peakNodeTotalMemoryReservation, @JsonProperty(value="totalCpuTime") Duration totalCpuTime, @JsonProperty(value="totalScheduledTime") Duration totalScheduledTime, @JsonProperty(value="fullyBlocked") boolean fullyBlocked, @JsonProperty(value="blockedReasons") Set<BlockedReason> blockedReasons, @JsonProperty(value="totalAllocation") DataSize totalAllocation, @JsonProperty(value="progressPercentage") OptionalDouble progressPercentage) {
        this.createTime = createTime;
        this.endTime = endTime;
        this.waitingForPrerequisitesTime = Objects.requireNonNull(waitingForPrerequisitesTime, "waitingForPrerequisitesTimex is null");
        this.queuedTime = Objects.requireNonNull(queuedTime, "queuedTime is null");
        this.elapsedTime = Objects.requireNonNull(elapsedTime, "elapsedTime is null");
        this.executionTime = Objects.requireNonNull(executionTime, "executionTime is null");
        this.runningTasks = runningTasks;
        this.peakRunningTasks = peakRunningTasks;
        Preconditions.checkArgument((totalDrivers >= 0 ? 1 : 0) != 0, (Object)"totalDrivers is negative");
        this.totalDrivers = totalDrivers;
        Preconditions.checkArgument((queuedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedDrivers is negative");
        this.queuedDrivers = queuedDrivers;
        Preconditions.checkArgument((runningDrivers >= 0 ? 1 : 0) != 0, (Object)"runningDrivers is negative");
        this.runningDrivers = runningDrivers;
        Preconditions.checkArgument((completedDrivers >= 0 ? 1 : 0) != 0, (Object)"completedDrivers is negative");
        this.completedDrivers = completedDrivers;
        this.rawInputDataSize = Objects.requireNonNull(rawInputDataSize);
        this.rawInputPositions = rawInputPositions;
        this.cumulativeUserMemory = cumulativeUserMemory;
        this.cumulativeTotalMemory = cumulativeTotalMemory;
        this.userMemoryReservation = userMemoryReservation;
        this.totalMemoryReservation = totalMemoryReservation;
        this.peakUserMemoryReservation = peakUserMemoryReservation;
        this.peakTotalMemoryReservation = peakTotalMemoryReservation;
        this.peakTaskTotalMemoryReservation = peakTaskTotalMemoryReservation;
        this.peakNodeTotalMemoryReservation = peakNodeTotalMemoryReservation;
        this.totalCpuTime = totalCpuTime;
        this.totalScheduledTime = totalScheduledTime;
        this.fullyBlocked = fullyBlocked;
        this.blockedReasons = ImmutableSet.copyOf((Collection)Objects.requireNonNull(blockedReasons, "blockedReasons is null"));
        this.totalAllocation = Objects.requireNonNull(totalAllocation, "totalAllocation is null");
        this.progressPercentage = Objects.requireNonNull(progressPercentage, "progressPercentage is null");
    }

    public BasicQueryStats(QueryStats queryStats) {
        this(queryStats.getCreateTime(), queryStats.getEndTime(), queryStats.getWaitingForPrerequisitesTime(), queryStats.getQueuedTime(), queryStats.getElapsedTime(), queryStats.getExecutionTime(), queryStats.getRunningTasks(), queryStats.getPeakRunningTasks(), queryStats.getTotalDrivers(), queryStats.getQueuedDrivers(), queryStats.getRunningDrivers(), queryStats.getCompletedDrivers(), queryStats.getRawInputDataSize(), queryStats.getRawInputPositions(), queryStats.getCumulativeUserMemory(), queryStats.getCumulativeTotalMemory(), queryStats.getUserMemoryReservation(), queryStats.getTotalMemoryReservation(), queryStats.getPeakUserMemoryReservation(), queryStats.getPeakTotalMemoryReservation(), queryStats.getPeakTaskTotalMemory(), queryStats.getPeakNodeTotalMemory(), queryStats.getTotalCpuTime(), queryStats.getTotalScheduledTime(), queryStats.isFullyBlocked(), queryStats.getBlockedReasons(), queryStats.getTotalAllocation(), queryStats.getProgressPercentage());
    }

    public static BasicQueryStats immediateFailureQueryStats() {
        DateTime now = DateTime.now();
        return new BasicQueryStats(now, now, new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), 0, 0, 0, 0, 0, 0, new DataSize(0.0, DataSize.Unit.BYTE), 0L, 0.0, 0.0, new DataSize(0.0, DataSize.Unit.BYTE), new DataSize(0.0, DataSize.Unit.BYTE), new DataSize(0.0, DataSize.Unit.BYTE), new DataSize(0.0, DataSize.Unit.BYTE), new DataSize(0.0, DataSize.Unit.BYTE), new DataSize(0.0, DataSize.Unit.BYTE), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), false, (Set<BlockedReason>)ImmutableSet.of(), new DataSize(0.0, DataSize.Unit.BYTE), OptionalDouble.empty());
    }

    @ThriftField(value=1)
    @JsonProperty
    public DateTime getCreateTime() {
        return this.createTime;
    }

    @ThriftField(value=2)
    @JsonProperty
    public DateTime getEndTime() {
        return this.endTime;
    }

    @ThriftField(value=3)
    @JsonProperty
    public Duration getQueuedTime() {
        return this.queuedTime;
    }

    @ThriftField(value=4)
    @JsonProperty
    public Duration getElapsedTime() {
        return this.elapsedTime;
    }

    @ThriftField(value=5)
    @JsonProperty
    public Duration getExecutionTime() {
        return this.executionTime;
    }

    @ThriftField(value=6)
    @JsonProperty
    public int getTotalDrivers() {
        return this.totalDrivers;
    }

    @ThriftField(value=7)
    @JsonProperty
    public int getQueuedDrivers() {
        return this.queuedDrivers;
    }

    @ThriftField(value=8)
    @JsonProperty
    public int getRunningDrivers() {
        return this.runningDrivers;
    }

    @ThriftField(value=9)
    @JsonProperty
    public int getCompletedDrivers() {
        return this.completedDrivers;
    }

    @ThriftField(value=10)
    @JsonProperty
    public DataSize getRawInputDataSize() {
        return this.rawInputDataSize;
    }

    @ThriftField(value=11)
    @JsonProperty
    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    @ThriftField(value=12)
    @JsonProperty
    public double getCumulativeUserMemory() {
        return this.cumulativeUserMemory;
    }

    @ThriftField(value=13)
    @JsonProperty
    public DataSize getUserMemoryReservation() {
        return this.userMemoryReservation;
    }

    @ThriftField(value=14)
    @JsonProperty
    public DataSize getTotalMemoryReservation() {
        return this.totalMemoryReservation;
    }

    @ThriftField(value=15)
    public int getPeakRunningTasks() {
        return this.peakRunningTasks;
    }

    @ThriftField(value=16)
    @JsonProperty
    public DataSize getPeakUserMemoryReservation() {
        return this.peakUserMemoryReservation;
    }

    @ThriftField(value=17)
    @JsonProperty
    public DataSize getPeakTotalMemoryReservation() {
        return this.peakTotalMemoryReservation;
    }

    @ThriftField(value=18)
    @JsonProperty
    public DataSize getPeakTaskTotalMemoryReservation() {
        return this.peakTaskTotalMemoryReservation;
    }

    @ThriftField(value=19, name="peakNodeTotalMemoryReservation")
    @JsonProperty
    public DataSize getPeakNodeTotalMemorReservation() {
        return this.peakNodeTotalMemoryReservation;
    }

    @ThriftField(value=20)
    @JsonProperty
    public Duration getTotalCpuTime() {
        return this.totalCpuTime;
    }

    @ThriftField(value=21)
    @JsonProperty
    public Duration getTotalScheduledTime() {
        return this.totalScheduledTime;
    }

    @ThriftField(value=22)
    @JsonProperty
    public boolean isFullyBlocked() {
        return this.fullyBlocked;
    }

    @ThriftField(value=23)
    @JsonProperty
    public Set<BlockedReason> getBlockedReasons() {
        return this.blockedReasons;
    }

    @ThriftField(value=24)
    @JsonProperty
    public DataSize getTotalAllocation() {
        return this.totalAllocation;
    }

    @ThriftField(value=25)
    @JsonProperty
    public OptionalDouble getProgressPercentage() {
        return this.progressPercentage;
    }

    @ThriftField(value=26)
    @JsonProperty
    public Duration getWaitingForPrerequisitesTime() {
        return this.waitingForPrerequisitesTime;
    }

    @ThriftField(value=27)
    @JsonProperty
    public double getCumulativeTotalMemory() {
        return this.cumulativeTotalMemory;
    }

    @ThriftField(value=28)
    @JsonProperty
    public int getRunningTasks() {
        return this.runningTasks;
    }
}

