/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.unnest;

import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.array.Arrays;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.LongArrayBlock;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.repartition.PartitionedOutputOperator;
import com.facebook.presto.operator.unnest.ArrayOfRowsUnnester;
import com.facebook.presto.operator.unnest.ArrayUnnester;
import com.facebook.presto.operator.unnest.MapUnnester;
import com.facebook.presto.operator.unnest.ReplicatedBlockBuilder;
import com.facebook.presto.operator.unnest.Unnester;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class UnnestOperator
implements Operator {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(UnnestOperator.class).instanceSize();
    private static final int MAX_ROWS_PER_BLOCK = 1000;
    private final OperatorContext operatorContext;
    private final LocalMemoryContext systemMemoryContext;
    private final List<Integer> replicateChannels;
    private final List<Type> replicateTypes;
    private final List<ReplicatedBlockBuilder> replicatedBlockBuilders;
    private final List<Integer> unnestChannels;
    private final List<Type> unnestTypes;
    private final List<Unnester> unnesters;
    private final boolean withOrdinality;
    private final int outputChannelCount;
    private boolean finishing;
    private Page currentPage;
    private int currentPosition;
    private int[] maxLengths = new int[0];
    private int currentBatchTotalLength;

    public UnnestOperator(OperatorContext operatorContext, List<Integer> replicateChannels, List<Type> replicateTypes, List<Integer> unnestChannels, List<Type> unnestTypes, boolean withOrdinality, boolean isLegacyUnnest) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.systemMemoryContext = operatorContext.newLocalSystemMemoryContext(PartitionedOutputOperator.class.getSimpleName());
        this.replicateChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(replicateChannels, "replicateChannels is null"));
        this.replicateTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(replicateTypes, "replicateTypes is null"));
        Preconditions.checkArgument((replicateChannels.size() == replicateTypes.size() ? 1 : 0) != 0, (Object)"replicate channels or types has wrong size");
        this.replicatedBlockBuilders = (List)replicateTypes.stream().map(type -> new ReplicatedBlockBuilder()).collect(ImmutableList.toImmutableList());
        this.unnestChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(unnestChannels, "unnestChannels is null"));
        this.unnestTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(unnestTypes, "unnestTypes is null"));
        Preconditions.checkArgument((unnestChannels.size() == unnestTypes.size() ? 1 : 0) != 0, (Object)"unnest channels or types has wrong size");
        this.unnesters = (List)unnestTypes.stream().map(nestedType -> UnnestOperator.createUnnester(nestedType, isLegacyUnnest)).collect(ImmutableList.toImmutableList());
        this.withOrdinality = withOrdinality;
        this.outputChannelCount = this.unnesters.stream().mapToInt(Unnester::getChannelCount).sum() + replicateTypes.size() + (withOrdinality ? 1 : 0);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.currentPage == null;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.currentPage == null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((this.currentPage == null ? 1 : 0) != 0, (Object)"currentPage is not null");
        this.currentPage = page;
        this.currentPosition = 0;
        this.resetBlockBuilders();
        this.systemMemoryContext.setBytes(this.getRetainedSizeInBytes());
    }

    @Override
    public Page getOutput() {
        if (this.currentPage == null) {
            return null;
        }
        int positionCount = this.currentPage.getPositionCount();
        int batchSize = this.calculateNextBatchSize();
        Block[] outputBlocks = this.buildOutputBlocks(batchSize);
        if (this.currentPosition == positionCount) {
            this.currentPage = null;
            this.currentPosition = 0;
        }
        return new Page(outputBlocks);
    }

    private static Unnester createUnnester(Type nestedType, boolean isLegacyUnnest) {
        if (nestedType instanceof ArrayType) {
            Type elementType = ((ArrayType)nestedType).getElementType();
            if (!isLegacyUnnest && elementType instanceof RowType) {
                return new ArrayOfRowsUnnester(elementType.getTypeParameters().size());
            }
            return new ArrayUnnester();
        }
        if (nestedType instanceof MapType) {
            return new MapUnnester();
        }
        throw new IllegalArgumentException("Cannot unnest type: " + nestedType);
    }

    private void resetBlockBuilders() {
        for (int i = 0; i < this.replicateTypes.size(); ++i) {
            Block newInputBlock = this.currentPage.getBlock(this.replicateChannels.get(i).intValue());
            this.replicatedBlockBuilders.get(i).resetInputBlock(newInputBlock);
        }
        int positionCount = this.currentPage.getPositionCount();
        this.maxLengths = Arrays.ensureCapacity((int[])this.maxLengths, (int)positionCount, (Arrays.ExpansionFactor)Arrays.ExpansionFactor.SMALL, (Arrays.ExpansionOption)Arrays.ExpansionOption.INITIALIZE);
        for (int i = 0; i < this.unnestTypes.size(); ++i) {
            int inputChannel = this.unnestChannels.get(i);
            Block unnestChannelInputBlock = this.currentPage.getBlock(inputChannel);
            Unnester unnester = this.unnesters.get(i);
            unnester.resetInput(unnestChannelInputBlock);
            int[] lengths = unnester.getLengths();
            for (int j = 0; j < positionCount; ++j) {
                this.maxLengths[j] = Integer.max(this.maxLengths[j], lengths[j]);
            }
        }
    }

    private int calculateNextBatchSize() {
        int length;
        int position;
        int positionCount = this.currentPage.getPositionCount();
        int totalLengths = 0;
        for (position = this.currentPosition; position < positionCount && totalLengths + (length = this.maxLengths[position]) < 1000; ++position) {
            totalLengths += length;
        }
        if (position == this.currentPosition) {
            this.currentBatchTotalLength = this.maxLengths[this.currentPosition];
            return 1;
        }
        this.currentBatchTotalLength = totalLengths;
        return position - this.currentPosition;
    }

    private Block[] buildOutputBlocks(int batchSize) {
        Block[] outputBlocks = new Block[this.outputChannelCount];
        int channel = 0;
        for (int replicateIndex = 0; replicateIndex < this.replicateTypes.size(); ++replicateIndex) {
            outputBlocks[channel++] = this.replicatedBlockBuilders.get(replicateIndex).buildOutputBlock(this.maxLengths, this.currentPosition, batchSize, this.currentBatchTotalLength);
        }
        for (int unnestIndex = 0; unnestIndex < this.unnesters.size(); ++unnestIndex) {
            Unnester unnester = this.unnesters.get(unnestIndex);
            Block[] block = unnester.buildOutputBlocks(this.maxLengths, this.currentPosition, batchSize, this.currentBatchTotalLength);
            for (int j = 0; j < unnester.getChannelCount(); ++j) {
                outputBlocks[channel++] = block[j];
            }
        }
        if (this.withOrdinality) {
            outputBlocks[channel] = UnnestOperator.buildOrdinalityOutputBlock(this.maxLengths, this.currentPosition, batchSize, this.currentBatchTotalLength);
        }
        this.currentPosition += batchSize;
        return outputBlocks;
    }

    private static Block buildOrdinalityOutputBlock(int[] maxEntries, int offset, int length, int totalEntriesForBatch) {
        long[] values = new long[totalEntriesForBatch];
        int index = 0;
        for (int i = 0; i < length; ++i) {
            int curEntries = maxEntries[offset + i];
            for (int j = 1; j <= curEntries; ++j) {
                values[index++] = j;
            }
        }
        return new LongArrayBlock(totalEntriesForBatch, Optional.empty(), values);
    }

    private long getRetainedSizeInBytes() {
        long size = (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.maxLengths) + this.currentPage.getRetainedSizeInBytes();
        for (Unnester unnester : this.unnesters) {
            size += unnester.getRetainedSizeInBytes();
        }
        return size;
    }

    public static class UnnestOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Integer> replicateChannels;
        private final List<Type> replicateTypes;
        private final List<Integer> unnestChannels;
        private final List<Type> unnestTypes;
        private final boolean withOrdinality;
        private boolean closed;

        public UnnestOperatorFactory(int operatorId, PlanNodeId planNodeId, List<Integer> replicateChannels, List<Type> replicateTypes, List<Integer> unnestChannels, List<Type> unnestTypes, boolean withOrdinality) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.replicateChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(replicateChannels, "replicateChannels is null"));
            this.replicateTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(replicateTypes, "replicateTypes is null"));
            Preconditions.checkArgument((replicateChannels.size() == replicateTypes.size() ? 1 : 0) != 0, (Object)"replicateChannels and replicateTypes do not match");
            this.unnestChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(unnestChannels, "unnestChannels is null"));
            this.unnestTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(unnestTypes, "unnestTypes is null"));
            Preconditions.checkArgument((unnestChannels.size() == unnestTypes.size() ? 1 : 0) != 0, (Object)"unnestChannels and unnestTypes do not match");
            this.withOrdinality = withOrdinality;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            return this.createOperator(driverContext, SystemSessionProperties.isLegacyUnnest(driverContext.getSession()));
        }

        @VisibleForTesting
        public Operator createOperator(DriverContext driverContext, boolean legacyUnnest) {
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, UnnestOperator.class.getSimpleName());
            return new UnnestOperator(operatorContext, this.replicateChannels, this.replicateTypes, this.unnestChannels, this.unnestTypes, this.withOrdinality, legacyUnnest);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new UnnestOperatorFactory(this.operatorId, this.planNodeId, this.replicateChannels, this.replicateTypes, this.unnestChannels, this.unnestTypes, this.withOrdinality);
        }
    }
}

