/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar.annotations;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SignatureBinder;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.annotations.FunctionsParserHelper;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementationChoice;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.BlockPosition;
import com.facebook.presto.spi.function.CodegenScalarFunction;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.function.SqlInvokedScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.sql.gen.lambda.BinaryFunctionInterface;
import com.facebook.presto.sql.gen.lambda.UnaryFunctionInterface;
import com.facebook.presto.util.Failures;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class CodegenScalarFromAnnotationsParser {
    private CodegenScalarFromAnnotationsParser() {
    }

    public static List<SqlScalarFunction> parseFunctionDefinitions(Class<?> clazz) {
        return (List)CodegenScalarFromAnnotationsParser.findScalarsInFunctionDefinitionClass(clazz).stream().map(method -> CodegenScalarFromAnnotationsParser.createSqlScalarFunction(method)).collect(ImmutableList.toImmutableList());
    }

    private static List<Method> findScalarsInFunctionDefinitionClass(Class<?> clazz) {
        Set<Method> methods = FunctionsParserHelper.findPublicStaticMethods(clazz, (Set<Class<? extends Annotation>>)ImmutableSet.of(CodegenScalarFunction.class), (Set<Class<? extends Annotation>>)ImmutableSet.of(ScalarFunction.class, ScalarOperator.class, SqlInvokedScalarFunction.class));
        for (Method method : methods) {
            Failures.checkCondition(method.isAnnotationPresent(SqlType.class), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Function-defining method [%s] is missing @SqlType", method);
            Failures.checkCondition(method.getReturnType().equals(MethodHandle.class), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Function-defining method [%s] must return MethodHandle", method);
        }
        return ImmutableList.copyOf(methods);
    }

    private static List<ScalarFunctionImplementationChoice.ArgumentProperty> getArgumentProperties(Method method) {
        return (List)Arrays.stream(method.getParameters()).map(p -> {
            Failures.checkCondition(p.getType() == Type.class, (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Codegen scalar function %s must have paramter [%s] of type Type", method, p.getName());
            Failures.checkCondition(((BlockPosition[])p.getAnnotationsByType(BlockPosition.class)).length == 0, (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Block and Position format is not supported for codegen function %s", method);
            Failures.checkCondition(((IsNull[])p.getAnnotationsByType(IsNull.class)).length == 0, (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Null flag format is not supported for codegen function %s", method);
            TypeSignature signature = TypeSignature.parseTypeSignature((String)p.getAnnotation(SqlType.class).value());
            if (signature.isFunction()) {
                int params = signature.getParameters().size();
                Failures.checkCondition(params == 2 || params == 3, (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Only unary and binary functions are supported in codegen function %s", method);
                return ScalarFunctionImplementationChoice.ArgumentProperty.functionTypeArgumentProperty(params == 2 ? UnaryFunctionInterface.class : BinaryFunctionInterface.class);
            }
            return ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty(p.getAnnotation(SqlNullable.class) == null ? ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL : ScalarFunctionImplementationChoice.NullConvention.USE_BOXED_TYPE);
        }).collect(ImmutableList.toImmutableList());
    }

    private static SqlScalarFunction createSqlScalarFunction(final Method method) {
        final CodegenScalarFunction codegenScalarFunction = method.getAnnotation(CodegenScalarFunction.class);
        final Signature signature = new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)codegenScalarFunction.value()), FunctionKind.SCALAR, (List)Arrays.stream(method.getAnnotationsByType(TypeParameter.class)).map(t -> Signature.withVariadicBound((String)t.value(), (String)(t.boundedBy().isEmpty() ? null : t.boundedBy()))).collect(ImmutableList.toImmutableList()), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)method.getAnnotation(SqlType.class).value()), (List)Arrays.stream(method.getParameters()).map(p -> TypeSignature.parseTypeSignature((String)p.getAnnotation(SqlType.class).value())).collect(ImmutableList.toImmutableList()), false);
        return new SqlScalarFunction(signature){

            @Override
            public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
                MethodHandle handle;
                Signature boundSignature = SignatureBinder.applyBoundVariables(signature, boundVariables, arity);
                try {
                    handle = (MethodHandle)method.invoke(null, boundSignature.getArgumentTypes().stream().map(t -> functionAndTypeManager.getType((TypeSignature)t)).toArray());
                }
                catch (Exception e) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format("Method %s does not return valid MethodHandle", method), (Throwable)e);
                }
                return new BuiltInScalarFunctionImplementation(method.getAnnotation(SqlNullable.class) != null, CodegenScalarFromAnnotationsParser.getArgumentProperties(method), handle, Optional.empty());
            }

            public SqlFunctionVisibility getVisibility() {
                return codegenScalarFunction.visibility();
            }

            public boolean isDeterministic() {
                return codegenScalarFunction.deterministic();
            }

            public String getDescription() {
                Description description = method.getAnnotation(Description.class);
                return description == null ? "" : description.value();
            }

            @Override
            public boolean isCalledOnNullInput() {
                return codegenScalarFunction.calledOnNullInput();
            }
        };
    }
}

