/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementationChoice;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.sql.gen.lambda.BinaryFunctionInterface;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public final class ZipWithFunction
extends SqlScalarFunction {
    public static final ZipWithFunction ZIP_WITH_FUNCTION = new ZipWithFunction();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ZipWithFunction.class, "zipWith", Type.class, Type.class, ArrayType.class, Object.class, Block.class, Block.class, BinaryFunctionInterface.class);
    private static final MethodHandle STATE_FACTORY = Reflection.methodHandle(ZipWithFunction.class, "createState", ArrayType.class);

    private ZipWithFunction() {
        super(new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"zip_with"), FunctionKind.SCALAR, (List)ImmutableList.of((Object)Signature.typeVariable((String)"T"), (Object)Signature.typeVariable((String)"U"), (Object)Signature.typeVariable((String)"R")), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"array(R)"), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"array(T)"), (Object)TypeSignature.parseTypeSignature((String)"array(U)"), (Object)TypeSignature.parseTypeSignature((String)"function(T,U,R)")), false));
    }

    public SqlFunctionVisibility getVisibility() {
        return SqlFunctionVisibility.PUBLIC;
    }

    public boolean isDeterministic() {
        return false;
    }

    public String getDescription() {
        return "merge two arrays, element-wise, into a single array using the lambda function";
    }

    @Override
    public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Type leftElementType = boundVariables.getTypeVariable("T");
        Type rightElementType = boundVariables.getTypeVariable("U");
        Type outputElementType = boundVariables.getTypeVariable("R");
        ArrayType outputArrayType = new ArrayType(outputElementType);
        return new BuiltInScalarFunctionImplementation(false, (List<ScalarFunctionImplementationChoice.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementationChoice.ArgumentProperty.functionTypeArgumentProperty(BinaryFunctionInterface.class)), METHOD_HANDLE.bindTo(leftElementType).bindTo(rightElementType).bindTo(outputArrayType), Optional.of(STATE_FACTORY.bindTo(outputArrayType)));
    }

    public static Object createState(ArrayType arrayType) {
        return new PageBuilder((List)ImmutableList.of((Object)arrayType));
    }

    public static Block zipWith(Type leftElementType, Type rightElementType, ArrayType outputArrayType, Object state, Block leftBlock, Block rightBlock, BinaryFunctionInterface function) {
        Type outputElementType = outputArrayType.getElementType();
        int leftPositionCount = leftBlock.getPositionCount();
        int rightPositionCount = rightBlock.getPositionCount();
        int outputPositionCount = Math.max(leftPositionCount, rightPositionCount);
        PageBuilder pageBuilder = (PageBuilder)state;
        if (pageBuilder.isFull()) {
            pageBuilder.reset();
        }
        BlockBuilder arrayBlockBuilder = pageBuilder.getBlockBuilder(0);
        BlockBuilder blockBuilder = arrayBlockBuilder.beginBlockEntry();
        for (int position = 0; position < outputPositionCount; ++position) {
            Object output;
            Object left = position < leftPositionCount ? TypeUtils.readNativeValue((Type)leftElementType, (Block)leftBlock, (int)position) : null;
            Object right = position < rightPositionCount ? TypeUtils.readNativeValue((Type)rightElementType, (Block)rightBlock, (int)position) : null;
            try {
                output = function.apply(left, right);
            }
            catch (Throwable throwable) {
                arrayBlockBuilder.closeEntry();
                pageBuilder.declarePosition();
                Throwables.throwIfUnchecked((Throwable)throwable);
                throw new RuntimeException(throwable);
            }
            TypeUtils.writeNativeValue((Type)outputElementType, (BlockBuilder)blockBuilder, (Object)output);
        }
        arrayBlockBuilder.closeEntry();
        pageBuilder.declarePosition();
        return outputArrayType.getObject((Block)arrayBlockBuilder, arrayBlockBuilder.getPositionCount() - 1);
    }
}

