/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.CallSiteBinder;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.ForLoop;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.VariableInstruction;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.aggregation.TypedSet;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementationChoice;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.sql.gen.SqlTypeBytecodeExpression;
import com.facebook.presto.sql.gen.lambda.BinaryFunctionInterface;
import com.facebook.presto.util.CompilerUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public final class MapTransformKeyFunction
extends SqlScalarFunction {
    public static final MapTransformKeyFunction MAP_TRANSFORM_KEY_FUNCTION = new MapTransformKeyFunction();
    private static final MethodHandle STATE_FACTORY = Reflection.methodHandle(MapTransformKeyFunction.class, "createState", MapType.class);

    private MapTransformKeyFunction() {
        super(new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"transform_keys"), FunctionKind.SCALAR, (List)ImmutableList.of((Object)Signature.typeVariable((String)"K1"), (Object)Signature.typeVariable((String)"K2"), (Object)Signature.typeVariable((String)"V")), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"map(K2,V)"), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"map(K1,V)"), (Object)TypeSignature.parseTypeSignature((String)"function(K1,V,K2)")), false));
    }

    public SqlFunctionVisibility getVisibility() {
        return SqlFunctionVisibility.PUBLIC;
    }

    public boolean isDeterministic() {
        return false;
    }

    public String getDescription() {
        return "apply lambda to each entry of the map and transform the key";
    }

    @Override
    public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Type keyType = boundVariables.getTypeVariable("K1");
        Type transformedKeyType = boundVariables.getTypeVariable("K2");
        Type valueType = boundVariables.getTypeVariable("V");
        MapType resultMapType = (MapType)functionAndTypeManager.getParameterizedType("map", (List<TypeSignatureParameter>)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)transformedKeyType.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)valueType.getTypeSignature())));
        return new BuiltInScalarFunctionImplementation(false, (List<ScalarFunctionImplementationChoice.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementationChoice.ArgumentProperty.functionTypeArgumentProperty(BinaryFunctionInterface.class)), MapTransformKeyFunction.generateTransformKey(keyType, transformedKeyType, valueType, (Type)resultMapType), Optional.of(STATE_FACTORY.bindTo(resultMapType)));
    }

    @UsedByGeneratedCode
    public static Object createState(MapType mapType) {
        return new PageBuilder((List)ImmutableList.of((Object)mapType));
    }

    private static MethodHandle generateTransformKey(Type keyType, Type transformedKeyType, Type valueType, Type resultMapType) {
        BytecodeBlock throwDuplicatedKeyException;
        BytecodeBlock writeKeyElement;
        CallSiteBinder binder = new CallSiteBinder();
        Class keyJavaType = Primitives.wrap((Class)keyType.getJavaType());
        Class transformedKeyJavaType = Primitives.wrap((Class)transformedKeyType.getJavaType());
        Class valueJavaType = Primitives.wrap((Class)valueType.getJavaType());
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("MapTransformKey"), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        definition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PRIVATE}));
        Parameter state = Parameter.arg((String)"state", Object.class);
        Parameter properties = Parameter.arg((String)"properties", SqlFunctionProperties.class);
        Parameter block = Parameter.arg((String)"block", Block.class);
        Parameter function = Parameter.arg((String)"function", BinaryFunctionInterface.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "transform", ParameterizedType.type(Block.class), (Iterable)ImmutableList.of((Object)state, (Object)properties, (Object)block, (Object)function));
        BytecodeBlock body = method.getBody();
        Scope scope = method.getScope();
        Variable positionCount = scope.declareVariable(Integer.TYPE, "positionCount");
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        Variable pageBuilder = scope.declareVariable(PageBuilder.class, "pageBuilder");
        Variable mapBlockBuilder = scope.declareVariable(BlockBuilder.class, "mapBlockBuilder");
        Variable blockBuilder = scope.declareVariable(BlockBuilder.class, "blockBuilder");
        Variable typedSet = scope.declareVariable(TypedSet.class, "typeSet");
        Variable keyElement = scope.declareVariable(keyJavaType, "keyElement");
        Variable transformedKeyElement = scope.declareVariable(transformedKeyJavaType, "transformedKeyElement");
        Variable valueElement = scope.declareVariable(valueJavaType, "valueElement");
        body.append((BytecodeNode)positionCount.set(block.invoke("getPositionCount", Integer.TYPE, new BytecodeExpression[0])));
        body.append((BytecodeNode)pageBuilder.set(state.cast(PageBuilder.class)));
        body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)pageBuilder.invoke("isFull", Boolean.TYPE, new BytecodeExpression[0])).ifTrue((BytecodeNode)pageBuilder.invoke("reset", Void.TYPE, new BytecodeExpression[0])));
        body.append((BytecodeNode)mapBlockBuilder.set(pageBuilder.invoke("getBlockBuilder", BlockBuilder.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)0)})));
        body.append((BytecodeNode)blockBuilder.set(mapBlockBuilder.invoke("beginBlockEntry", BlockBuilder.class, new BytecodeExpression[0])));
        body.append((BytecodeNode)typedSet.set(BytecodeExpressions.newInstance(TypedSet.class, (BytecodeExpression[])new BytecodeExpression[]{SqlTypeBytecodeExpression.constantType(binder, transformedKeyType), BytecodeExpressions.divide((BytecodeExpression)positionCount, (BytecodeExpression)BytecodeExpressions.constantInt((int)2)), BytecodeExpressions.constantString((String)MAP_TRANSFORM_KEY_FUNCTION.getSignature().getNameSuffix())})));
        BytecodeBlock throwNullKeyException = new BytecodeBlock().append((BytecodeNode)BytecodeExpressions.newInstance(PrestoException.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.getStatic((Class)StandardErrorCode.INVALID_FUNCTION_ARGUMENT.getDeclaringClass(), (String)"INVALID_FUNCTION_ARGUMENT").cast(ErrorCodeSupplier.class), BytecodeExpressions.constantString((String)"map key cannot be null")})).throwObject();
        SqlTypeBytecodeExpression keySqlType = SqlTypeBytecodeExpression.constantType(binder, keyType);
        BytecodeBlock loadKeyElement = !keyType.equals(UnknownType.UNKNOWN) ? new BytecodeBlock().append((BytecodeNode)keyElement.set(keySqlType.getValue((BytecodeExpression)block, (BytecodeExpression)position).cast(keyJavaType))) : new BytecodeBlock().append((BytecodeNode)mapBlockBuilder.invoke("closeEntry", BlockBuilder.class, new BytecodeExpression[0]).pop()).append((BytecodeNode)keyElement.set(BytecodeExpressions.constantNull((Class)keyJavaType))).append((BytecodeNode)throwNullKeyException);
        SqlTypeBytecodeExpression valueSqlType = SqlTypeBytecodeExpression.constantType(binder, valueType);
        Object loadValueElement = !valueType.equals(UnknownType.UNKNOWN) ? new IfStatement().condition((BytecodeNode)block.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{BytecodeExpressions.add((BytecodeExpression)position, (BytecodeExpression)BytecodeExpressions.constantInt((int)1))})).ifTrue((BytecodeNode)valueElement.set(BytecodeExpressions.constantNull((Class)valueJavaType))).ifFalse((BytecodeNode)valueElement.set(valueSqlType.getValue((BytecodeExpression)block, BytecodeExpressions.add((BytecodeExpression)position, (BytecodeExpression)BytecodeExpressions.constantInt((int)1))).cast(valueJavaType))) : new BytecodeBlock().append((BytecodeNode)valueElement.set(BytecodeExpressions.constantNull((Class)valueJavaType)));
        SqlTypeBytecodeExpression transformedKeySqlType = SqlTypeBytecodeExpression.constantType(binder, transformedKeyType);
        if (!transformedKeyType.equals(UnknownType.UNKNOWN)) {
            writeKeyElement = new BytecodeBlock().append((BytecodeNode)transformedKeyElement.set(function.invoke("apply", Object.class, new BytecodeExpression[]{keyElement.cast(Object.class), valueElement.cast(Object.class)}).cast(transformedKeyJavaType))).append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.equal((BytecodeExpression)transformedKeyElement, (BytecodeExpression)BytecodeExpressions.constantNull((Class)transformedKeyJavaType))).ifTrue((BytecodeNode)throwNullKeyException).ifFalse((BytecodeNode)new BytecodeBlock().append((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, transformedKeyType).writeValue((BytecodeExpression)blockBuilder, transformedKeyElement.cast(transformedKeyType.getJavaType()))).append((BytecodeNode)valueSqlType.invoke("appendTo", Void.TYPE, new BytecodeExpression[]{block, BytecodeExpressions.add((BytecodeExpression)position, (BytecodeExpression)BytecodeExpressions.constantInt((int)1)), blockBuilder}))));
            throwDuplicatedKeyException = new BytecodeBlock().append((BytecodeNode)mapBlockBuilder.invoke("closeEntry", BlockBuilder.class, new BytecodeExpression[0]).pop()).append((BytecodeNode)BytecodeExpressions.newInstance(PrestoException.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.getStatic((Class)StandardErrorCode.INVALID_FUNCTION_ARGUMENT.getDeclaringClass(), (String)"INVALID_FUNCTION_ARGUMENT").cast(ErrorCodeSupplier.class), BytecodeExpressions.invokeStatic(String.class, (String)"format", String.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantString((String)"Duplicate keys (%s) are not allowed"), BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(Object[].class), (Iterable)ImmutableList.of((Object)transformedKeySqlType.invoke("getObjectValue", Object.class, new BytecodeExpression[]{properties, blockBuilder.cast(Block.class), position})))})})).throwObject();
        } else {
            writeKeyElement = throwNullKeyException;
            throwDuplicatedKeyException = throwNullKeyException;
        }
        body.append((BytecodeNode)new ForLoop().initialize((BytecodeNode)position.set(BytecodeExpressions.constantInt((int)0))).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)position, (BytecodeExpression)positionCount)).update((BytecodeNode)VariableInstruction.incrementVariable((Variable)position, (byte)2)).body((BytecodeNode)new BytecodeBlock().append((BytecodeNode)loadKeyElement).append((BytecodeNode)loadValueElement).append((BytecodeNode)writeKeyElement).append((BytecodeNode)new IfStatement().condition((BytecodeNode)typedSet.invoke("contains", Boolean.TYPE, new BytecodeExpression[]{blockBuilder.cast(Block.class), position})).ifTrue((BytecodeNode)throwDuplicatedKeyException).ifFalse((BytecodeNode)typedSet.invoke("add", Boolean.TYPE, new BytecodeExpression[]{blockBuilder.cast(Block.class), position}).pop()))));
        body.append((BytecodeNode)mapBlockBuilder.invoke("closeEntry", BlockBuilder.class, new BytecodeExpression[0]).pop());
        body.append((BytecodeNode)pageBuilder.invoke("declarePosition", Void.TYPE, new BytecodeExpression[0]));
        body.append((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, resultMapType).invoke("getObject", Object.class, new BytecodeExpression[]{mapBlockBuilder.cast(Block.class), BytecodeExpressions.subtract((BytecodeExpression)mapBlockBuilder.invoke("getPositionCount", Integer.TYPE, new BytecodeExpression[0]), (BytecodeExpression)BytecodeExpressions.constantInt((int)1))}).ret());
        Class<Object> generatedClass = CompilerUtils.defineClass(definition, Object.class, binder.getBindings(), MapTransformKeyFunction.class.getClassLoader());
        return Reflection.methodHandle(generatedClass, "transform", Object.class, SqlFunctionProperties.class, Block.class, BinaryFunctionInterface.class);
    }
}

