/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.function.TypeParameters;

@ScalarFunction(value="map_keys")
@Description(value="Returns the keys of the given map(K,V) as an array")
public final class MapKeys {
    private MapKeys() {
    }

    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    @SqlType(value="array(K)")
    public static Block getKeys(@TypeParameter(value="K") Type keyType, @SqlType(value="map(K,V)") Block block) {
        BlockBuilder blockBuilder = keyType.createBlockBuilder(null, block.getPositionCount() / 2);
        for (int i = 0; i < block.getPositionCount(); i += 2) {
            keyType.appendTo(block, i, blockBuilder);
        }
        return blockBuilder.build();
    }
}

