/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.CallSiteBinder;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.ForLoop;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.VariableInstruction;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementationChoice;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.sql.gen.SqlTypeBytecodeExpression;
import com.facebook.presto.sql.gen.lambda.UnaryFunctionInterface;
import com.facebook.presto.util.CompilerUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import java.util.List;
import java.util.Optional;

public final class ArrayTransformFunction
extends SqlScalarFunction {
    public static final ArrayTransformFunction ARRAY_TRANSFORM_FUNCTION = new ArrayTransformFunction();

    private ArrayTransformFunction() {
        super(new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"transform"), FunctionKind.SCALAR, (List)ImmutableList.of((Object)Signature.typeVariable((String)"T"), (Object)Signature.typeVariable((String)"U")), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"array(U)"), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"array(T)"), (Object)TypeSignature.parseTypeSignature((String)"function(T,U)")), false));
    }

    public SqlFunctionVisibility getVisibility() {
        return SqlFunctionVisibility.PUBLIC;
    }

    public boolean isDeterministic() {
        return false;
    }

    public String getDescription() {
        return "apply lambda to each element of the array";
    }

    @Override
    public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Type inputType = boundVariables.getTypeVariable("T");
        Type outputType = boundVariables.getTypeVariable("U");
        Class<?> generatedClass = ArrayTransformFunction.generateTransform(inputType, outputType);
        return new BuiltInScalarFunctionImplementation(false, (List<ScalarFunctionImplementationChoice.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementationChoice.ArgumentProperty.functionTypeArgumentProperty(UnaryFunctionInterface.class)), Reflection.methodHandle(generatedClass, "transform", PageBuilder.class, Block.class, UnaryFunctionInterface.class), Optional.of(Reflection.methodHandle(generatedClass, "createPageBuilder", new Class[0])));
    }

    private static Class<?> generateTransform(Type inputType, Type outputType) {
        CallSiteBinder binder = new CallSiteBinder();
        Class inputJavaType = Primitives.wrap((Class)inputType.getJavaType());
        Class outputJavaType = Primitives.wrap((Class)outputType.getJavaType());
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("ArrayTransform"), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        definition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PRIVATE}));
        MethodDefinition createPageBuilderMethod = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "createPageBuilder", ParameterizedType.type(PageBuilder.class), new Parameter[0]);
        createPageBuilderMethod.getBody().append((BytecodeNode)BytecodeExpressions.newInstance(PageBuilder.class, (BytecodeExpression[])new BytecodeExpression[]{SqlTypeBytecodeExpression.constantType(binder, (Type)new ArrayType(outputType)).invoke("getTypeParameters", List.class, new BytecodeExpression[0])}).ret());
        Parameter pageBuilder = Parameter.arg((String)"pageBuilder", PageBuilder.class);
        Parameter block = Parameter.arg((String)"block", Block.class);
        Parameter function = Parameter.arg((String)"function", UnaryFunctionInterface.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "transform", ParameterizedType.type(Block.class), (Iterable)ImmutableList.of((Object)pageBuilder, (Object)block, (Object)function));
        BytecodeBlock body = method.getBody();
        Scope scope = method.getScope();
        Variable positionCount = scope.declareVariable(Integer.TYPE, "positionCount");
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        Variable blockBuilder = scope.declareVariable(BlockBuilder.class, "blockBuilder");
        Variable inputElement = scope.declareVariable(inputJavaType, "inputElement");
        Variable outputElement = scope.declareVariable(outputJavaType, "outputElement");
        body.append((BytecodeNode)positionCount.set(block.invoke("getPositionCount", Integer.TYPE, new BytecodeExpression[0])));
        body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)pageBuilder.invoke("isFull", Boolean.TYPE, new BytecodeExpression[0])).ifTrue((BytecodeNode)pageBuilder.invoke("reset", Void.TYPE, new BytecodeExpression[0])));
        body.append((BytecodeNode)blockBuilder.set(pageBuilder.invoke("getBlockBuilder", BlockBuilder.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)0)})));
        Object loadInputElement = !inputType.equals(UnknownType.UNKNOWN) ? new IfStatement().condition((BytecodeNode)block.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{position})).ifTrue((BytecodeNode)inputElement.set(BytecodeExpressions.constantNull((Class)inputJavaType))).ifFalse((BytecodeNode)inputElement.set(SqlTypeBytecodeExpression.constantType(binder, inputType).getValue((BytecodeExpression)block, (BytecodeExpression)position).cast(inputJavaType))) : new BytecodeBlock().append((BytecodeNode)inputElement.set(BytecodeExpressions.constantNull((Class)inputJavaType)));
        Object writeOutputElement = !outputType.equals(UnknownType.UNKNOWN) ? new IfStatement().condition((BytecodeNode)BytecodeExpressions.equal((BytecodeExpression)outputElement, (BytecodeExpression)BytecodeExpressions.constantNull((Class)outputJavaType))).ifTrue((BytecodeNode)blockBuilder.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop()).ifFalse((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, outputType).writeValue((BytecodeExpression)blockBuilder, outputElement.cast(outputType.getJavaType()))) : new BytecodeBlock().append((BytecodeNode)blockBuilder.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop());
        body.append((BytecodeNode)new ForLoop().initialize((BytecodeNode)position.set(BytecodeExpressions.constantInt((int)0))).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)position, (BytecodeExpression)positionCount)).update((BytecodeNode)VariableInstruction.incrementVariable((Variable)position, (byte)1)).body((BytecodeNode)new BytecodeBlock().append((BytecodeNode)loadInputElement).append((BytecodeNode)outputElement.set(function.invoke("apply", Object.class, new BytecodeExpression[]{inputElement.cast(Object.class)}).cast(outputJavaType))).append((BytecodeNode)writeOutputElement)));
        body.append((BytecodeNode)pageBuilder.invoke("declarePositions", Void.TYPE, new BytecodeExpression[]{positionCount}));
        body.append((BytecodeNode)blockBuilder.invoke("getRegion", Block.class, new BytecodeExpression[]{BytecodeExpressions.subtract((BytecodeExpression)blockBuilder.invoke("getPositionCount", Integer.TYPE, new BytecodeExpression[0]), (BytecodeExpression)positionCount), positionCount}).ret());
        return CompilerUtils.defineClass(definition, Object.class, binder.getBindings(), ArrayTransformFunction.class.getClassLoader());
    }
}

