/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.CallSiteBinder;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementationChoice;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.JavaScalarFunctionImplementation;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.sql.gen.ArrayGeneratorUtils;
import com.facebook.presto.sql.gen.ArrayMapBytecodeExpression;
import com.facebook.presto.sql.gen.CachedInstanceBinder;
import com.facebook.presto.util.CompilerUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class ArrayToArrayCast
extends SqlOperator {
    public static final ArrayToArrayCast ARRAY_TO_ARRAY_CAST = new ArrayToArrayCast();

    private ArrayToArrayCast() {
        super(OperatorType.CAST, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable((String)"F"), (Object)Signature.typeVariable((String)"T")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"array(T)"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"array(F)")));
    }

    @Override
    public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Preconditions.checkArgument((arity == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        Type fromType = boundVariables.getTypeVariable("F");
        Type toType = boundVariables.getTypeVariable("T");
        FunctionHandle functionHandle = functionAndTypeManager.lookupCast(CastType.CAST, fromType.getTypeSignature(), toType.getTypeSignature());
        JavaScalarFunctionImplementation function = functionAndTypeManager.getJavaScalarFunctionImplementation(functionHandle);
        Class<?> castOperatorClass = ArrayToArrayCast.generateArrayCast(functionAndTypeManager, functionAndTypeManager.getFunctionMetadata(functionHandle), function);
        MethodHandle methodHandle = Reflection.methodHandle(castOperatorClass, "castArray", SqlFunctionProperties.class, Block.class);
        return new BuiltInScalarFunctionImplementation(false, (List<ScalarFunctionImplementationChoice.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL)), methodHandle);
    }

    private static Class<?> generateArrayCast(TypeManager typeManager, FunctionMetadata elementCastFunctionMetadata, JavaScalarFunctionImplementation elementCast) {
        CallSiteBinder binder = new CallSiteBinder();
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(Joiner.on((String)"$").join((Object)"ArrayCast", elementCastFunctionMetadata.getArgumentTypes().get(0), new Object[]{elementCastFunctionMetadata.getReturnType()})), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        Parameter properties = Parameter.arg((String)"properties", SqlFunctionProperties.class);
        Parameter value = Parameter.arg((String)"value", Block.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "castArray", ParameterizedType.type(Block.class), new Parameter[]{properties, value});
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable wasNull = scope.declareVariable(Boolean.TYPE, "wasNull");
        body.append((BytecodeNode)wasNull.set(BytecodeExpressions.constantBoolean((boolean)false)));
        Type fromElementType = typeManager.getType((TypeSignature)elementCastFunctionMetadata.getArgumentTypes().get(0));
        Type toElementType = typeManager.getType(elementCastFunctionMetadata.getReturnType());
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(definition, binder);
        ArrayMapBytecodeExpression newArray = ArrayGeneratorUtils.map(scope, cachedInstanceBinder, fromElementType, toElementType, (Variable)value, elementCastFunctionMetadata.getName().getObjectName(), elementCast);
        body.append((BytecodeNode)newArray.ret());
        MethodDefinition constructorDefinition = definition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        BytecodeBlock constructorBody = constructorDefinition.getBody();
        Variable thisVariable = constructorDefinition.getThis();
        constructorBody.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        cachedInstanceBinder.generateInitializations(thisVariable, constructorBody);
        constructorBody.ret();
        return CompilerUtils.defineClass(definition, Object.class, binder.getBindings(), ArrayToArrayCast.class.getClassLoader());
    }
}

