/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.util.Failures;
import java.lang.invoke.MethodHandle;

@ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
public final class ArrayGreaterThanOrEqualOperator {
    private ArrayGreaterThanOrEqualOperator() {
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@OperatorDependency(operator=OperatorType.GREATER_THAN, argumentTypes={"T", "T"}) MethodHandle greaterThanFunction, @TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block leftArray, @SqlType(value="array(T)") Block rightArray) {
        int len = Math.min(leftArray.getPositionCount(), rightArray.getPositionCount());
        for (int index = 0; index < len; ++index) {
            com.facebook.presto.type.TypeUtils.checkElementNotNull(leftArray.isNull(index), "ARRAY comparison not supported for arrays with null elements");
            com.facebook.presto.type.TypeUtils.checkElementNotNull(rightArray.isNull(index), "ARRAY comparison not supported for arrays with null elements");
            Object leftElement = TypeUtils.readNativeValue((Type)type, (Block)leftArray, (int)index);
            Object rightElement = TypeUtils.readNativeValue((Type)type, (Block)rightArray, (int)index);
            try {
                if (greaterThanFunction.invoke(leftElement, rightElement)) {
                    return true;
                }
                if (!greaterThanFunction.invoke(rightElement, leftElement)) continue;
                return false;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return leftArray.getPositionCount() >= rightArray.getPositionCount();
    }
}

