/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.exchange;

import com.facebook.presto.common.Page;
import com.facebook.presto.operator.exchange.LocalExchangeMemoryManager;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class PageReference {
    private static final AtomicIntegerFieldUpdater<PageReference> REFERENCE_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PageReference.class, "referenceCount");
    private volatile int referenceCount;
    private final Page page;
    private final PageReleasedListener onPageReleased;

    public PageReference(Page page, int referenceCount, PageReleasedListener onPageReleased) {
        this.page = Objects.requireNonNull(page, "page is null");
        this.onPageReleased = Objects.requireNonNull(onPageReleased, "onPageReleased is null");
        Preconditions.checkArgument((referenceCount >= 1 ? 1 : 0) != 0, (Object)"referenceCount must be at least 1");
        this.referenceCount = referenceCount;
    }

    public long getRetainedSizeInBytes() {
        return this.page.getRetainedSizeInBytes();
    }

    public Page removePage() {
        int referenceCount = REFERENCE_COUNT_UPDATER.decrementAndGet(this);
        Preconditions.checkArgument((referenceCount >= 0 ? 1 : 0) != 0, (Object)"Page reference count is negative");
        if (referenceCount == 0) {
            this.onPageReleased.onPageReleased(this.page.getRetainedSizeInBytes());
        }
        return this.page;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("size", this.getRetainedSizeInBytes()).add("referenceCount", this.referenceCount).toString();
    }

    static interface PageReleasedListener {
        public void onPageReleased(long var1);

        public static PageReleasedListener forLocalExchangeMemoryManager(LocalExchangeMemoryManager memoryManager) {
            Objects.requireNonNull(memoryManager, "memoryManager is null");
            return releasedSizeInBytes -> memoryManager.updateMemoryUsage(-releasedSizeInBytes);
        }
    }
}

