/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PagesSpatialIndex;
import com.facebook.presto.operator.PagesSpatialIndexFactory;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.SizeOf;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class SpatialJoinOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final LocalMemoryContext localUserMemoryContext;
    private final SpatialJoinNode.Type joinType;
    private final List<Type> probeTypes;
    private final List<Integer> probeOutputChannels;
    private final int probeGeometryChannel;
    private final Optional<Integer> partitionChannel;
    private final PagesSpatialIndexFactory pagesSpatialIndexFactory;
    private ListenableFuture<PagesSpatialIndex> pagesSpatialIndexFuture;
    private final PageBuilder pageBuilder;
    @Nullable
    private Page probe;
    private int probePosition;
    @Nullable
    private int[] joinPositions;
    private int nextJoinPositionIndex;
    private boolean matchFound;
    private boolean finishing;
    private boolean finished;

    public SpatialJoinOperator(OperatorContext operatorContext, SpatialJoinNode.Type joinType, List<Type> probeTypes, List<Integer> probeOutputChannels, int probeGeometryChannel, Optional<Integer> partitionChannel, PagesSpatialIndexFactory pagesSpatialIndexFactory) {
        this.operatorContext = operatorContext;
        this.localUserMemoryContext = operatorContext.localUserMemoryContext();
        this.joinType = joinType;
        this.probeTypes = ImmutableList.copyOf(probeTypes);
        this.probeOutputChannels = ImmutableList.copyOf(probeOutputChannels);
        this.probeGeometryChannel = probeGeometryChannel;
        this.partitionChannel = Objects.requireNonNull(partitionChannel, "partitionChannel is null");
        this.pagesSpatialIndexFactory = pagesSpatialIndexFactory;
        this.pagesSpatialIndexFuture = pagesSpatialIndexFactory.createPagesSpatialIndex();
        this.pageBuilder = new PageBuilder((List)ImmutableList.builder().addAll(probeOutputChannels.stream().map(probeTypes::get).iterator()).addAll(pagesSpatialIndexFactory.getOutputTypes()).build());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public boolean needsInput() {
        return !this.finished && this.pagesSpatialIndexFuture.isDone() && !this.pageBuilder.isFull() && this.probe == null;
    }

    @Override
    public void addInput(Page page) {
        Verify.verify((this.probe == null ? 1 : 0) != 0);
        this.probe = page;
        this.probePosition = 0;
        this.joinPositions = null;
    }

    @Override
    public Page getOutput() {
        Verify.verify((!this.finished ? 1 : 0) != 0);
        if (!this.pageBuilder.isFull() && this.probe != null) {
            this.processProbe();
        }
        if (this.pageBuilder.isFull()) {
            Page page = this.pageBuilder.build();
            this.pageBuilder.reset();
            return page;
        }
        if (this.finishing && this.probe == null) {
            Page page = null;
            if (!this.pageBuilder.isEmpty()) {
                page = this.pageBuilder.build();
                this.pageBuilder.reset();
            }
            this.pagesSpatialIndexFactory.probeOperatorFinished();
            this.pagesSpatialIndexFuture = null;
            this.finished = true;
            return page;
        }
        return null;
    }

    private void processProbe() {
        Verify.verify((this.probe != null ? 1 : 0) != 0);
        PagesSpatialIndex pagesSpatialIndex = (PagesSpatialIndex)MoreFutures.getDone(this.pagesSpatialIndexFuture);
        DriverYieldSignal yieldSignal = this.operatorContext.getDriverContext().getYieldSignal();
        while (this.probePosition < this.probe.getPositionCount()) {
            if (this.joinPositions == null) {
                this.joinPositions = pagesSpatialIndex.findJoinPositions(this.probePosition, this.probe, this.probeGeometryChannel, this.partitionChannel);
                this.localUserMemoryContext.setBytes(SizeOf.sizeOf((int[])this.joinPositions));
                this.nextJoinPositionIndex = 0;
                this.matchFound = false;
                if (yieldSignal.isSet()) {
                    return;
                }
            }
            while (this.nextJoinPositionIndex < this.joinPositions.length) {
                if (this.pageBuilder.isFull()) {
                    return;
                }
                int joinPosition = this.joinPositions[this.nextJoinPositionIndex];
                if (pagesSpatialIndex.isJoinPositionEligible(joinPosition, this.probePosition, this.probe)) {
                    this.pageBuilder.declarePosition();
                    this.appendProbe();
                    pagesSpatialIndex.appendTo(joinPosition, this.pageBuilder, this.probeOutputChannels.size());
                    this.matchFound = true;
                }
                ++this.nextJoinPositionIndex;
                if (!yieldSignal.isSet()) continue;
                return;
            }
            if (!this.matchFound && this.joinType == SpatialJoinNode.Type.LEFT) {
                if (this.pageBuilder.isFull()) {
                    return;
                }
                this.pageBuilder.declarePosition();
                this.appendProbe();
                int buildColumnCount = this.pagesSpatialIndexFactory.getOutputTypes().size();
                for (int i = 0; i < buildColumnCount; ++i) {
                    this.pageBuilder.getBlockBuilder(this.probeOutputChannels.size() + i).appendNull();
                }
            }
            this.joinPositions = null;
            this.localUserMemoryContext.setBytes(0L);
            ++this.probePosition;
        }
        this.probe = null;
        this.probePosition = 0;
    }

    private void appendProbe() {
        int outputChannelOffset = 0;
        for (int outputIndex : this.probeOutputChannels) {
            Type type = this.probeTypes.get(outputIndex);
            Block block = this.probe.getBlock(outputIndex);
            type.appendTo(block, this.probePosition, this.pageBuilder.getBlockBuilder(outputChannelOffset));
            ++outputChannelOffset;
        }
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public void close() {
        this.pagesSpatialIndexFuture = null;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    public static final class SpatialJoinOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final SpatialJoinNode.Type joinType;
        private final List<Type> probeTypes;
        private final List<Integer> probeOutputChannels;
        private final int probeGeometryChannel;
        private final Optional<Integer> partitionChannel;
        private final PagesSpatialIndexFactory pagesSpatialIndexFactory;
        private boolean closed;

        public SpatialJoinOperatorFactory(int operatorId, PlanNodeId planNodeId, SpatialJoinNode.Type joinType, List<Type> probeTypes, List<Integer> probeOutputChannels, int probeGeometryChannel, Optional<Integer> partitionChannel, PagesSpatialIndexFactory pagesSpatialIndexFactory) {
            Preconditions.checkArgument((joinType == SpatialJoinNode.Type.INNER || joinType == SpatialJoinNode.Type.LEFT ? 1 : 0) != 0, (String)"unsupported join type: %s", (Object)((Object)joinType));
            this.operatorId = operatorId;
            this.planNodeId = planNodeId;
            this.joinType = joinType;
            this.probeTypes = ImmutableList.copyOf(probeTypes);
            this.probeOutputChannels = ImmutableList.copyOf(probeOutputChannels);
            this.probeGeometryChannel = probeGeometryChannel;
            this.partitionChannel = Objects.requireNonNull(partitionChannel, "partitionChannel is null");
            this.pagesSpatialIndexFactory = pagesSpatialIndexFactory;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, SpatialJoinOperator.class.getSimpleName());
            return new SpatialJoinOperator(operatorContext, this.joinType, this.probeTypes, this.probeOutputChannels, this.probeGeometryChannel, this.partitionChannel, this.pagesSpatialIndexFactory);
        }

        @Override
        public void noMoreOperators() {
            if (this.closed) {
                return;
            }
            this.pagesSpatialIndexFactory.noMoreProbeOperators();
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            this.pagesSpatialIndexFactory.addProbeOperatorFactory();
            return new SpatialJoinOperatorFactory(this.operatorId, this.planNodeId, this.joinType, this.probeTypes, this.probeOutputChannels, this.probeGeometryChannel, this.partitionChannel, this.pagesSpatialIndexFactory);
        }
    }
}

