/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.stats.Distribution;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.DriverStats;
import com.facebook.presto.operator.OperatorStats;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;

@Immutable
public class PipelineStats {
    private final int pipelineId;
    private final DateTime firstStartTime;
    private final DateTime lastStartTime;
    private final DateTime lastEndTime;
    private final boolean inputPipeline;
    private final boolean outputPipeline;
    private final int totalDrivers;
    private final int queuedDrivers;
    private final int queuedPartitionedDrivers;
    private final long queuedPartitionedSplitsWeight;
    private final int runningDrivers;
    private final int runningPartitionedDrivers;
    private final long runningPartitionedSplitsWeight;
    private final int blockedDrivers;
    private final int completedDrivers;
    private final long userMemoryReservationInBytes;
    private final long revocableMemoryReservationInBytes;
    private final long systemMemoryReservationInBytes;
    private final Distribution.DistributionSnapshot queuedTime;
    private final Distribution.DistributionSnapshot elapsedTime;
    private final long totalScheduledTimeInNanos;
    private final long totalCpuTimeInNanos;
    private final long totalBlockedTimeInNanos;
    private final boolean fullyBlocked;
    private final Set<BlockedReason> blockedReasons;
    private final long totalAllocationInBytes;
    private final long rawInputDataSizeInBytes;
    private final long rawInputPositions;
    private final long processedInputDataSizeInBytes;
    private final long processedInputPositions;
    private final long outputDataSizeInBytes;
    private final long outputPositions;
    private final long physicalWrittenDataSizeInBytes;
    private final List<OperatorStats> operatorSummaries;
    private final List<DriverStats> drivers;

    @JsonCreator
    public PipelineStats(@JsonProperty(value="pipelineId") int pipelineId, @JsonProperty(value="firstStartTime") DateTime firstStartTime, @JsonProperty(value="lastStartTime") DateTime lastStartTime, @JsonProperty(value="lastEndTime") DateTime lastEndTime, @JsonProperty(value="inputPipeline") boolean inputPipeline, @JsonProperty(value="outputPipeline") boolean outputPipeline, @JsonProperty(value="totalDrivers") int totalDrivers, @JsonProperty(value="queuedDrivers") int queuedDrivers, @JsonProperty(value="queuedPartitionedDrivers") int queuedPartitionedDrivers, @JsonProperty(value="queuedPartitionedSplitsWeight") long queuedPartitionedSplitsWeight, @JsonProperty(value="runningDrivers") int runningDrivers, @JsonProperty(value="runningPartitionedDrivers") int runningPartitionedDrivers, @JsonProperty(value="runningPartitionedSplitsWeight") long runningPartitionedSplitsWeight, @JsonProperty(value="blockedDrivers") int blockedDrivers, @JsonProperty(value="completedDrivers") int completedDrivers, @JsonProperty(value="userMemoryReservationInBytes") long userMemoryReservationInBytes, @JsonProperty(value="revocableMemoryReservationInBytes") long revocableMemoryReservationInBytes, @JsonProperty(value="systemMemoryReservationInBytes") long systemMemoryReservationInBytes, @JsonProperty(value="queuedTime") Distribution.DistributionSnapshot queuedTime, @JsonProperty(value="elapsedTime") Distribution.DistributionSnapshot elapsedTime, @JsonProperty(value="totalScheduledTimeInNanos") long totalScheduledTimeInNanos, @JsonProperty(value="totalCpuTimeInNanos") long totalCpuTimeInNanos, @JsonProperty(value="totalBlockedTimeInNanos") long totalBlockedTimeInNanos, @JsonProperty(value="fullyBlocked") boolean fullyBlocked, @JsonProperty(value="blockedReasons") Set<BlockedReason> blockedReasons, @JsonProperty(value="totalAllocationInBytes") long totalAllocationInBytes, @JsonProperty(value="rawInputDataSizeInBytes") long rawInputDataSizeInBytes, @JsonProperty(value="rawInputPositions") long rawInputPositions, @JsonProperty(value="processedInputDataSizeInBytes") long processedInputDataSizeInBytes, @JsonProperty(value="processedInputPositions") long processedInputPositions, @JsonProperty(value="outputDataSizeInBytes") long outputDataSizeInBytes, @JsonProperty(value="outputPositions") long outputPositions, @JsonProperty(value="physicalWrittenDataSizeInBytes") long physicalWrittenDataSizeInBytes, @JsonProperty(value="operatorSummaries") List<OperatorStats> operatorSummaries, @JsonProperty(value="drivers") List<DriverStats> drivers) {
        this.pipelineId = pipelineId;
        this.firstStartTime = firstStartTime;
        this.lastStartTime = lastStartTime;
        this.lastEndTime = lastEndTime;
        this.inputPipeline = inputPipeline;
        this.outputPipeline = outputPipeline;
        Preconditions.checkArgument((totalDrivers >= 0 ? 1 : 0) != 0, (Object)"totalDrivers is negative");
        this.totalDrivers = totalDrivers;
        Preconditions.checkArgument((queuedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedDrivers is negative");
        this.queuedDrivers = queuedDrivers;
        Preconditions.checkArgument((queuedPartitionedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedPartitionedDrivers is negative");
        this.queuedPartitionedDrivers = queuedPartitionedDrivers;
        Preconditions.checkArgument((queuedPartitionedSplitsWeight >= 0L ? 1 : 0) != 0, (Object)"queuedPartitionedSplitsWeight must be positive");
        this.queuedPartitionedSplitsWeight = queuedPartitionedSplitsWeight;
        Preconditions.checkArgument((runningDrivers >= 0 ? 1 : 0) != 0, (Object)"runningDrivers is negative");
        this.runningDrivers = runningDrivers;
        Preconditions.checkArgument((runningPartitionedDrivers >= 0 ? 1 : 0) != 0, (Object)"runningPartitionedDrivers is negative");
        this.runningPartitionedDrivers = runningPartitionedDrivers;
        Preconditions.checkArgument((runningPartitionedSplitsWeight >= 0L ? 1 : 0) != 0, (Object)"runningPartitionedSplitsWeight must be positive");
        this.runningPartitionedSplitsWeight = runningPartitionedSplitsWeight;
        Preconditions.checkArgument((blockedDrivers >= 0 ? 1 : 0) != 0, (Object)"blockedDrivers is negative");
        this.blockedDrivers = blockedDrivers;
        Preconditions.checkArgument((completedDrivers >= 0 ? 1 : 0) != 0, (Object)"completedDrivers is negative");
        this.completedDrivers = completedDrivers;
        this.userMemoryReservationInBytes = userMemoryReservationInBytes;
        this.revocableMemoryReservationInBytes = revocableMemoryReservationInBytes;
        this.systemMemoryReservationInBytes = systemMemoryReservationInBytes;
        this.queuedTime = Objects.requireNonNull(queuedTime, "queuedTime is null");
        this.elapsedTime = Objects.requireNonNull(elapsedTime, "elapsedTime is null");
        this.totalScheduledTimeInNanos = totalScheduledTimeInNanos;
        this.totalCpuTimeInNanos = totalCpuTimeInNanos;
        this.totalBlockedTimeInNanos = totalBlockedTimeInNanos;
        this.fullyBlocked = fullyBlocked;
        this.blockedReasons = ImmutableSet.copyOf((Collection)Objects.requireNonNull(blockedReasons, "blockedReasons is null"));
        this.totalAllocationInBytes = totalAllocationInBytes;
        this.rawInputDataSizeInBytes = rawInputDataSizeInBytes;
        Preconditions.checkArgument((rawInputPositions >= 0L ? 1 : 0) != 0, (Object)"rawInputPositions is negative");
        this.rawInputPositions = rawInputPositions;
        this.processedInputDataSizeInBytes = processedInputDataSizeInBytes;
        Preconditions.checkArgument((processedInputPositions >= 0L ? 1 : 0) != 0, (Object)"processedInputPositions is negative");
        this.processedInputPositions = processedInputPositions;
        this.outputDataSizeInBytes = outputDataSizeInBytes;
        Preconditions.checkArgument((outputPositions >= 0L ? 1 : 0) != 0, (Object)"outputPositions is negative");
        this.outputPositions = outputPositions;
        this.physicalWrittenDataSizeInBytes = physicalWrittenDataSizeInBytes;
        this.operatorSummaries = ImmutableList.copyOf((Collection)Objects.requireNonNull(operatorSummaries, "operatorSummaries is null"));
        this.drivers = ImmutableList.copyOf((Collection)Objects.requireNonNull(drivers, "drivers is null"));
    }

    @JsonProperty
    public int getPipelineId() {
        return this.pipelineId;
    }

    @Nullable
    @JsonProperty
    public DateTime getFirstStartTime() {
        return this.firstStartTime;
    }

    @Nullable
    @JsonProperty
    public DateTime getLastStartTime() {
        return this.lastStartTime;
    }

    @Nullable
    @JsonProperty
    public DateTime getLastEndTime() {
        return this.lastEndTime;
    }

    @JsonProperty
    public boolean isInputPipeline() {
        return this.inputPipeline;
    }

    @JsonProperty
    public boolean isOutputPipeline() {
        return this.outputPipeline;
    }

    @JsonProperty
    public int getTotalDrivers() {
        return this.totalDrivers;
    }

    @JsonProperty
    public int getQueuedDrivers() {
        return this.queuedDrivers;
    }

    @JsonProperty
    public int getQueuedPartitionedDrivers() {
        return this.queuedPartitionedDrivers;
    }

    @JsonProperty
    public long getQueuedPartitionedSplitsWeight() {
        return this.queuedPartitionedSplitsWeight;
    }

    @JsonProperty
    public int getRunningDrivers() {
        return this.runningDrivers;
    }

    @JsonProperty
    public int getRunningPartitionedDrivers() {
        return this.runningPartitionedDrivers;
    }

    @JsonProperty
    public long getRunningPartitionedSplitsWeight() {
        return this.runningPartitionedSplitsWeight;
    }

    @JsonProperty
    public int getBlockedDrivers() {
        return this.blockedDrivers;
    }

    @JsonProperty
    public int getCompletedDrivers() {
        return this.completedDrivers;
    }

    @JsonProperty
    public long getUserMemoryReservationInBytes() {
        return this.userMemoryReservationInBytes;
    }

    @JsonProperty
    public long getRevocableMemoryReservationInBytes() {
        return this.revocableMemoryReservationInBytes;
    }

    @JsonProperty
    public long getSystemMemoryReservationInBytes() {
        return this.systemMemoryReservationInBytes;
    }

    @JsonProperty
    public Distribution.DistributionSnapshot getQueuedTime() {
        return this.queuedTime;
    }

    @JsonProperty
    public Distribution.DistributionSnapshot getElapsedTime() {
        return this.elapsedTime;
    }

    @JsonProperty
    public long getTotalScheduledTimeInNanos() {
        return this.totalScheduledTimeInNanos;
    }

    @JsonProperty
    public long getTotalCpuTimeInNanos() {
        return this.totalCpuTimeInNanos;
    }

    @JsonProperty
    public long getTotalBlockedTimeInNanos() {
        return this.totalBlockedTimeInNanos;
    }

    @JsonProperty
    public boolean isFullyBlocked() {
        return this.fullyBlocked;
    }

    @JsonProperty
    public Set<BlockedReason> getBlockedReasons() {
        return this.blockedReasons;
    }

    @JsonProperty
    public long getTotalAllocationInBytes() {
        return this.totalAllocationInBytes;
    }

    @JsonProperty
    public long getRawInputDataSizeInBytes() {
        return this.rawInputDataSizeInBytes;
    }

    @JsonProperty
    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    @JsonProperty
    public long getProcessedInputDataSizeInBytes() {
        return this.processedInputDataSizeInBytes;
    }

    @JsonProperty
    public long getProcessedInputPositions() {
        return this.processedInputPositions;
    }

    @JsonProperty
    public long getOutputDataSizeInBytes() {
        return this.outputDataSizeInBytes;
    }

    @JsonProperty
    public long getOutputPositions() {
        return this.outputPositions;
    }

    @JsonProperty
    public long getPhysicalWrittenDataSizeInBytes() {
        return this.physicalWrittenDataSizeInBytes;
    }

    @JsonProperty
    public List<OperatorStats> getOperatorSummaries() {
        return this.operatorSummaries;
    }

    @JsonProperty
    public List<DriverStats> getDrivers() {
        return this.drivers;
    }

    public PipelineStats summarize() {
        return new PipelineStats(this.pipelineId, this.firstStartTime, this.lastStartTime, this.lastEndTime, this.inputPipeline, this.outputPipeline, this.totalDrivers, this.queuedDrivers, this.queuedPartitionedDrivers, this.queuedPartitionedSplitsWeight, this.runningDrivers, this.runningPartitionedDrivers, this.runningPartitionedSplitsWeight, this.blockedDrivers, this.completedDrivers, this.userMemoryReservationInBytes, this.revocableMemoryReservationInBytes, this.systemMemoryReservationInBytes, this.queuedTime, this.elapsedTime, this.totalScheduledTimeInNanos, this.totalCpuTimeInNanos, this.totalBlockedTimeInNanos, this.fullyBlocked, this.blockedReasons, this.totalAllocationInBytes, this.rawInputDataSizeInBytes, this.rawInputPositions, this.processedInputDataSizeInBytes, this.processedInputPositions, this.outputDataSizeInBytes, this.outputPositions, this.physicalWrittenDataSizeInBytes, PipelineStats.summarizeOperatorStats(this.operatorSummaries), (List<DriverStats>)ImmutableList.of());
    }

    private static List<OperatorStats> summarizeOperatorStats(List<OperatorStats> operatorSummaries) {
        ImmutableList.Builder results = ImmutableList.builderWithExpectedSize((int)operatorSummaries.size());
        for (OperatorStats operatorStats : operatorSummaries) {
            results.add((Object)operatorStats.summarize());
        }
        return results.build();
    }
}

