/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.facebook.presto.Session;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.array.AdaptiveLongBigArray;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.geospatial.GeometryUtils;
import com.facebook.presto.geospatial.Rectangle;
import com.facebook.presto.geospatial.rtree.Flatbush;
import com.facebook.presto.geospatial.rtree.HasExtent;
import com.facebook.presto.geospatial.serde.EsriGeometrySerde;
import com.facebook.presto.operator.JoinFilterFunction;
import com.facebook.presto.operator.JoinUtils;
import com.facebook.presto.operator.PagesSpatialIndex;
import com.facebook.presto.operator.SpatialIndexBuilderOperator;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.sql.gen.JoinFilterFunctionCompiler;
import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import org.openjdk.jol.info.ClassLayout;

public class PagesRTreeIndex
implements PagesSpatialIndex {
    private static final int[] EMPTY_ADDRESSES = new int[0];
    private final AdaptiveLongBigArray addresses;
    private final List<Type> types;
    private final List<Integer> outputChannels;
    private final List<List<Block>> channels;
    private final Flatbush<GeometryWithPosition> rtree;
    private final int radiusChannel;
    private final SpatialIndexBuilderOperator.SpatialPredicate spatialRelationshipTest;
    private final JoinFilterFunction filterFunction;
    private final Map<Integer, Rectangle> partitions;

    public PagesRTreeIndex(Session session, AdaptiveLongBigArray addresses, List<Type> types, List<Integer> outputChannels, List<List<Block>> channels, Flatbush<GeometryWithPosition> rtree, Optional<Integer> radiusChannel, SpatialIndexBuilderOperator.SpatialPredicate spatialRelationshipTest, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory, Map<Integer, Rectangle> partitions) {
        this.addresses = Objects.requireNonNull(addresses, "addresses is null");
        this.types = types;
        this.outputChannels = outputChannels;
        this.channels = Objects.requireNonNull(channels, "channels is null");
        this.rtree = Objects.requireNonNull(rtree, "rtree is null");
        this.radiusChannel = radiusChannel.orElse(-1);
        this.spatialRelationshipTest = Objects.requireNonNull(spatialRelationshipTest, "spatial relationship is null");
        this.filterFunction = filterFunctionFactory.map(factory -> factory.create(session.getSqlFunctionProperties(), addresses, JoinUtils.channelsToPages(channels))).orElse(null);
        this.partitions = Objects.requireNonNull(partitions, "partitions is null");
    }

    @Override
    public int[] findJoinPositions(int probePosition, Page probe, int probeGeometryChannel, Optional<Integer> probePartitionChannel) {
        Block probeGeometryBlock = probe.getBlock(probeGeometryChannel);
        if (probeGeometryBlock.isNull(probePosition)) {
            return EMPTY_ADDRESSES;
        }
        int probePartition = probePartitionChannel.map(channel -> Math.toIntExact(IntegerType.INTEGER.getLong(probe.getBlock(channel.intValue()), probePosition))).orElse(-1);
        Slice slice = probeGeometryBlock.getSlice(probePosition, 0, probeGeometryBlock.getSliceLength(probePosition));
        OGCGeometry probeGeometry = EsriGeometrySerde.deserialize((Slice)slice);
        Verify.verify((probeGeometry != null ? 1 : 0) != 0);
        if (probeGeometry.isEmpty()) {
            return EMPTY_ADDRESSES;
        }
        IntArrayList matchingPositions = new IntArrayList();
        Rectangle queryRectangle = GeometryUtils.getExtent((OGCGeometry)probeGeometry);
        boolean probeIsPoint = queryRectangle.isPointlike();
        this.rtree.findIntersections(queryRectangle, geometryWithPosition -> {
            OGCGeometry buildGeometry = geometryWithPosition.getGeometry();
            Rectangle buildEnvelope = geometryWithPosition.getExtent();
            if (this.partitions.isEmpty() || probePartition == geometryWithPosition.getPartition() && (probeIsPoint || buildEnvelope.isPointlike() || this.testReferencePoint(queryRectangle, buildEnvelope, probePartition))) {
                OptionalDouble radius;
                OptionalDouble optionalDouble = radius = this.radiusChannel == -1 ? OptionalDouble.empty() : OptionalDouble.of(this.getRadius(geometryWithPosition.getPosition()));
                if (this.spatialRelationshipTest.apply(buildGeometry, probeGeometry, radius)) {
                    matchingPositions.add(geometryWithPosition.getPosition());
                }
            }
        });
        return matchingPositions.toIntArray();
    }

    private boolean testReferencePoint(Rectangle probeEnvelope, Rectangle buildEnvelope, int partition) {
        Rectangle intersection = buildEnvelope.intersection(probeEnvelope);
        if (intersection == null) {
            return false;
        }
        Rectangle extent = this.partitions.get(partition);
        double x = intersection.getXMin();
        double y = intersection.getYMin();
        return x >= extent.getXMin() && x < extent.getXMax() && y >= extent.getYMin() && y < extent.getYMax();
    }

    private double getRadius(int joinPosition) {
        long joinAddress = this.addresses.get(joinPosition);
        int blockIndex = SyntheticAddress.decodeSliceIndex(joinAddress);
        int blockPosition = SyntheticAddress.decodePosition(joinAddress);
        return DoubleType.DOUBLE.getDouble(this.channels.get(this.radiusChannel).get(blockIndex), blockPosition);
    }

    @Override
    public boolean isJoinPositionEligible(int joinPosition, int probePosition, Page probe) {
        return this.filterFunction == null || this.filterFunction.filter(joinPosition, probePosition, probe);
    }

    @Override
    public void appendTo(int joinPosition, PageBuilder pageBuilder, int outputChannelOffset) {
        long joinAddress = this.addresses.get(joinPosition);
        int blockIndex = SyntheticAddress.decodeSliceIndex(joinAddress);
        int blockPosition = SyntheticAddress.decodePosition(joinAddress);
        for (int outputIndex : this.outputChannels) {
            Type type = this.types.get(outputIndex);
            List<Block> channel = this.channels.get(outputIndex);
            Block block = channel.get(blockIndex);
            type.appendTo(block, blockPosition, pageBuilder.getBlockBuilder(outputChannelOffset));
            ++outputChannelOffset;
        }
    }

    public static final class GeometryWithPosition
    implements HasExtent {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(GeometryWithPosition.class).instanceSize();
        private final OGCGeometry ogcGeometry;
        private final int partition;
        private final int position;
        private final Rectangle extent;

        public GeometryWithPosition(OGCGeometry ogcGeometry, int partition, int position) {
            this(ogcGeometry, partition, position, 0.0);
        }

        public GeometryWithPosition(OGCGeometry ogcGeometry, int partition, int position, double radius) {
            this.ogcGeometry = Objects.requireNonNull(ogcGeometry, "ogcGeometry is null");
            this.partition = partition;
            this.position = position;
            this.extent = GeometryUtils.getExtent((OGCGeometry)ogcGeometry, (double)radius);
        }

        public OGCGeometry getGeometry() {
            return this.ogcGeometry;
        }

        public int getPartition() {
            return this.partition;
        }

        public int getPosition() {
            return this.position;
        }

        public Rectangle getExtent() {
            return this.extent;
        }

        public long getEstimatedSizeInBytes() {
            return (long)INSTANCE_SIZE + this.ogcGeometry.estimateMemorySize() + this.extent.getEstimatedSizeInBytes();
        }
    }
}

