/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.array.ObjectBigArray;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.PageWithPositionComparator;
import com.facebook.presto.operator.TransformWork;
import com.facebook.presto.operator.Work;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.openjdk.jol.info.ClassLayout;

public class GroupedTopNBuilder {
    private static final long INSTANCE_SIZE = ClassLayout.parseClass(GroupedTopNBuilder.class).instanceSize();
    private static final int COMPACT_THRESHOLD = 2;
    private final Type[] sourceTypes;
    private final int topN;
    private final boolean produceRowNumber;
    private final GroupByHash groupByHash;
    private final ObjectBigArray<RowHeap> groupedRows = new ObjectBigArray();
    private final ObjectBigArray<PageReference> pageReferences = new ObjectBigArray();
    private final PageWithPositionComparator pageWithPositionComparator;
    private final Comparator<Row> rowHeapComparator;
    private final IntFIFOQueue emptyPageReferenceSlots;
    private long memorySizeInBytes;
    private int currentPageCount;

    public GroupedTopNBuilder(List<Type> sourceTypes, PageWithPositionComparator comparator, int topN, boolean produceRowNumber, GroupByHash groupByHash) {
        this.sourceTypes = Objects.requireNonNull(sourceTypes, "sourceTypes is null").toArray(new Type[0]);
        Preconditions.checkArgument((topN > 0 ? 1 : 0) != 0, (Object)"topN must be > 0");
        this.topN = topN;
        this.produceRowNumber = produceRowNumber;
        this.groupByHash = Objects.requireNonNull(groupByHash, "groupByHash is not null");
        this.pageWithPositionComparator = Objects.requireNonNull(comparator, "comparator is null");
        this.rowHeapComparator = (right, left) -> this.pageWithPositionComparator.compareTo(((PageReference)this.pageReferences.get((long)left.getPageId())).getPage(), left.getPosition(), ((PageReference)this.pageReferences.get((long)right.getPageId())).getPage(), right.getPosition());
        this.emptyPageReferenceSlots = new IntFIFOQueue();
    }

    public Work<?> processPage(Page page) {
        return new TransformWork<GroupByIdBlock, Object>(this.groupByHash.getGroupIds(page), groupIds -> {
            this.processPage(page, (GroupByIdBlock)groupIds);
            return null;
        });
    }

    public Iterator<Page> buildResult() {
        return new ResultIterator();
    }

    public long getEstimatedSizeInBytes() {
        return INSTANCE_SIZE + this.memorySizeInBytes + this.groupByHash.getEstimatedSize() + this.groupedRows.sizeOf() + this.pageReferences.sizeOf() + this.emptyPageReferenceSlots.getEstimatedSizeInBytes();
    }

    @VisibleForTesting
    List<Page> getBufferedPages() {
        return (List)IntStream.range(0, this.currentPageCount).filter(i -> this.pageReferences.get((long)i) != null).mapToObj(i -> ((PageReference)this.pageReferences.get((long)i)).getPage()).collect(ImmutableList.toImmutableList());
    }

    private void processPage(Page newPage, GroupByIdBlock groupIds) {
        int newPageId;
        Preconditions.checkArgument((newPage != null ? 1 : 0) != 0);
        Preconditions.checkArgument((groupIds != null ? 1 : 0) != 0);
        int firstPositionToInsert = this.findFirstPositionToInsert(newPage, groupIds);
        if (firstPositionToInsert < 0) {
            return;
        }
        PageReference newPageReference = new PageReference(newPage);
        this.memorySizeInBytes += newPageReference.getEstimatedSizeInBytes();
        if (this.emptyPageReferenceSlots.isEmpty()) {
            this.pageReferences.ensureCapacity((long)(this.currentPageCount + 1));
            newPageId = this.currentPageCount++;
        } else {
            newPageId = this.emptyPageReferenceSlots.dequeueInt();
        }
        Verify.verify((boolean)this.pageReferences.setIfNull((long)newPageId, (Object)newPageReference), (String)"should not overwrite a non-empty slot", (Object[])new Object[0]);
        this.groupedRows.ensureCapacity(groupIds.getGroupCount());
        IntOpenHashSet pagesToCompact = new IntOpenHashSet();
        for (int position = firstPositionToInsert; position < newPage.getPositionCount(); ++position) {
            long groupId = groupIds.getGroupId(position);
            RowHeap rows = (RowHeap)((Object)this.groupedRows.get(groupId));
            if (rows == null) {
                rows = new RowHeap(this.rowHeapComparator);
                this.groupedRows.set(groupId, (Object)rows);
            } else {
                this.memorySizeInBytes -= rows.getEstimatedSizeInBytes();
            }
            if (rows.size() < this.topN) {
                Row row = new Row(newPageId, position);
                newPageReference.reference(row);
                rows.enqueue(row);
            } else {
                Row previousRow = (Row)rows.first();
                PageReference previousPageReference = (PageReference)this.pageReferences.get((long)previousRow.getPageId());
                if (this.pageWithPositionComparator.compareTo(newPage, position, previousPageReference.getPage(), previousRow.getPosition()) < 0) {
                    rows.dequeue();
                    previousPageReference.dereference(previousRow.getPosition());
                    Row newRow = new Row(newPageId, position);
                    newPageReference.reference(newRow);
                    rows.enqueue(newRow);
                    if (previousPageReference.getPage() != newPage && previousPageReference.getUsedPositionCount() * 2 < previousPageReference.getPage().getPositionCount()) {
                        pagesToCompact.add(previousRow.getPageId());
                    }
                }
            }
            this.memorySizeInBytes += rows.getEstimatedSizeInBytes();
        }
        if (newPageReference.getUsedPositionCount() * 2 < newPage.getPositionCount()) {
            Verify.verify((boolean)pagesToCompact.add(newPageId));
        }
        IntIterator iterator = pagesToCompact.iterator();
        while (iterator.hasNext()) {
            int pageId = iterator.nextInt();
            PageReference pageReference = (PageReference)this.pageReferences.get((long)pageId);
            if (pageReference.getUsedPositionCount() == 0) {
                this.pageReferences.set((long)pageId, null);
                this.emptyPageReferenceSlots.enqueue(pageId);
                this.memorySizeInBytes -= pageReference.getEstimatedSizeInBytes();
                continue;
            }
            this.memorySizeInBytes -= pageReference.getEstimatedSizeInBytes();
            pageReference.compact();
            this.memorySizeInBytes += pageReference.getEstimatedSizeInBytes();
        }
    }

    private int findFirstPositionToInsert(Page newPage, GroupByIdBlock groupIds) {
        for (int position = 0; position < newPage.getPositionCount(); ++position) {
            long groupId = groupIds.getGroupId(position);
            if (this.groupedRows.getCapacity() <= groupId) {
                return position;
            }
            RowHeap rows = (RowHeap)((Object)this.groupedRows.get(groupId));
            if (rows == null || rows.size() < this.topN) {
                return position;
            }
            Row previousRow = (Row)rows.first();
            PageReference pageReference = (PageReference)this.pageReferences.get((long)previousRow.getPageId());
            if (this.pageWithPositionComparator.compareTo(newPage, position, pageReference.getPage(), previousRow.getPosition()) >= 0) continue;
            return position;
        }
        return -1;
    }

    private class ResultIterator
    extends AbstractIterator<Page> {
        private static final int UNUSED_CAPACITY_DISPOSAL_THRESHOLD = 4096;
        private final PageBuilder pageBuilder;
        private final int groupCount;
        private int currentGroupNumber;
        private long currentGroupSizeInBytes;
        private int currentGroupPosition;
        private int currentGroupSize;
        private ObjectBigArray<Row> currentRows;

        ResultIterator() {
            this.groupCount = GroupedTopNBuilder.this.groupByHash.getGroupCount();
            this.pageBuilder = GroupedTopNBuilder.this.produceRowNumber ? new PageBuilder((List)new ImmutableList.Builder().add((Object[])GroupedTopNBuilder.this.sourceTypes).add((Object)BigintType.BIGINT).build()) : new PageBuilder((List)ImmutableList.copyOf((Object[])GroupedTopNBuilder.this.sourceTypes));
            this.currentRows = new ObjectBigArray();
            this.nextGroupedRows();
        }

        protected Page computeNext() {
            this.pageBuilder.reset();
            while (!this.pageBuilder.isFull() && this.currentRows != null) {
                if (this.currentGroupPosition == this.currentGroupSize) {
                    GroupedTopNBuilder.this.memorySizeInBytes = GroupedTopNBuilder.this.memorySizeInBytes - this.currentGroupSizeInBytes;
                    this.currentGroupPosition = 0;
                    this.nextGroupedRows();
                    continue;
                }
                Row row = (Row)this.currentRows.getAndSet((long)this.currentGroupPosition, null);
                PageReference pageReference = (PageReference)GroupedTopNBuilder.this.pageReferences.get((long)row.getPageId());
                Page page = pageReference.getPage();
                int position = row.getPosition();
                for (int i = 0; i < GroupedTopNBuilder.this.sourceTypes.length; ++i) {
                    GroupedTopNBuilder.this.sourceTypes[i].appendTo(page.getBlock(i), position, this.pageBuilder.getBlockBuilder(i));
                }
                if (GroupedTopNBuilder.this.produceRowNumber) {
                    BigintType.BIGINT.writeLong(this.pageBuilder.getBlockBuilder(GroupedTopNBuilder.this.sourceTypes.length), (long)(this.currentGroupPosition + 1));
                }
                this.pageBuilder.declarePosition();
                ++this.currentGroupPosition;
                if (!pageReference.dereference(position)) continue;
                GroupedTopNBuilder.this.pageReferences.set((long)row.getPageId(), null);
                GroupedTopNBuilder.this.memorySizeInBytes = GroupedTopNBuilder.this.memorySizeInBytes - pageReference.getEstimatedSizeInBytes();
            }
            if (this.pageBuilder.isEmpty()) {
                return (Page)this.endOfData();
            }
            return this.pageBuilder.build();
        }

        private void nextGroupedRows() {
            if (this.currentGroupNumber < this.groupCount) {
                RowHeap rows = (RowHeap)((Object)GroupedTopNBuilder.this.groupedRows.getAndSet((long)this.currentGroupNumber, null));
                Verify.verify((rows != null && !rows.isEmpty() ? 1 : 0) != 0, (String)"impossible to have inserted a group without a witness row", (Object[])new Object[0]);
                this.currentGroupSizeInBytes = rows.getEstimatedSizeInBytes();
                ++this.currentGroupNumber;
                this.currentGroupSize = rows.size();
                Preconditions.checkState((this.currentRows != null ? 1 : 0) != 0, (Object)"currentRows already observed the final group");
                if (this.currentRows.getCapacity() > 4096L && this.currentRows.getCapacity() > (long)this.currentGroupSize * 2L) {
                    this.currentRows = new ObjectBigArray();
                }
                this.currentRows.ensureCapacity((long)this.currentGroupSize);
                for (int index = this.currentGroupSize - 1; index >= 0; --index) {
                    this.currentRows.set((long)index, rows.dequeue());
                }
            } else {
                this.currentRows = null;
                this.currentGroupSize = 0;
            }
        }
    }

    private static class RowHeap
    extends ObjectHeapPriorityQueue<Row> {
        private static final long INSTANCE_SIZE = ClassLayout.parseClass(RowHeap.class).instanceSize();
        private static final long ROW_ENTRY_SIZE = ClassLayout.parseClass(Row.class).instanceSize();

        private RowHeap(Comparator<Row> comparator) {
            super(1, comparator);
        }

        private long getEstimatedSizeInBytes() {
            return INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.heap) + (long)this.size() * ROW_ENTRY_SIZE;
        }
    }

    private static class IntFIFOQueue
    extends IntArrayFIFOQueue {
        private static final long INSTANCE_SIZE = ClassLayout.parseClass(IntFIFOQueue.class).instanceSize();

        private IntFIFOQueue() {
        }

        private long getEstimatedSizeInBytes() {
            return INSTANCE_SIZE + SizeOf.sizeOf((int[])this.array);
        }
    }

    private static class PageReference {
        private static final long INSTANCE_SIZE = ClassLayout.parseClass(PageReference.class).instanceSize();
        private Page page;
        private Row[] reference;
        private int usedPositionCount;

        public PageReference(Page page) {
            this.page = Objects.requireNonNull(page, "page is null");
            this.reference = new Row[page.getPositionCount()];
        }

        public void reference(Row row) {
            this.reference[row.getPosition()] = row;
            ++this.usedPositionCount;
        }

        public boolean dereference(int position) {
            Preconditions.checkArgument((this.reference[position] != null && this.usedPositionCount > 0 ? 1 : 0) != 0);
            this.reference[position] = null;
            return --this.usedPositionCount == 0;
        }

        public int getUsedPositionCount() {
            return this.usedPositionCount;
        }

        public void compact() {
            Preconditions.checkState((this.usedPositionCount > 0 ? 1 : 0) != 0);
            if (this.usedPositionCount == this.page.getPositionCount()) {
                return;
            }
            Row[] newReference = new Row[this.usedPositionCount];
            int[] positions = new int[this.usedPositionCount];
            int index = 0;
            for (int i = 0; i < this.reference.length && index < this.usedPositionCount; ++i) {
                Row value = this.reference[i];
                if (value == null) continue;
                value.reset(index);
                newReference[index] = value;
                positions[index] = i;
                ++index;
            }
            Verify.verify((index == this.usedPositionCount ? 1 : 0) != 0);
            this.page = this.page.copyPositions(positions, 0, this.usedPositionCount);
            this.reference = newReference;
        }

        public Page getPage() {
            return this.page;
        }

        public long getEstimatedSizeInBytes() {
            return this.page.getRetainedSizeInBytes() + SizeOf.sizeOf((Object[])this.reference) + INSTANCE_SIZE;
        }
    }

    private static class Row {
        private final int pageId;
        private int position;

        private Row(int pageId, int position) {
            this.pageId = pageId;
            this.reset(position);
        }

        public void reset(int position) {
            this.position = position;
        }

        public int getPageId() {
            return this.pageId;
        }

        public int getPosition() {
            return this.position;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("pageId", this.pageId).add("position", this.position).toString();
        }
    }
}

