/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.ScanFilterAndProjectOperator;
import com.facebook.presto.operator.project.MergingPageOutput;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class FilterAndProjectOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final LocalMemoryContext pageProcessorMemoryContext;
    private final LocalMemoryContext outputMemoryContext;
    private final PageProcessor processor;
    private final MergingPageOutput mergingOutput;
    private final SqlFunctionProperties sqlFunctionProperties;
    private boolean finishing;

    public FilterAndProjectOperator(OperatorContext operatorContext, PageProcessor processor, MergingPageOutput mergingOutput) {
        this.processor = Objects.requireNonNull(processor, "processor is null");
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.pageProcessorMemoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(ScanFilterAndProjectOperator.class.getSimpleName());
        this.outputMemoryContext = operatorContext.newLocalSystemMemoryContext(FilterAndProjectOperator.class.getSimpleName());
        this.mergingOutput = Objects.requireNonNull(mergingOutput, "mergingOutput is null");
        this.sqlFunctionProperties = operatorContext.getSession().getSqlFunctionProperties();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public final void finish() {
        this.mergingOutput.finish();
        this.finishing = true;
    }

    @Override
    public final boolean isFinished() {
        boolean finished;
        boolean bl = finished = this.finishing && this.mergingOutput.isFinished();
        if (finished) {
            this.outputMemoryContext.setBytes(this.mergingOutput.getRetainedSizeInBytes());
        }
        return finished;
    }

    @Override
    public final boolean needsInput() {
        return !this.finishing && this.mergingOutput.needsInput();
    }

    @Override
    public final void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((boolean)this.mergingOutput.needsInput(), (Object)"Page buffer is full");
        this.mergingOutput.addInput(this.processor.process(this.sqlFunctionProperties, this.operatorContext.getDriverContext().getYieldSignal(), this.pageProcessorMemoryContext, page));
        this.outputMemoryContext.setBytes(this.mergingOutput.getRetainedSizeInBytes() + this.pageProcessorMemoryContext.getBytes());
    }

    @Override
    public final Page getOutput() {
        return this.mergingOutput.getOutput();
    }

    public static class FilterAndProjectOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final Supplier<PageProcessor> processor;
        private final List<Type> types;
        private final DataSize minOutputPageSize;
        private final int minOutputPageRowCount;
        private boolean closed;

        public FilterAndProjectOperatorFactory(int operatorId, PlanNodeId planNodeId, Supplier<PageProcessor> processor, List<Type> types, DataSize minOutputPageSize, int minOutputPageRowCount) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.processor = Objects.requireNonNull(processor, "processor is null");
            this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
            this.minOutputPageSize = Objects.requireNonNull(minOutputPageSize, "minOutputPageSize is null");
            this.minOutputPageRowCount = minOutputPageRowCount;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, FilterAndProjectOperator.class.getSimpleName());
            return new FilterAndProjectOperator(operatorContext, this.processor.get(), new MergingPageOutput(this.types, this.minOutputPageSize.toBytes(), this.minOutputPageRowCount));
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new FilterAndProjectOperatorFactory(this.operatorId, this.planNodeId, this.processor, this.types, this.minOutputPageSize, this.minOutputPageRowCount);
        }
    }
}

