/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeProvider;
import com.facebook.presto.spi.SplitContext;
import com.facebook.presto.spi.SplitWeight;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;

public final class Split {
    private final ConnectorId connectorId;
    private final ConnectorTransactionHandle transactionHandle;
    private final ConnectorSplit connectorSplit;
    private final Lifespan lifespan;
    private final SplitContext splitContext;

    public Split(ConnectorId connectorId, ConnectorTransactionHandle transactionHandle, ConnectorSplit connectorSplit) {
        this(connectorId, transactionHandle, connectorSplit, Lifespan.taskWide(), SplitContext.NON_CACHEABLE);
    }

    @JsonCreator
    public Split(@JsonProperty(value="connectorId") ConnectorId connectorId, @JsonProperty(value="transactionHandle") ConnectorTransactionHandle transactionHandle, @JsonProperty(value="connectorSplit") ConnectorSplit connectorSplit, @JsonProperty(value="lifespan") Lifespan lifespan, @JsonProperty(value="splitContext") SplitContext splitContext) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.transactionHandle = Objects.requireNonNull(transactionHandle, "transactionHandle is null");
        this.connectorSplit = Objects.requireNonNull(connectorSplit, "connectorSplit is null");
        this.lifespan = Objects.requireNonNull(lifespan, "lifespan is null");
        this.splitContext = Objects.requireNonNull(splitContext, "splitContext is null");
    }

    @JsonProperty
    public ConnectorId getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public ConnectorTransactionHandle getTransactionHandle() {
        return this.transactionHandle;
    }

    @JsonProperty
    public ConnectorSplit getConnectorSplit() {
        return this.connectorSplit;
    }

    @JsonProperty
    public Lifespan getLifespan() {
        return this.lifespan;
    }

    @JsonProperty
    public SplitContext getSplitContext() {
        return this.splitContext;
    }

    public Object getInfo() {
        return this.connectorSplit.getInfo();
    }

    public List<HostAddress> getPreferredNodes(NodeProvider nodeProvider) {
        return this.connectorSplit.getPreferredNodes(nodeProvider);
    }

    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return this.connectorSplit.getNodeSelectionStrategy();
    }

    public SplitIdentifier getSplitIdentifier() {
        return new SplitIdentifier(this.connectorId, this.connectorSplit.getSplitIdentifier());
    }

    public SplitWeight getSplitWeight() {
        return this.connectorSplit.getSplitWeight();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("transactionHandle", (Object)this.transactionHandle).add("connectorSplit", (Object)this.connectorSplit).add("lifespan", (Object)this.lifespan).add("splitContext", (Object)this.splitContext).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Split split = (Split)o;
        return this.connectorId.equals((Object)split.connectorId) && this.transactionHandle.equals(split.transactionHandle) && this.connectorSplit.equals(split.connectorSplit) && this.lifespan.equals(split.lifespan);
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.transactionHandle, this.connectorSplit, this.lifespan);
    }

    public static class SplitIdentifier {
        public final ConnectorId connectorId;
        public final Object splitIdentifier;

        public SplitIdentifier(ConnectorId connectorId, Object splitIdentifier) {
            this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
            this.splitIdentifier = Objects.requireNonNull(splitIdentifier, "splitIdentifier is null");
        }

        public ConnectorId getConnectorId() {
            return this.connectorId;
        }

        public Object getSplitIdentifier() {
            return this.splitIdentifier;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SplitIdentifier that = (SplitIdentifier)o;
            return Objects.equals(this.connectorId, that.connectorId) && Objects.equals(this.splitIdentifier, that.splitIdentifier);
        }

        public int hashCode() {
            return Objects.hash(this.connectorId, this.splitIdentifier);
        }
    }
}

