/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.scheduler.ConsistentHashingNodeProvider;
import com.facebook.presto.execution.scheduler.ModularHashingNodeProvider;
import com.facebook.presto.execution.scheduler.NetworkLocation;
import com.facebook.presto.execution.scheduler.NodeSelectionHashStrategy;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeProvider;
import com.google.common.collect.SetMultimap;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NodeMap {
    private final Map<String, InternalNode> activeNodesByNodeId;
    private final SetMultimap<NetworkLocation, InternalNode> activeWorkersByNetworkPath;
    private final Set<String> coordinatorNodeIds;
    private final List<InternalNode> activeNodes;
    private final List<InternalNode> allNodes;
    private final SetMultimap<InetAddress, InternalNode> allNodesByHost;
    private final SetMultimap<HostAddress, InternalNode> allNodesByHostAndPort;
    private final ConsistentHashingNodeProvider consistentHashingNodeProvider;

    public NodeMap(Map<String, InternalNode> activeNodesByNodeId, SetMultimap<NetworkLocation, InternalNode> activeWorkersByNetworkPath, Set<String> coordinatorNodeIds, List<InternalNode> activeNodes, List<InternalNode> allNodes, SetMultimap<InetAddress, InternalNode> allNodesByHost, SetMultimap<HostAddress, InternalNode> allNodesByHostAndPort, ConsistentHashingNodeProvider consistentHashingNodeProvider) {
        this.activeNodesByNodeId = activeNodesByNodeId;
        this.activeWorkersByNetworkPath = activeWorkersByNetworkPath;
        this.coordinatorNodeIds = coordinatorNodeIds;
        this.activeNodes = activeNodes;
        this.allNodes = allNodes;
        this.allNodesByHost = allNodesByHost;
        this.allNodesByHostAndPort = allNodesByHostAndPort;
        this.consistentHashingNodeProvider = consistentHashingNodeProvider;
    }

    public Map<String, InternalNode> getActiveNodesByNodeId() {
        return this.activeNodesByNodeId;
    }

    public SetMultimap<NetworkLocation, InternalNode> getActiveWorkersByNetworkPath() {
        return this.activeWorkersByNetworkPath;
    }

    public Set<String> getCoordinatorNodeIds() {
        return this.coordinatorNodeIds;
    }

    public List<InternalNode> getActiveNodes() {
        return this.activeNodes;
    }

    public List<InternalNode> getAllNodes() {
        return this.allNodes;
    }

    public SetMultimap<InetAddress, InternalNode> getAllNodesByHost() {
        return this.allNodesByHost;
    }

    public SetMultimap<HostAddress, InternalNode> getAllNodesByHostAndPort() {
        return this.allNodesByHostAndPort;
    }

    public NodeProvider getActiveNodeProvider(NodeSelectionHashStrategy nodeSelectionHashStrategy) {
        switch (nodeSelectionHashStrategy) {
            case MODULAR_HASHING: {
                return new ModularHashingNodeProvider(this.activeNodes);
            }
            case CONSISTENT_HASHING: {
                return this.consistentHashingNodeProvider;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown NodeSelectionHashStrategy: %s", new Object[]{nodeSelectionHashStrategy}));
    }
}

