/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeProvider;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ModularHashingNodeProvider
implements NodeProvider {
    private final List<InternalNode> sortedCandidates;

    public ModularHashingNodeProvider(List<InternalNode> sortedCandidates) {
        if (sortedCandidates == null || sortedCandidates.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "sortedCandidates is null or empty for ModularHashingNodeProvider");
        }
        this.sortedCandidates = sortedCandidates;
    }

    public List<HostAddress> get(String identifier, int count) {
        int size = this.sortedCandidates.size();
        int mod = identifier.hashCode() % size;
        int position = mod < 0 ? mod + size : mod;
        ArrayList<HostAddress> chosenCandidates = new ArrayList<HostAddress>();
        for (int i = 0; i < count && i < this.sortedCandidates.size(); ++i) {
            chosenCandidates.add(this.sortedCandidates.get((position + i) % size).getHostAndPort());
        }
        return Collections.unmodifiableList(chosenCandidates);
    }
}

