/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.common.type.encoding.StringUtils;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;

public class ConsistentHashingNodeProvider
implements NodeProvider {
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_32();
    private final NavigableMap<Integer, InternalNode> candidates;

    static ConsistentHashingNodeProvider create(Collection<InternalNode> nodes, int weight) {
        TreeMap<Integer, InternalNode> activeNodesByConsistentHashing = new TreeMap<Integer, InternalNode>();
        for (InternalNode node : nodes) {
            for (int i = 0; i < weight; ++i) {
                activeNodesByConsistentHashing.put(Hashing.murmur3_32().hashString((CharSequence)String.format("%s%d", node.getNodeIdentifier(), i), StringUtils.UTF_8).asInt(), node);
            }
        }
        return new ConsistentHashingNodeProvider(activeNodesByConsistentHashing);
    }

    public ConsistentHashingNodeProvider(NavigableMap<Integer, InternalNode> candidates) {
        this.candidates = Objects.requireNonNull(candidates, "candidates is null");
    }

    public List<HostAddress> get(String key, int count) {
        ImmutableList.Builder nodes = ImmutableList.builder();
        for (int i = 0; i < count; ++i) {
            int hashKey = HASH_FUNCTION.hashString((CharSequence)String.format("%s%d", key, i), StringUtils.UTF_8).asInt();
            Map.Entry<Integer, InternalNode> entry = this.candidates.ceilingEntry(hashKey);
            if (entry != null) {
                nodes.add((Object)this.candidates.ceilingEntry(hashKey).getValue().getHostAndPort());
                continue;
            }
            nodes.add((Object)this.candidates.firstEntry().getValue().getHostAndPort());
        }
        return nodes.build();
    }
}

