/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.resourceGroups;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.node.NodeInfo;
import com.facebook.presto.execution.ManagedQueryExecution;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.resourceGroups.InternalResourceGroup;
import com.facebook.presto.execution.resourceGroups.LegacyResourceGroupConfigurationManager;
import com.facebook.presto.execution.resourceGroups.ResourceGroupConfigurationManagerContextInstance;
import com.facebook.presto.execution.resourceGroups.ResourceGroupManager;
import com.facebook.presto.execution.resourceGroups.ResourceGroupRuntimeInfo;
import com.facebook.presto.resourcemanager.ResourceGroupService;
import com.facebook.presto.server.ResourceGroupInfo;
import com.facebook.presto.server.ServerConfig;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.memory.ClusterMemoryPoolManager;
import com.facebook.presto.spi.resourceGroups.ResourceGroup;
import com.facebook.presto.spi.resourceGroups.ResourceGroupConfigurationManager;
import com.facebook.presto.spi.resourceGroups.ResourceGroupConfigurationManagerContext;
import com.facebook.presto.spi.resourceGroups.ResourceGroupConfigurationManagerFactory;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.resourceGroups.SelectionContext;
import com.facebook.presto.spi.resourceGroups.SelectionCriteria;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.util.PeriodicTaskExecutor;
import com.facebook.presto.util.PropertiesUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.weakref.jmx.JmxException;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.Managed;
import org.weakref.jmx.ObjectNames;

@ThreadSafe
public final class InternalResourceGroupManager<C>
implements ResourceGroupManager<C> {
    private static final Logger log = Logger.get(InternalResourceGroupManager.class);
    private static final File RESOURCE_GROUPS_CONFIGURATION = new File("etc/resource-groups.properties");
    private static final String CONFIGURATION_MANAGER_PROPERTY_NAME = "resource-groups.configuration-manager";
    private final ScheduledExecutorService refreshExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"ResourceGroupManager"));
    private final PeriodicTaskExecutor resourceGroupRuntimeExecutor;
    private final List<InternalResourceGroup.RootInternalResourceGroup> rootGroups = new CopyOnWriteArrayList<InternalResourceGroup.RootInternalResourceGroup>();
    private final ConcurrentMap<ResourceGroupId, InternalResourceGroup> groups = new ConcurrentHashMap<ResourceGroupId, InternalResourceGroup>();
    private final AtomicReference<ResourceGroupConfigurationManager<C>> configurationManager;
    private final ResourceGroupConfigurationManagerContext configurationManagerContext;
    private final ResourceGroupConfigurationManager<?> legacyManager;
    private final MBeanExporter exporter;
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicLong lastCpuQuotaGenerationNanos = new AtomicLong(System.nanoTime());
    private final Map<String, ResourceGroupConfigurationManagerFactory> configurationManagerFactories = new ConcurrentHashMap<String, ResourceGroupConfigurationManagerFactory>();
    private final AtomicBoolean taskLimitExceeded = new AtomicBoolean();
    private final int maxTotalRunningTaskCountToNotExecuteNewQuery;
    private final AtomicLong lastSchedulingCycleRunTimeMs = new AtomicLong(System.currentTimeMillis());
    private final ResourceGroupService resourceGroupService;
    private final AtomicReference<Map<ResourceGroupId, ResourceGroupRuntimeInfo>> resourceGroupRuntimeInfos = new AtomicReference<ImmutableMap>(ImmutableMap.of());
    private final AtomicReference<Map<ResourceGroupId, ResourceGroupRuntimeInfo>> resourceGroupRuntimeInfosSnapshot = new AtomicReference<ImmutableMap>(ImmutableMap.of());
    private final AtomicLong lastUpdatedResourceGroupRuntimeInfo = new AtomicLong(-1L);
    private final double concurrencyThreshold;
    private final Duration resourceGroupRuntimeInfoRefreshInterval;
    private final boolean isResourceManagerEnabled;

    @Inject
    public InternalResourceGroupManager(LegacyResourceGroupConfigurationManager legacyManager, ClusterMemoryPoolManager memoryPoolManager, QueryManagerConfig queryManagerConfig, NodeInfo nodeInfo, MBeanExporter exporter, ResourceGroupService resourceGroupService, ServerConfig serverConfig) {
        Objects.requireNonNull(queryManagerConfig, "queryManagerConfig is null");
        this.exporter = Objects.requireNonNull(exporter, "exporter is null");
        this.configurationManagerContext = new ResourceGroupConfigurationManagerContextInstance(memoryPoolManager, nodeInfo.getEnvironment());
        this.legacyManager = Objects.requireNonNull(legacyManager, "legacyManager is null");
        this.configurationManager = new AtomicReference<ResourceGroupConfigurationManager<C>>(InternalResourceGroupManager.cast(legacyManager));
        this.maxTotalRunningTaskCountToNotExecuteNewQuery = queryManagerConfig.getMaxTotalRunningTaskCountToNotExecuteNewQuery();
        this.resourceGroupService = Objects.requireNonNull(resourceGroupService, "resourceGroupService is null");
        this.concurrencyThreshold = queryManagerConfig.getConcurrencyThresholdToEnableResourceGroupRefresh();
        this.resourceGroupRuntimeInfoRefreshInterval = queryManagerConfig.getResourceGroupRunTimeInfoRefreshInterval();
        this.isResourceManagerEnabled = Objects.requireNonNull(serverConfig, "serverConfig is null").isResourceManagerEnabled();
        this.resourceGroupRuntimeExecutor = new PeriodicTaskExecutor(this.resourceGroupRuntimeInfoRefreshInterval.toMillis(), this.refreshExecutor, this::refreshResourceGroupRuntimeInfo);
    }

    @Override
    public ResourceGroupInfo getResourceGroupInfo(ResourceGroupId id, boolean includeQueryInfo, boolean summarizeSubgroups, boolean includeStaticSubgroupsOnly) {
        Preconditions.checkArgument((boolean)this.groups.containsKey(id), (String)"Group %s does not exist", (Object)id);
        return ((InternalResourceGroup)this.groups.get(id)).getResourceGroupInfo(includeQueryInfo, summarizeSubgroups, includeStaticSubgroupsOnly);
    }

    @Override
    public List<ResourceGroupInfo> getPathToRoot(ResourceGroupId id) {
        Preconditions.checkArgument((boolean)this.groups.containsKey(id), (String)"Group %s does not exist", (Object)id);
        return ((InternalResourceGroup)this.groups.get(id)).getPathToRoot();
    }

    @Override
    public void submit(Statement statement, ManagedQueryExecution queryExecution, SelectionContext<C> selectionContext, Executor executor) {
        Preconditions.checkState((this.configurationManager.get() != null ? 1 : 0) != 0, (Object)"configurationManager not set");
        this.createGroupIfNecessary(selectionContext, executor);
        ((InternalResourceGroup)this.groups.get(selectionContext.getResourceGroupId())).run(queryExecution);
    }

    @Override
    public SelectionContext<C> selectGroup(SelectionCriteria criteria) {
        return (SelectionContext)this.configurationManager.get().match(criteria).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_REJECTED, "Query did not match any selection rule"));
    }

    @Override
    public void addConfigurationManagerFactory(ResourceGroupConfigurationManagerFactory factory) {
        if (this.configurationManagerFactories.putIfAbsent(factory.getName(), factory) != null) {
            throw new IllegalArgumentException(String.format("Resource group configuration manager '%s' is already registered", factory.getName()));
        }
    }

    @Override
    public void loadConfigurationManager() throws Exception {
        if (RESOURCE_GROUPS_CONFIGURATION.exists()) {
            HashMap<String, String> properties = new HashMap<String, String>(PropertiesUtil.loadProperties(RESOURCE_GROUPS_CONFIGURATION));
            String configurationManagerName = (String)properties.remove(CONFIGURATION_MANAGER_PROPERTY_NAME);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)configurationManagerName) ? 1 : 0) != 0, (String)"Resource groups configuration %s does not contain %s", (Object)RESOURCE_GROUPS_CONFIGURATION.getAbsoluteFile(), (Object)CONFIGURATION_MANAGER_PROPERTY_NAME);
            this.setConfigurationManager(configurationManagerName, properties);
        }
    }

    @VisibleForTesting
    public void setConfigurationManager(String name, Map<String, String> properties) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(properties, "properties is null");
        log.info("-- Loading resource group configuration manager --");
        ResourceGroupConfigurationManagerFactory configurationManagerFactory = this.configurationManagerFactories.get(name);
        Preconditions.checkState((configurationManagerFactory != null ? 1 : 0) != 0, (String)"Resource group configuration manager %s is not registered", (Object)name);
        ResourceGroupConfigurationManager<C> configurationManager = InternalResourceGroupManager.cast(configurationManagerFactory.create((Map)ImmutableMap.copyOf(properties), this.configurationManagerContext));
        Preconditions.checkState((boolean)this.configurationManager.compareAndSet(InternalResourceGroupManager.cast(this.legacyManager), configurationManager), (Object)"configurationManager already set");
        log.info("-- Loaded resource group configuration manager %s --", new Object[]{name});
    }

    @VisibleForTesting
    public ResourceGroupConfigurationManager<C> getConfigurationManager() {
        ResourceGroupConfigurationManager<C> manager = this.configurationManager.get();
        Preconditions.checkState((manager != this.legacyManager ? 1 : 0) != 0, (Object)"cannot fetch legacy manager");
        return manager;
    }

    @PreDestroy
    public void destroy() {
        this.refreshExecutor.shutdownNow();
        this.resourceGroupRuntimeExecutor.stop();
    }

    @PostConstruct
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.refreshExecutor.scheduleWithFixedDelay(() -> {
                try {
                    this.refreshAndStartQueries();
                    this.lastSchedulingCycleRunTimeMs.getAndSet(System.currentTimeMillis());
                }
                catch (Throwable t) {
                    log.error(t, "Error while executing refreshAndStartQueries");
                    throw t;
                }
            }, 1L, 1L, TimeUnit.MILLISECONDS);
            if (this.isResourceManagerEnabled) {
                this.resourceGroupRuntimeExecutor.start();
            }
        }
    }

    private void refreshResourceGroupRuntimeInfo() {
        try {
            List<ResourceGroupRuntimeInfo> resourceGroupInfos = this.resourceGroupService.getResourceGroupInfo();
            this.resourceGroupRuntimeInfos.set((Map<ResourceGroupId, ResourceGroupRuntimeInfo>)resourceGroupInfos.stream().collect(ImmutableMap.toImmutableMap(ResourceGroupRuntimeInfo::getResourceGroupId, i -> i)));
            this.lastUpdatedResourceGroupRuntimeInfo.set(System.currentTimeMillis());
            boolean updatedSnapshot = this.updateResourceGroupsSnapshot();
            if (updatedSnapshot) {
                this.rootGroups.forEach(group -> group.setDirty());
            }
        }
        catch (Throwable t) {
            log.error(t, "Error while executing refreshAndStartQueries");
        }
    }

    private void refreshAndStartQueries() {
        long nanoTime = System.nanoTime();
        long elapsedSeconds = TimeUnit.NANOSECONDS.toSeconds(nanoTime - this.lastCpuQuotaGenerationNanos.get());
        if (elapsedSeconds > 0L) {
            this.lastCpuQuotaGenerationNanos.addAndGet(elapsedSeconds * 1000000000L);
        } else if (elapsedSeconds < 0L) {
            this.lastCpuQuotaGenerationNanos.set(nanoTime);
        }
        if (this.maxTotalRunningTaskCountToNotExecuteNewQuery != Integer.MAX_VALUE) {
            this.taskLimitExceeded.set(this.getTotalRunningTaskCount() > this.maxTotalRunningTaskCountToNotExecuteNewQuery);
        }
        for (InternalResourceGroup.RootInternalResourceGroup group : this.rootGroups) {
            try {
                if (elapsedSeconds > 0L) {
                    group.generateCpuQuota(elapsedSeconds);
                }
            }
            catch (RuntimeException e) {
                log.error((Throwable)e, "Exception while generation cpu quota for %s", new Object[]{group});
            }
            try {
                group.setTaskLimitExceeded(this.taskLimitExceeded.get());
                group.processQueuedQueries();
            }
            catch (RuntimeException e) {
                log.error((Throwable)e, "Exception while processing queued queries for %s", new Object[]{group});
            }
        }
    }

    private boolean updateResourceGroupsSnapshot() {
        if (!this.isResourceManagerEnabled) {
            return false;
        }
        Map<ResourceGroupId, ResourceGroupRuntimeInfo> snapshotValue = this.resourceGroupRuntimeInfos.getAndAccumulate(this.resourceGroupRuntimeInfosSnapshot.get(), (current, update) -> current != update ? update : null);
        if (snapshotValue != null) {
            this.resourceGroupRuntimeInfosSnapshot.set(snapshotValue);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public Map<ResourceGroupId, ResourceGroupRuntimeInfo> getResourceGroupRuntimeInfosSnapshot() {
        return this.resourceGroupRuntimeInfosSnapshot.get();
    }

    private synchronized void createGroupIfNecessary(SelectionContext<C> context, Executor executor) {
        ResourceGroupId id = context.getResourceGroupId();
        if (!this.groups.containsKey(id)) {
            InternalResourceGroup group;
            if (id.getParent().isPresent()) {
                this.createGroupIfNecessary(new SelectionContext((ResourceGroupId)id.getParent().get(), context.getContext()), executor);
                InternalResourceGroup parent = (InternalResourceGroup)this.groups.get(id.getParent().get());
                Objects.requireNonNull(parent, "parent is null");
                int subGroupSegmentIndex = parent.getId().getSegments().size();
                group = parent.getOrCreateSubGroup(id.getLastSegment(), !context.getFirstDynamicSegmentPosition().equals(OptionalInt.of(subGroupSegmentIndex)));
            } else {
                InternalResourceGroup.RootInternalResourceGroup root = !this.isResourceManagerEnabled ? new InternalResourceGroup.RootInternalResourceGroup((String)id.getSegments().get(0), this::exportGroup, executor, ignored -> Optional.empty(), rg -> false) : new InternalResourceGroup.RootInternalResourceGroup((String)id.getSegments().get(0), this::exportGroup, executor, resourceGroupId -> Optional.ofNullable(this.resourceGroupRuntimeInfosSnapshot.get().get(resourceGroupId)), rg -> InternalResourceGroupManager.shouldWaitForResourceManagerUpdate(rg, this.resourceGroupRuntimeInfosSnapshot::get, this.lastUpdatedResourceGroupRuntimeInfo::get, this.concurrencyThreshold));
                group = root;
                this.rootGroups.add(root);
            }
            this.configurationManager.get().configure((ResourceGroup)group, context);
            Preconditions.checkState((this.groups.put(id, group) == null ? 1 : 0) != 0, (Object)"Unexpected existing resource group");
        }
    }

    private void exportGroup(InternalResourceGroup group, Boolean export) {
        String objectName = ObjectNames.builder(InternalResourceGroup.class, (String)group.getId().toString()).build();
        try {
            if (export.booleanValue()) {
                this.exporter.export(objectName, (Object)group);
            } else {
                this.exporter.unexport(objectName);
            }
        }
        catch (JmxException e) {
            log.error((Throwable)e, "Error %s resource group %s", new Object[]{export != false ? "exporting" : "unexporting", group.getId()});
        }
    }

    private static boolean shouldWaitForResourceManagerUpdate(InternalResourceGroup resourceGroup, Supplier<Map<ResourceGroupId, ResourceGroupRuntimeInfo>> resourceGroupRuntimeInfos, LongSupplier lastUpdatedResourceGroupRuntimeInfo, double concurrencyThreshold) {
        int hardConcurrencyLimit = resourceGroup.getHardConcurrencyLimitBasedOnCpuUsage();
        int totalRunningQueries = resourceGroup.getRunningQueries();
        ResourceGroupRuntimeInfo resourceGroupRuntimeInfo = resourceGroupRuntimeInfos.get().get(resourceGroup.getId());
        if (resourceGroupRuntimeInfo != null) {
            totalRunningQueries += resourceGroupRuntimeInfo.getRunningQueries() + resourceGroupRuntimeInfo.getDescendantRunningQueries();
        }
        return (double)totalRunningQueries >= (double)hardConcurrencyLimit * concurrencyThreshold && lastUpdatedResourceGroupRuntimeInfo.getAsLong() <= resourceGroup.getLastRunningQueryStartTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public int getQueriesQueuedOnInternal() {
        int queriesQueuedInternal = 0;
        Iterator<InternalResourceGroup.RootInternalResourceGroup> iterator = this.rootGroups.iterator();
        while (iterator.hasNext()) {
            InternalResourceGroup.RootInternalResourceGroup rootGroup;
            InternalResourceGroup.RootInternalResourceGroup rootInternalResourceGroup = rootGroup = iterator.next();
            synchronized (rootInternalResourceGroup) {
                queriesQueuedInternal += this.getQueriesQueuedOnInternal(rootGroup);
            }
        }
        return queriesQueuedInternal;
    }

    @Managed
    public long getLastSchedulingCycleRuntimeDelayMs() {
        return System.currentTimeMillis() - this.lastSchedulingCycleRunTimeMs.get();
    }

    private int getQueriesQueuedOnInternal(InternalResourceGroup resourceGroup) {
        if (resourceGroup.subGroups().isEmpty()) {
            ResourceGroupRuntimeInfo resourceGroupRuntimeInfo;
            int queuedQueries = resourceGroup.getQueuedQueries();
            int runningQueries = resourceGroup.getRunningQueries();
            if (this.isResourceManagerEnabled && (resourceGroupRuntimeInfo = this.resourceGroupRuntimeInfos.get().get(resourceGroup.getId())) != null) {
                queuedQueries += resourceGroupRuntimeInfo.getQueuedQueries();
                runningQueries += resourceGroupRuntimeInfo.getRunningQueries();
            }
            return Math.max(Math.min(queuedQueries, resourceGroup.getSoftConcurrencyLimit() - runningQueries), 0);
        }
        int queriesQueuedInternal = 0;
        for (InternalResourceGroup subGroup : resourceGroup.subGroups()) {
            queriesQueuedInternal += this.getQueriesQueuedOnInternal(subGroup);
        }
        return queriesQueuedInternal;
    }

    @Managed
    public int getTaskLimitExceeded() {
        return this.taskLimitExceeded.get() ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTotalRunningTaskCount() {
        int taskCount = 0;
        Iterator<InternalResourceGroup.RootInternalResourceGroup> iterator = this.rootGroups.iterator();
        while (iterator.hasNext()) {
            InternalResourceGroup.RootInternalResourceGroup rootGroup;
            InternalResourceGroup.RootInternalResourceGroup rootInternalResourceGroup = rootGroup = iterator.next();
            synchronized (rootInternalResourceGroup) {
                taskCount += rootGroup.getRunningTaskCount();
            }
        }
        return taskCount;
    }

    @VisibleForTesting
    public void setTaskLimitExceeded(boolean exceeded) {
        this.taskLimitExceeded.set(exceeded);
        for (InternalResourceGroup.RootInternalResourceGroup group : this.rootGroups) {
            group.setTaskLimitExceeded(exceeded);
        }
    }

    private static <C> ResourceGroupConfigurationManager<C> cast(ResourceGroupConfigurationManager<?> manager) {
        return manager;
    }
}

