/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.stats.Distribution;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.StageExecutionId;
import com.facebook.presto.execution.StageExecutionState;
import com.facebook.presto.execution.StageExecutionStats;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.PipelineStats;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.spi.eventlistener.StageGcStatistics;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;

public class StageExecutionInfo {
    private final StageExecutionState state;
    private final StageExecutionStats stats;
    private final List<TaskInfo> tasks;
    private final Optional<ExecutionFailureInfo> failureCause;

    public static StageExecutionInfo create(StageExecutionId stageExecutionId, StageExecutionState state, Optional<ExecutionFailureInfo> failureInfo, List<TaskInfo> taskInfos, DateTime schedulingComplete, Distribution.DistributionSnapshot getSplitDistribution, DataSize peakUserMemoryReservation, DataSize peakNodeTotalMemoryReservation, int finishedLifespans, int totalLifespans) {
        int totalTasks = taskInfos.size();
        int runningTasks = 0;
        int completedTasks = 0;
        int totalDrivers = 0;
        int queuedDrivers = 0;
        int runningDrivers = 0;
        int blockedDrivers = 0;
        int completedDrivers = 0;
        double cumulativeUserMemory = 0.0;
        double cumulativeTotalMemory = 0.0;
        long userMemoryReservation = 0L;
        long totalMemoryReservation = 0L;
        long totalScheduledTime = 0L;
        long totalCpuTime = 0L;
        long retriedCpuTime = 0L;
        long totalBlockedTime = 0L;
        long totalAllocation = 0L;
        long rawInputDataSize = 0L;
        long rawInputPositions = 0L;
        long processedInputDataSize = 0L;
        long processedInputPositions = 0L;
        long bufferedDataSize = 0L;
        long outputDataSize = 0L;
        long outputPositions = 0L;
        long physicalWrittenDataSize = 0L;
        int fullGcCount = 0;
        int fullGcTaskCount = 0;
        int minFullGcSec = 0;
        int maxFullGcSec = 0;
        int totalFullGcSec = 0;
        boolean fullyBlocked = true;
        HashSet<BlockedReason> blockedReasons = new HashSet<BlockedReason>();
        HashMap<String, OperatorStats> operatorToStats = new HashMap<String, OperatorStats>();
        RuntimeStats mergedRuntimeStats = new RuntimeStats();
        mergedRuntimeStats.addMetricValueIgnoreZero("getSplitsTimeNanos", (long)getSplitDistribution.getTotal());
        for (TaskInfo taskInfo : taskInfos) {
            TaskState taskState = taskInfo.getTaskStatus().getState();
            if (taskState.isDone()) {
                ++completedTasks;
            } else {
                ++runningTasks;
            }
            TaskStats taskStats = taskInfo.getStats();
            totalDrivers += taskStats.getTotalDrivers();
            queuedDrivers += taskStats.getQueuedDrivers();
            runningDrivers += taskStats.getRunningDrivers();
            blockedDrivers += taskStats.getBlockedDrivers();
            completedDrivers += taskStats.getCompletedDrivers();
            cumulativeUserMemory += taskStats.getCumulativeUserMemory();
            cumulativeTotalMemory += taskStats.getCumulativeTotalMemory();
            long taskUserMemory = taskStats.getUserMemoryReservationInBytes();
            long taskSystemMemory = taskStats.getSystemMemoryReservationInBytes();
            userMemoryReservation += taskUserMemory;
            totalMemoryReservation += taskUserMemory + taskSystemMemory;
            totalScheduledTime += taskStats.getTotalScheduledTimeInNanos();
            totalCpuTime += taskStats.getTotalCpuTimeInNanos();
            if (state == StageExecutionState.FINISHED && taskInfo.getTaskStatus().getState() == TaskState.FAILED) {
                retriedCpuTime += taskStats.getTotalCpuTimeInNanos();
            }
            totalBlockedTime += taskStats.getTotalBlockedTimeInNanos();
            if (!taskState.isDone()) {
                fullyBlocked &= taskStats.isFullyBlocked();
                blockedReasons.addAll(taskStats.getBlockedReasons());
            }
            totalAllocation += taskStats.getTotalAllocationInBytes();
            rawInputDataSize += taskStats.getRawInputDataSizeInBytes();
            rawInputPositions += taskStats.getRawInputPositions();
            processedInputDataSize += taskStats.getProcessedInputDataSizeInBytes();
            processedInputPositions += taskStats.getProcessedInputPositions();
            bufferedDataSize += taskInfo.getOutputBuffers().getTotalBufferedBytes();
            outputDataSize += taskStats.getOutputDataSizeInBytes();
            outputPositions += taskStats.getOutputPositions();
            physicalWrittenDataSize += taskStats.getPhysicalWrittenDataSizeInBytes();
            fullGcCount += taskStats.getFullGcCount();
            fullGcTaskCount += taskStats.getFullGcCount() > 0 ? 1 : 0;
            int gcSec = Math.toIntExact(TimeUnit.MILLISECONDS.toSeconds(taskStats.getFullGcTimeInMillis()));
            totalFullGcSec += gcSec;
            minFullGcSec = Math.min(minFullGcSec, gcSec);
            maxFullGcSec = Math.max(maxFullGcSec, gcSec);
            for (PipelineStats pipeline : taskStats.getPipelines()) {
                for (OperatorStats operatorStats : pipeline.getOperatorSummaries()) {
                    String id = pipeline.getPipelineId() + "." + operatorStats.getOperatorId();
                    operatorToStats.compute(id, (k, v) -> v == null ? operatorStats : v.add(operatorStats));
                }
            }
            mergedRuntimeStats.mergeWith(taskStats.getRuntimeStats());
            mergedRuntimeStats.addMetricValue("driverCountPerTask", (long)taskStats.getTotalDrivers());
            mergedRuntimeStats.addMetricValue("taskElapsedTimeNanos", taskStats.getElapsedTimeInNanos());
            mergedRuntimeStats.addMetricValueIgnoreZero("taskQueuedTimeNanos", taskStats.getQueuedTimeInNanos());
            mergedRuntimeStats.addMetricValue("taskScheduledTimeNanos", taskStats.getTotalScheduledTimeInNanos());
            mergedRuntimeStats.addMetricValueIgnoreZero("taskBlockedTimeNanos", taskStats.getTotalBlockedTimeInNanos());
        }
        StageExecutionStats stageExecutionStats = new StageExecutionStats(schedulingComplete, getSplitDistribution, totalTasks, runningTasks, completedTasks, totalLifespans, finishedLifespans, totalDrivers, queuedDrivers, runningDrivers, blockedDrivers, completedDrivers, cumulativeUserMemory, cumulativeTotalMemory, DataSize.succinctBytes((long)userMemoryReservation), DataSize.succinctBytes((long)totalMemoryReservation), peakUserMemoryReservation, peakNodeTotalMemoryReservation, Duration.succinctDuration((double)totalScheduledTime, (TimeUnit)TimeUnit.NANOSECONDS), Duration.succinctDuration((double)totalCpuTime, (TimeUnit)TimeUnit.NANOSECONDS), Duration.succinctDuration((double)retriedCpuTime, (TimeUnit)TimeUnit.NANOSECONDS), Duration.succinctDuration((double)totalBlockedTime, (TimeUnit)TimeUnit.NANOSECONDS), fullyBlocked && runningTasks > 0, blockedReasons, DataSize.succinctBytes((long)totalAllocation), DataSize.succinctBytes((long)rawInputDataSize), rawInputPositions, DataSize.succinctBytes((long)processedInputDataSize), processedInputPositions, DataSize.succinctBytes((long)bufferedDataSize), DataSize.succinctBytes((long)outputDataSize), outputPositions, DataSize.succinctBytes((long)physicalWrittenDataSize), new StageGcStatistics(stageExecutionId.getStageId().getId(), stageExecutionId.getId(), totalTasks, fullGcTaskCount, minFullGcSec, maxFullGcSec, totalFullGcSec, (int)(1.0 * (double)totalFullGcSec / (double)fullGcCount)), (List<OperatorStats>)ImmutableList.copyOf(operatorToStats.values()), mergedRuntimeStats);
        return new StageExecutionInfo(state, stageExecutionStats, taskInfos, failureInfo);
    }

    @JsonCreator
    public StageExecutionInfo(@JsonProperty(value="state") StageExecutionState state, @JsonProperty(value="stats") StageExecutionStats stats, @JsonProperty(value="tasks") List<TaskInfo> tasks, @JsonProperty(value="failureCause") Optional<ExecutionFailureInfo> failureCause) {
        this.state = Objects.requireNonNull(state, "state is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.tasks = ImmutableList.copyOf((Collection)Objects.requireNonNull(tasks, "tasks is null"));
        this.failureCause = Objects.requireNonNull(failureCause, "failureCause is null");
    }

    @JsonProperty
    public StageExecutionState getState() {
        return this.state;
    }

    @JsonProperty
    public StageExecutionStats getStats() {
        return this.stats;
    }

    @JsonProperty
    public List<TaskInfo> getTasks() {
        return this.tasks;
    }

    @JsonProperty
    public Optional<ExecutionFailureInfo> getFailureCause() {
        return this.failureCause;
    }

    public boolean isFinal() {
        return this.state.isDone() && this.tasks.stream().allMatch(taskInfo -> taskInfo.getTaskStatus().getState().isDone());
    }

    public static StageExecutionInfo unscheduledExecutionInfo(int stageId, boolean isQueryDone) {
        return new StageExecutionInfo(isQueryDone ? StageExecutionState.ABORTED : StageExecutionState.PLANNED, StageExecutionStats.zero(stageId), (List<TaskInfo>)ImmutableList.of(), Optional.empty());
    }
}

