/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DisjointSet<T> {
    private final Map<T, Entry<T>> map = new LinkedHashMap<T, Entry<T>>();

    public boolean findAndUnion(T node1, T node2) {
        return this.union(this.find(node1), this.find(node2));
    }

    public T find(T element) {
        if (!this.map.containsKey(element)) {
            this.map.put(element, new Entry());
            return element;
        }
        return this.findInternal(element);
    }

    private boolean union(T root1, T root2) {
        if (root1.equals(root2)) {
            return false;
        }
        Entry<T> entry1 = this.map.get(root1);
        Entry<T> entry2 = this.map.get(root2);
        int entry1Rank = entry1.getRank();
        int entry2Rank = entry2.getRank();
        Verify.verify((entry1Rank >= 0 ? 1 : 0) != 0);
        Verify.verify((entry2Rank >= 0 ? 1 : 0) != 0);
        if (entry1Rank < entry2Rank) {
            entry1.setParent(root2);
        } else {
            if (entry1Rank == entry2Rank) {
                entry1.incrementRank();
            }
            entry2.setParent(root1);
        }
        return true;
    }

    private T findInternal(T element) {
        Entry<T> value = this.map.get(element);
        if (value.getParent() == null) {
            return element;
        }
        T root = this.findInternal(value.getParent());
        value.setParent(root);
        return root;
    }

    public Collection<Set<T>> getEquivalentClasses() {
        LinkedHashMap<Object, Set> rootToTreeElements = new LinkedHashMap<Object, Set>();
        for (Map.Entry<T, Entry<T>> entry : this.map.entrySet()) {
            T node = entry.getKey();
            T root = this.findInternal(node);
            rootToTreeElements.computeIfAbsent(root, unused -> new LinkedHashSet());
            ((Set)rootToTreeElements.get(root)).add(node);
        }
        return rootToTreeElements.values();
    }

    private static class Entry<T> {
        private T parent;
        private int rank;

        public Entry() {
            this(null, 0);
        }

        public Entry(Entry<T> entry) {
            this(entry.parent, entry.rank);
        }

        private Entry(T parent, int rank) {
            this.parent = parent;
            this.rank = rank;
        }

        public T getParent() {
            return this.parent;
        }

        public void setParent(T parent) {
            this.parent = parent;
            this.rank = -1;
        }

        public int getRank() {
            Preconditions.checkState((this.parent == null ? 1 : 0) != 0);
            return this.rank;
        }

        public void incrementRank() {
            Preconditions.checkState((this.parent == null ? 1 : 0) != 0);
            ++this.rank;
        }
    }
}

