/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.VarcharEnumType;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import java.util.Optional;

public final class VarcharEnumOperators {
    private VarcharEnumOperators() {
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @TypeParameter(value="T", boundedBy="VarcharEnum")
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equal(@SqlType(value="T") Slice left, @SqlType(value="T") Slice right) {
        return left.equals((Object)right);
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @TypeParameter(value="T", boundedBy="VarcharEnum")
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean notEqual(@SqlType(value="T") Slice left, @SqlType(value="T") Slice right) {
        return !left.equals((Object)right);
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    @TypeParameter(value="T", boundedBy="VarcharEnum")
    @SqlType(value="boolean")
    public static boolean isDistinctFrom(@SqlType(value="T") Slice left, @IsNull boolean leftNull, @SqlType(value="T") Slice right, @IsNull boolean rightNull) {
        if (leftNull != rightNull) {
            return true;
        }
        if (leftNull) {
            return false;
        }
        return VarcharEnumOperators.notEqual(left, right);
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @TypeParameter(value="T", boundedBy="VarcharEnum")
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="T") Slice value) {
        return VarcharEnumOperators.xxHash64(value);
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    @TypeParameter(value="T", boundedBy="VarcharEnum")
    @SqlType(value="bigint")
    public static long xxHash64(@SqlType(value="T") Slice value) {
        return XxHash64.hash((Slice)value);
    }

    @ScalarOperator(value=OperatorType.INDETERMINATE)
    @TypeParameter(value="T", boundedBy="VarcharEnum")
    @SqlType(value="boolean")
    public static boolean indeterminate(@SqlType(value="T") Slice value, @IsNull boolean isNull) {
        return isNull;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @TypeParameter(value="T", boundedBy="VarcharEnum")
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="T") Slice left, @SqlType(value="T") Slice right) {
        return left.compareTo(right) < 0;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @TypeParameter(value="T", boundedBy="VarcharEnum")
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="T") Slice left, @SqlType(value="T") Slice right) {
        return left.compareTo(right) <= 0;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @TypeParameter(value="T", boundedBy="VarcharEnum")
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="T") Slice left, @SqlType(value="T") Slice right) {
        return left.compareTo(right) > 0;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @TypeParameter(value="T", boundedBy="VarcharEnum")
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="T") Slice left, @SqlType(value="T") Slice right) {
        return left.compareTo(right) >= 0;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @TypeParameter(value="T", boundedBy="VarcharEnum")
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="T") Slice value, @SqlType(value="T") Slice min, @SqlType(value="T") Slice max) {
        return min.compareTo(value) <= 0 && value.compareTo(max) <= 0;
    }

    @Description(value="Get the key corresponding to an enum value")
    @ScalarFunction(value="enum_key")
    @TypeParameter(value="T", boundedBy="VarcharEnum")
    @SqlType(value="varchar")
    public static Slice enumKey(@TypeParameter(value="T") VarcharEnumType enumType, @SqlType(value="T") Slice value) {
        Optional key = enumType.getEnumKeyForValue(value.toStringUtf8());
        if (!key.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("No value '%s' in enum type %s", value.toStringUtf8(), enumType.getTypeSignature().getBase()));
        }
        return Slices.utf8Slice((String)((String)key.get()));
    }
}

