/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.rewrite;

import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ConnectorMaterializedViewDefinition;
import com.facebook.presto.sql.analyzer.MaterializedViewCandidateExtractor;
import com.facebook.presto.sql.analyzer.MaterializedViewQueryOptimizer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.relational.RowExpressionDomainTranslator;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Table;
import java.util.Set;

public class MaterializedViewOptimizationRewriteUtils {
    private MaterializedViewOptimizationRewriteUtils() {
    }

    public static Query optimizeQueryUsingMaterializedView(Metadata metadata, Session session, SqlParser sqlParser, AccessControl accessControl, Query node) {
        MaterializedViewCandidateExtractor materializedViewCandidateExtractor = new MaterializedViewCandidateExtractor(session, metadata);
        materializedViewCandidateExtractor.process((Node)node);
        Set<QualifiedObjectName> materializedViewCandidates = materializedViewCandidateExtractor.getMaterializedViewCandidates();
        if (materializedViewCandidates.isEmpty()) {
            return node;
        }
        Query optimizedQuery = MaterializedViewOptimizationRewriteUtils.getQueryWithMaterializedViewOptimization(metadata, session, sqlParser, accessControl, node, materializedViewCandidates.iterator().next());
        return optimizedQuery;
    }

    private static Query getQueryWithMaterializedViewOptimization(Metadata metadata, Session session, SqlParser sqlParser, AccessControl accessControl, Query statement, QualifiedObjectName materializedViewQualifiedObjectName) {
        ConnectorMaterializedViewDefinition materializedView = metadata.getMaterializedView(session, materializedViewQualifiedObjectName).get();
        Table materializedViewTable = new Table(QualifiedName.of((String)materializedView.getTable()));
        Query materializedViewDefinition = (Query)sqlParser.createStatement(materializedView.getOriginalSql());
        return (Query)new MaterializedViewQueryOptimizer(metadata, session, sqlParser, accessControl, new RowExpressionDomainTranslator(metadata), materializedViewTable, materializedViewDefinition).rewrite((Node)statement);
    }
}

