/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.ExpressionExtractor;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.sanity.PlanChecker;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.google.common.collect.ImmutableList;
import java.util.List;

public final class NoSubqueryExpressionLeftChecker
implements PlanChecker.Checker {
    @Override
    public void validate(PlanNode plan, Session session, Metadata metadata, SqlParser sqlParser, TypeProvider types, WarningCollector warningCollector) {
        List expressions = (List)ExpressionExtractor.extractExpressions(plan).stream().filter(OriginalExpressionUtils::isExpression).map(OriginalExpressionUtils::castToExpression).collect(ImmutableList.toImmutableList());
        for (Expression expression : expressions) {
            new DefaultTraversalVisitor<Void, Void>(){

                protected Void visitSubqueryExpression(SubqueryExpression node, Void context) {
                    throw new IllegalStateException(String.format("Unexpected subquery expression in logical plan: %s", node));
                }
            }.process((Node)expression, null);
        }
    }
}

