/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class AggregationNodeUtils {
    private AggregationNodeUtils() {
    }

    public static AggregationNode.Aggregation count(FunctionAndTypeManager functionAndTypeManager) {
        return new AggregationNode.Aggregation(new CallExpression("count", new FunctionResolution(functionAndTypeManager).countFunction(), (Type)BigintType.BIGINT, (List)ImmutableList.of()), Optional.empty(), Optional.empty(), false, Optional.empty());
    }

    public static Set<VariableReferenceExpression> extractAggregationUniqueVariables(AggregationNode.Aggregation aggregation, TypeProvider types) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        aggregation.getArguments().forEach(argument -> builder.addAll(AggregationNodeUtils.extractAll(argument, types)));
        aggregation.getFilter().ifPresent(filter -> builder.addAll(AggregationNodeUtils.extractAll(filter, types)));
        aggregation.getOrderBy().ifPresent(orderingScheme -> builder.addAll((Iterable)orderingScheme.getOrderByVariables()));
        return builder.build();
    }

    private static List<VariableReferenceExpression> extractAll(RowExpression expression, TypeProvider types) {
        if (OriginalExpressionUtils.isExpression(expression)) {
            return VariablesExtractor.extractAll(OriginalExpressionUtils.castToExpression(expression), types);
        }
        return (List)VariablesExtractor.extractAll(expression).stream().collect(ImmutableList.toImmutableList());
    }
}

