/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.SymbolMapper;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class PushPartialAggregationThroughExchange
implements Rule<AggregationNode> {
    private final FunctionAndTypeManager functionAndTypeManager;
    private static final Capture<ExchangeNode> EXCHANGE_NODE = Capture.newCapture();
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().with(Patterns.source().matching(Patterns.exchange().matching(node -> !node.getOrderingScheme().isPresent()).capturedAs(EXCHANGE_NODE)));

    public PushPartialAggregationThroughExchange(FunctionAndTypeManager functionAndTypeManager) {
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionManager is null");
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode aggregationNode, Captures captures, Rule.Context context) {
        ExchangeNode exchangeNode = (ExchangeNode)((Object)captures.get(EXCHANGE_NODE));
        boolean decomposable = AggregationUtils.isDecomposable(aggregationNode, this.functionAndTypeManager);
        if (aggregationNode.getStep().equals((Object)AggregationNode.Step.SINGLE) && aggregationNode.hasEmptyGroupingSet() && aggregationNode.hasNonEmptyGroupingSet() && exchangeNode.getType() == ExchangeNode.Type.REPARTITION) {
            Preconditions.checkState((boolean)decomposable, (Object)"Distributed aggregation with empty grouping set requires partial but functions are not decomposable");
            return Rule.Result.ofPlanNode(this.split(aggregationNode, context));
        }
        FeaturesConfig.PartialAggregationStrategy partialAggregationStrategy = SystemSessionProperties.getPartialAggregationStrategy(context.getSession());
        if (!decomposable || partialAggregationStrategy == FeaturesConfig.PartialAggregationStrategy.NEVER || partialAggregationStrategy == FeaturesConfig.PartialAggregationStrategy.AUTOMATIC && this.partialAggregationNotUseful(aggregationNode, exchangeNode, context) && aggregationNode.getGroupingKeys().size() == 1) {
            return Rule.Result.empty();
        }
        if (exchangeNode.getType() != ExchangeNode.Type.GATHER && exchangeNode.getType() != ExchangeNode.Type.REPARTITION || exchangeNode.getPartitioningScheme().isReplicateNullsAndAny()) {
            return Rule.Result.empty();
        }
        if (exchangeNode.getType() == ExchangeNode.Type.REPARTITION) {
            List partitioningColumns = exchangeNode.getPartitioningScheme().getPartitioning().getArguments().stream().filter(VariableReferenceExpression.class::isInstance).map(VariableReferenceExpression.class::cast).collect(Collectors.toList());
            if (!aggregationNode.getGroupingKeys().containsAll(partitioningColumns)) {
                return Rule.Result.empty();
            }
        }
        if (aggregationNode.getHashVariable().isPresent() || exchangeNode.getPartitioningScheme().getHashColumn().isPresent()) {
            return Rule.Result.empty();
        }
        switch (aggregationNode.getStep()) {
            case SINGLE: {
                return Rule.Result.ofPlanNode(this.split(aggregationNode, context));
            }
            case PARTIAL: {
                return Rule.Result.ofPlanNode(this.pushPartial(aggregationNode, exchangeNode, context));
            }
        }
        return Rule.Result.empty();
    }

    private PlanNode pushPartial(AggregationNode aggregation, ExchangeNode exchange, Rule.Context context) {
        ArrayList<PlanNode> partials = new ArrayList<PlanNode>();
        for (int i = 0; i < exchange.getSources().size(); ++i) {
            PlanNode source = exchange.getSources().get(i);
            SymbolMapper.Builder mappingsBuilder = SymbolMapper.builder();
            for (int outputIndex = 0; outputIndex < exchange.getOutputVariables().size(); ++outputIndex) {
                VariableReferenceExpression input;
                VariableReferenceExpression output = exchange.getOutputVariables().get(outputIndex);
                if (output.equals((Object)(input = exchange.getInputs().get(i).get(outputIndex)))) continue;
                mappingsBuilder.put(output, input);
            }
            SymbolMapper symbolMapper = mappingsBuilder.build();
            AggregationNode mappedPartial = symbolMapper.map(aggregation, source, context.getIdAllocator());
            Assignments.Builder assignments = Assignments.builder();
            for (VariableReferenceExpression output : aggregation.getOutputVariables()) {
                VariableReferenceExpression input = symbolMapper.map(output);
                assignments.put(output, (RowExpression)input);
            }
            partials.add((PlanNode)new ProjectNode(context.getIdAllocator().getNextId(), (PlanNode)mappedPartial, assignments.build(), ProjectNode.Locality.LOCAL));
        }
        for (PlanNode node : partials) {
            Verify.verify((boolean)aggregation.getOutputVariables().equals(node.getOutputVariables()));
        }
        List aggregationOutputs = aggregation.getOutputVariables();
        PartitioningScheme partitioning = new PartitioningScheme(exchange.getPartitioningScheme().getPartitioning(), aggregationOutputs, exchange.getPartitioningScheme().getHashColumn(), exchange.getPartitioningScheme().isReplicateNullsAndAny(), exchange.getPartitioningScheme().getBucketToPartition());
        return new ExchangeNode(context.getIdAllocator().getNextId(), exchange.getType(), exchange.getScope(), partitioning, partials, (List<List<VariableReferenceExpression>>)ImmutableList.copyOf(Collections.nCopies(partials.size(), aggregationOutputs)), exchange.isEnsureSourceOrdering(), Optional.empty());
    }

    private PlanNode split(AggregationNode node, Rule.Context context) {
        HashMap<VariableReferenceExpression, AggregationNode.Aggregation> intermediateAggregation = new HashMap<VariableReferenceExpression, AggregationNode.Aggregation>();
        HashMap finalAggregation = new HashMap();
        for (Map.Entry entry : node.getAggregations().entrySet()) {
            AggregationNode.Aggregation originalAggregation = (AggregationNode.Aggregation)entry.getValue();
            String functionName = this.functionAndTypeManager.getFunctionMetadata(originalAggregation.getFunctionHandle()).getName().getObjectName();
            FunctionHandle functionHandle = originalAggregation.getFunctionHandle();
            InternalAggregationFunction function = this.functionAndTypeManager.getAggregateFunctionImplementation(functionHandle);
            VariableReferenceExpression intermediateVariable = context.getVariableAllocator().newVariable(functionName, function.getIntermediateType());
            Preconditions.checkState((!originalAggregation.getOrderBy().isPresent() ? 1 : 0) != 0, (Object)"Aggregate with ORDER BY does not support partial aggregation");
            intermediateAggregation.put(intermediateVariable, new AggregationNode.Aggregation(new CallExpression(functionName, functionHandle, function.getIntermediateType(), originalAggregation.getArguments()), originalAggregation.getFilter(), originalAggregation.getOrderBy(), originalAggregation.isDistinct(), originalAggregation.getMask()));
            finalAggregation.put(entry.getKey(), new AggregationNode.Aggregation(new CallExpression(functionName, functionHandle, function.getFinalType(), (List)ImmutableList.builder().add((Object)intermediateVariable).addAll((Iterable)originalAggregation.getArguments().stream().filter(PushPartialAggregationThroughExchange::isLambda).collect(ImmutableList.toImmutableList())).build()), Optional.empty(), Optional.empty(), false, Optional.empty()));
        }
        AggregationNode partial = new AggregationNode(context.getIdAllocator().getNextId(), node.getSource(), intermediateAggregation, node.getGroupingSets(), (List)ImmutableList.of(), AggregationNode.Step.PARTIAL, node.getHashVariable(), node.getGroupIdVariable());
        return new AggregationNode(node.getId(), (PlanNode)partial, finalAggregation, node.getGroupingSets(), (List)ImmutableList.of(), AggregationNode.Step.FINAL, node.getHashVariable(), node.getGroupIdVariable());
    }

    private boolean partialAggregationNotUseful(AggregationNode aggregationNode, ExchangeNode exchangeNode, Rule.Context context) {
        StatsProvider stats = context.getStatsProvider();
        PlanNodeStatsEstimate exchangeStats = stats.getStats(exchangeNode);
        PlanNodeStatsEstimate aggregationStats = stats.getStats((PlanNode)aggregationNode);
        double inputBytes = exchangeStats.getOutputSizeInBytes(exchangeNode.getOutputVariables());
        double outputBytes = aggregationStats.getOutputSizeInBytes(aggregationNode.getOutputVariables());
        double byteReductionThreshold = SystemSessionProperties.getPartialAggregationByteReductionThreshold(context.getSession());
        return exchangeStats.isConfident() && outputBytes > inputBytes * byteReductionThreshold;
    }

    private static boolean isLambda(RowExpression rowExpression) {
        return rowExpression instanceof LambdaDefinitionExpression;
    }
}

