/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.OffsetNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class PushLimitThroughOffset
implements Rule<LimitNode> {
    private static final Capture<OffsetNode> CHILD = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().with(Patterns.source().matching(Patterns.offset().capturedAs(CHILD)));

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isOffsetClauseEnabled(session);
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        long count;
        OffsetNode child = (OffsetNode)((Object)captures.get(CHILD));
        try {
            count = Math.addExact(parent.getCount(), child.getCount());
        }
        catch (ArithmeticException e) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(child.replaceChildren((List<PlanNode>)ImmutableList.of((Object)new LimitNode(parent.getId(), child.getSource(), count, parent.getStep()))));
    }
}

