/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.ExceptNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.IntersectNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.RelationId;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.analyzer.SemanticExceptions;
import com.facebook.presto.sql.planner.Coercer;
import com.facebook.presto.sql.planner.ParameterRewriter;
import com.facebook.presto.sql.planner.PlanBuilder;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.QueryPlanner;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.SubqueryPlanner;
import com.facebook.presto.sql.planner.TranslationMap;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.optimizations.JoinNodeUtils;
import com.facebook.presto.sql.planner.optimizations.SampleNodeUtil;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.EnumLiteral;
import com.facebook.presto.sql.tree.Except;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Intersect;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.JoinUsing;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.Lateral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.SetOperation;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.Union;
import com.facebook.presto.sql.tree.Unnest;
import com.facebook.presto.sql.tree.Values;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class RelationPlanner
extends DefaultTraversalVisitor<RelationPlan, Void> {
    private final Analysis analysis;
    private final PlanVariableAllocator variableAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final Map<NodeRef<LambdaArgumentDeclaration>, VariableReferenceExpression> lambdaDeclarationToVariableMap;
    private final Metadata metadata;
    private final Session session;
    private final SubqueryPlanner subqueryPlanner;

    RelationPlanner(Analysis analysis, PlanVariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, Map<NodeRef<LambdaArgumentDeclaration>, VariableReferenceExpression> lambdaDeclarationToVariableMap, Metadata metadata, Session session) {
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(lambdaDeclarationToVariableMap, "lambdaDeclarationToVariableMap is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(session, "session is null");
        this.analysis = analysis;
        this.variableAllocator = variableAllocator;
        this.idAllocator = idAllocator;
        this.lambdaDeclarationToVariableMap = lambdaDeclarationToVariableMap;
        this.metadata = metadata;
        this.session = session;
        this.subqueryPlanner = new SubqueryPlanner(analysis, variableAllocator, idAllocator, lambdaDeclarationToVariableMap, metadata, session);
    }

    protected RelationPlan visitTable(Table node, Void context) {
        Query namedQuery = this.analysis.getNamedQuery(node);
        Scope scope = this.analysis.getScope((Node)node);
        if (namedQuery != null) {
            RelationPlan subPlan = (RelationPlan)this.process((Node)namedQuery, null);
            Type[] types = (Type[])scope.getRelationType().getAllFields().stream().map(Field::getType).toArray(Type[]::new);
            RelationPlan withCoercions = this.addCoercions(subPlan, types);
            return new RelationPlan(withCoercions.getRoot(), scope, withCoercions.getFieldMappings());
        }
        TableHandle handle = this.analysis.getTableHandle(node);
        ImmutableList.Builder outputVariablesBuilder = ImmutableList.builder();
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (Field field : scope.getRelationType().getAllFields()) {
            VariableReferenceExpression variable = this.variableAllocator.newVariable(field.getName().get(), field.getType());
            outputVariablesBuilder.add((Object)variable);
            columns.put((Object)variable, (Object)this.analysis.getColumn(field));
        }
        ImmutableList outputVariables = outputVariablesBuilder.build();
        TableScanNode root = new TableScanNode(this.idAllocator.getNextId(), handle, (List)outputVariables, (Map)columns.build(), TupleDomain.all(), TupleDomain.all());
        return new RelationPlan((PlanNode)root, scope, (List<VariableReferenceExpression>)outputVariables);
    }

    protected RelationPlan visitAliasedRelation(AliasedRelation node, Void context) {
        RelationPlan subPlan = (RelationPlan)this.process((Node)node.getRelation(), context);
        PlanNode root = subPlan.getRoot();
        ImmutableList mappings = subPlan.getFieldMappings();
        if (node.getColumnNames() != null) {
            ImmutableList.Builder newMappings = ImmutableList.builder();
            Assignments.Builder assignments = Assignments.builder();
            for (int i = 0; i < subPlan.getDescriptor().getAllFieldCount(); ++i) {
                Field field = subPlan.getDescriptor().getFieldByIndex(i);
                if (field.isHidden()) continue;
                VariableReferenceExpression aliasedColumn = this.variableAllocator.newVariable(field);
                assignments.put(aliasedColumn, OriginalExpressionUtils.castToRowExpression((Expression)OriginalExpressionUtils.asSymbolReference(subPlan.getFieldMappings().get(i))));
                newMappings.add((Object)aliasedColumn);
            }
            root = new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), assignments.build(), ProjectNode.Locality.LOCAL);
            mappings = newMappings.build();
        }
        return new RelationPlan(root, this.analysis.getScope((Node)node), (List<VariableReferenceExpression>)mappings);
    }

    protected RelationPlan visitSampledRelation(SampledRelation node, Void context) {
        RelationPlan subPlan = (RelationPlan)this.process((Node)node.getRelation(), context);
        double ratio = this.analysis.getSampleRatio(node);
        SampleNode planNode = new SampleNode(this.idAllocator.getNextId(), subPlan.getRoot(), ratio, SampleNodeUtil.fromType(node.getType()));
        return new RelationPlan(planNode, this.analysis.getScope((Node)node), subPlan.getFieldMappings());
    }

    protected RelationPlan visitJoin(Join node, Void context) {
        ArrayList<Expression> postInnerJoinConditions;
        ArrayList<Expression> complexJoinExpressions;
        ImmutableList.Builder equiClauses;
        ImmutableList outputs;
        PlanBuilder rightPlanBuilder;
        PlanBuilder leftPlanBuilder;
        block23: {
            RelationPlan leftPlan = (RelationPlan)this.process((Node)node.getLeft(), context);
            Optional<Unnest> unnest = this.getUnnest(node.getRight());
            if (unnest.isPresent()) {
                if (node.getType() != Join.Type.CROSS && node.getType() != Join.Type.IMPLICIT) {
                    throw SemanticExceptions.notSupportedException((Node)unnest.get(), "UNNEST on other than the right side of CROSS JOIN");
                }
                return this.planCrossJoinUnnest(leftPlan, node, unnest.get());
            }
            Optional<Lateral> lateral = this.getLateral(node.getRight());
            if (lateral.isPresent()) {
                if (node.getType() != Join.Type.CROSS && node.getType() != Join.Type.IMPLICIT) {
                    throw SemanticExceptions.notSupportedException((Node)lateral.get(), "LATERAL on other than the right side of CROSS JOIN");
                }
                return this.planLateralJoin(node, leftPlan, lateral.get());
            }
            RelationPlan rightPlan = (RelationPlan)this.process((Node)node.getRight(), context);
            if (node.getCriteria().isPresent() && node.getCriteria().get() instanceof JoinUsing) {
                return this.planJoinUsing(node, leftPlan, rightPlan);
            }
            leftPlanBuilder = this.initializePlanBuilder(leftPlan);
            rightPlanBuilder = this.initializePlanBuilder(rightPlan);
            outputs = ImmutableList.builder().addAll(leftPlan.getFieldMappings()).addAll(rightPlan.getFieldMappings()).build();
            equiClauses = ImmutableList.builder();
            complexJoinExpressions = new ArrayList<Expression>();
            postInnerJoinConditions = new ArrayList<Expression>();
            if (node.getType() == Join.Type.CROSS || node.getType() == Join.Type.IMPLICIT) break block23;
            Expression criteria = this.analysis.getJoinCriteria(node);
            RelationType left = this.analysis.getOutputDescriptor((Node)node.getLeft());
            RelationType right = this.analysis.getOutputDescriptor((Node)node.getRight());
            ArrayList<Expression> leftComparisonExpressions = new ArrayList<Expression>();
            ArrayList<Expression> rightComparisonExpressions = new ArrayList<Expression>();
            ArrayList<ComparisonExpression.Operator> joinConditionComparisonOperators = new ArrayList<ComparisonExpression.Operator>();
            for (Expression conjunct : ExpressionUtils.extractConjuncts(criteria)) {
                block25: {
                    block24: {
                        if (!ExpressionTreeUtils.isEqualComparisonExpression(conjunct = ExpressionUtils.normalize(conjunct)) && node.getType() != Join.Type.INNER) {
                            complexJoinExpressions.add(conjunct);
                            continue;
                        }
                        Set<QualifiedName> dependencies = VariablesExtractor.extractNames(conjunct, this.analysis.getColumnReferences());
                        if (dependencies.stream().allMatch(left::canResolve)) break block24;
                        if (!dependencies.stream().allMatch(right::canResolve)) break block25;
                    }
                    complexJoinExpressions.add(conjunct);
                    continue;
                }
                if (conjunct instanceof ComparisonExpression) {
                    Expression firstExpression = ((ComparisonExpression)conjunct).getLeft();
                    Expression secondExpression = ((ComparisonExpression)conjunct).getRight();
                    ComparisonExpression.Operator comparisonOperator = ((ComparisonExpression)conjunct).getOperator();
                    Set<QualifiedName> firstDependencies = VariablesExtractor.extractNames(firstExpression, this.analysis.getColumnReferences());
                    Set<QualifiedName> secondDependencies = VariablesExtractor.extractNames(secondExpression, this.analysis.getColumnReferences());
                    if (firstDependencies.stream().allMatch(left::canResolve)) {
                        if (secondDependencies.stream().allMatch(right::canResolve)) {
                            leftComparisonExpressions.add(firstExpression);
                            rightComparisonExpressions.add(secondExpression);
                            this.addNullFilters(complexJoinExpressions, node.getType(), firstExpression, secondExpression);
                            joinConditionComparisonOperators.add(comparisonOperator);
                            continue;
                        }
                    }
                    if (firstDependencies.stream().allMatch(right::canResolve)) {
                        if (secondDependencies.stream().allMatch(left::canResolve)) {
                            leftComparisonExpressions.add(secondExpression);
                            rightComparisonExpressions.add(firstExpression);
                            this.addNullFilters(complexJoinExpressions, node.getType(), secondExpression, firstExpression);
                            joinConditionComparisonOperators.add(comparisonOperator.flip());
                            continue;
                        }
                    }
                    complexJoinExpressions.add(conjunct);
                    continue;
                }
                complexJoinExpressions.add(conjunct);
            }
            leftPlanBuilder = this.subqueryPlanner.handleSubqueries(leftPlanBuilder, leftComparisonExpressions, (Node)node);
            rightPlanBuilder = this.subqueryPlanner.handleSubqueries(rightPlanBuilder, rightComparisonExpressions, (Node)node);
            leftPlanBuilder = leftPlanBuilder.appendProjections(leftComparisonExpressions, this.variableAllocator, this.idAllocator);
            rightPlanBuilder = rightPlanBuilder.appendProjections(rightComparisonExpressions, this.variableAllocator, this.idAllocator);
            for (int i = 0; i < leftComparisonExpressions.size(); ++i) {
                if (joinConditionComparisonOperators.get(i) == ComparisonExpression.Operator.EQUAL) {
                    VariableReferenceExpression leftVariable = leftPlanBuilder.translateToVariable((Expression)leftComparisonExpressions.get(i));
                    VariableReferenceExpression righVariable = rightPlanBuilder.translateToVariable((Expression)rightComparisonExpressions.get(i));
                    equiClauses.add((Object)new JoinNode.EquiJoinClause(leftVariable, righVariable));
                    continue;
                }
                Expression leftExpression = leftPlanBuilder.rewrite((Expression)leftComparisonExpressions.get(i));
                Expression rightExpression = rightPlanBuilder.rewrite((Expression)rightComparisonExpressions.get(i));
                postInnerJoinConditions.add((Expression)new ComparisonExpression((ComparisonExpression.Operator)joinConditionComparisonOperators.get(i), leftExpression, rightExpression));
            }
        }
        JoinNode root = new JoinNode(this.idAllocator.getNextId(), JoinNodeUtils.typeConvert(node.getType()), leftPlanBuilder.getRoot(), rightPlanBuilder.getRoot(), (List<JoinNode.EquiJoinClause>)equiClauses.build(), (List<VariableReferenceExpression>)ImmutableList.builder().addAll((Iterable)leftPlanBuilder.getRoot().getOutputVariables()).addAll((Iterable)rightPlanBuilder.getRoot().getOutputVariables()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, VariableReferenceExpression>)ImmutableMap.of());
        if (node.getType() != Join.Type.INNER) {
            for (Expression complexExpression : complexJoinExpressions) {
                Set<InPredicate> inPredicates = this.subqueryPlanner.collectInPredicateSubqueries(complexExpression, (Node)node);
                if (inPredicates.isEmpty()) continue;
                InPredicate inPredicate = (InPredicate)Iterables.getLast(inPredicates);
                throw SemanticExceptions.notSupportedException((Node)inPredicate, "IN with subquery predicate in join condition");
            }
            leftPlanBuilder = this.subqueryPlanner.handleUncorrelatedSubqueries(leftPlanBuilder, complexJoinExpressions, (Node)node);
        }
        RelationPlan intermediateRootRelationPlan = new RelationPlan(root, this.analysis.getScope((Node)node), (List<VariableReferenceExpression>)outputs);
        TranslationMap translationMap = new TranslationMap(intermediateRootRelationPlan, this.analysis, this.lambdaDeclarationToVariableMap);
        translationMap.setFieldMappings((List<VariableReferenceExpression>)outputs);
        translationMap.putExpressionMappingsFrom(leftPlanBuilder.getTranslations());
        translationMap.putExpressionMappingsFrom(rightPlanBuilder.getTranslations());
        if (node.getType() != Join.Type.INNER && !complexJoinExpressions.isEmpty()) {
            Expression joinedFilterCondition = ExpressionUtils.and(complexJoinExpressions);
            Expression rewrittenFilterCondition = translationMap.rewrite(joinedFilterCondition);
            root = new JoinNode(this.idAllocator.getNextId(), JoinNodeUtils.typeConvert(node.getType()), leftPlanBuilder.getRoot(), rightPlanBuilder.getRoot(), (List<JoinNode.EquiJoinClause>)equiClauses.build(), (List<VariableReferenceExpression>)ImmutableList.builder().addAll((Iterable)leftPlanBuilder.getRoot().getOutputVariables()).addAll((Iterable)rightPlanBuilder.getRoot().getOutputVariables()).build(), Optional.of(OriginalExpressionUtils.castToRowExpression(rewrittenFilterCondition)), Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, VariableReferenceExpression>)ImmutableMap.of());
        }
        if (node.getType() == Join.Type.INNER) {
            PlanBuilder rootPlanBuilder = new PlanBuilder(translationMap, root);
            rootPlanBuilder = this.subqueryPlanner.handleSubqueries(rootPlanBuilder, complexJoinExpressions, (Node)node);
            for (Expression expression : complexJoinExpressions) {
                postInnerJoinConditions.add(rootPlanBuilder.rewrite(expression));
            }
            root = rootPlanBuilder.getRoot();
            if (!postInnerJoinConditions.isEmpty()) {
                Expression postInnerJoinCriteria = ExpressionUtils.and(postInnerJoinConditions);
                root = new FilterNode(this.idAllocator.getNextId(), (PlanNode)root, OriginalExpressionUtils.castToRowExpression(postInnerJoinCriteria));
            }
        }
        return new RelationPlan(root, this.analysis.getScope((Node)node), (List<VariableReferenceExpression>)outputs);
    }

    private void addNullFilters(List<Expression> conditions, Join.Type joinType, Expression left, Expression right) {
        if (SystemSessionProperties.isOptimizeNullsInJoin(this.session)) {
            switch (joinType) {
                case INNER: {
                    this.addNullFilterIfSupported(conditions, left);
                    this.addNullFilterIfSupported(conditions, right);
                    break;
                }
                case LEFT: {
                    this.addNullFilterIfSupported(conditions, right);
                    break;
                }
                case RIGHT: {
                    this.addNullFilterIfSupported(conditions, left);
                }
            }
        }
    }

    private void addNullFilterIfSupported(List<Expression> conditions, Expression incoming) {
        if (!(incoming instanceof InPredicate)) {
            conditions.add((Expression)new IsNotNullPredicate(incoming));
        }
    }

    private RelationPlan planJoinUsing(Join node, RelationPlan left, RelationPlan right) {
        VariableReferenceExpression variable;
        List joinColumns = ((JoinUsing)node.getCriteria().get()).getColumns();
        Analysis.JoinUsingAnalysis joinAnalysis = this.analysis.getJoinUsing(node);
        ImmutableList.Builder clauses = ImmutableList.builder();
        HashMap<Identifier, VariableReferenceExpression> leftJoinColumns = new HashMap<Identifier, VariableReferenceExpression>();
        HashMap<Identifier, VariableReferenceExpression> rightJoinColumns = new HashMap<Identifier, VariableReferenceExpression>();
        Assignments.Builder leftCoercions = Assignments.builder();
        Assignments.Builder rightCoercions = Assignments.builder();
        leftCoercions.putAll(AssignmentUtils.identitiesAsSymbolReferences(left.getRoot().getOutputVariables()));
        rightCoercions.putAll(AssignmentUtils.identitiesAsSymbolReferences(right.getRoot().getOutputVariables()));
        for (int i = 0; i < joinColumns.size(); ++i) {
            Identifier identifier = (Identifier)joinColumns.get(i);
            Type type = this.analysis.getType((Expression)identifier);
            VariableReferenceExpression leftOutput = this.variableAllocator.newVariable((Expression)identifier, type);
            int leftField = joinAnalysis.getLeftJoinFields().get(i);
            leftCoercions.put(leftOutput, OriginalExpressionUtils.castToRowExpression((Expression)new Cast((Expression)new SymbolReference(left.getVariable(leftField).getName()), type.getTypeSignature().toString(), false, this.metadata.getFunctionAndTypeManager().isTypeOnlyCoercion(left.getDescriptor().getFieldByIndex(leftField).getType(), type))));
            leftJoinColumns.put(identifier, leftOutput);
            VariableReferenceExpression rightOutput = this.variableAllocator.newVariable((Expression)identifier, type);
            int rightField = joinAnalysis.getRightJoinFields().get(i);
            rightCoercions.put(rightOutput, OriginalExpressionUtils.castToRowExpression((Expression)new Cast((Expression)new SymbolReference(right.getVariable(rightField).getName()), type.getTypeSignature().toString(), false, this.metadata.getFunctionAndTypeManager().isTypeOnlyCoercion(right.getDescriptor().getFieldByIndex(rightField).getType(), type))));
            rightJoinColumns.put(identifier, rightOutput);
            clauses.add((Object)new JoinNode.EquiJoinClause(leftOutput, rightOutput));
        }
        ProjectNode leftCoercion = new ProjectNode(this.idAllocator.getNextId(), left.getRoot(), leftCoercions.build());
        ProjectNode rightCoercion = new ProjectNode(this.idAllocator.getNextId(), right.getRoot(), rightCoercions.build());
        JoinNode join = new JoinNode(this.idAllocator.getNextId(), JoinNodeUtils.typeConvert(node.getType()), (PlanNode)leftCoercion, (PlanNode)rightCoercion, (List<JoinNode.EquiJoinClause>)clauses.build(), (List<VariableReferenceExpression>)ImmutableList.builder().addAll((Iterable)leftCoercion.getOutputVariables()).addAll((Iterable)rightCoercion.getOutputVariables()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, VariableReferenceExpression>)ImmutableMap.of());
        Assignments.Builder assignments = Assignments.builder();
        ImmutableList.Builder outputs = ImmutableList.builder();
        for (Identifier column : joinColumns) {
            VariableReferenceExpression output = this.variableAllocator.newVariable((Expression)column, this.analysis.getType((Expression)column));
            outputs.add((Object)output);
            assignments.put(output, OriginalExpressionUtils.castToRowExpression((Expression)new CoalesceExpression((Expression)new SymbolReference(((VariableReferenceExpression)leftJoinColumns.get(column)).getName()), (Expression)new SymbolReference(((VariableReferenceExpression)rightJoinColumns.get(column)).getName()), new Expression[0])));
        }
        Iterator<Object> iterator = joinAnalysis.getOtherLeftFields().iterator();
        while (iterator.hasNext()) {
            int field = (Integer)iterator.next();
            variable = left.getFieldMappings().get(field);
            outputs.add((Object)variable);
            assignments.put(variable, OriginalExpressionUtils.castToRowExpression((Expression)new SymbolReference(variable.getName())));
        }
        iterator = joinAnalysis.getOtherRightFields().iterator();
        while (iterator.hasNext()) {
            int field = (Integer)iterator.next();
            variable = right.getFieldMappings().get(field);
            outputs.add((Object)variable);
            assignments.put(variable, OriginalExpressionUtils.castToRowExpression((Expression)new SymbolReference(variable.getName())));
        }
        return new RelationPlan((PlanNode)new ProjectNode(this.idAllocator.getNextId(), (PlanNode)join, assignments.build()), this.analysis.getScope((Node)node), (List<VariableReferenceExpression>)outputs.build());
    }

    private Optional<Unnest> getUnnest(Relation relation) {
        if (relation instanceof AliasedRelation) {
            return this.getUnnest(((AliasedRelation)relation).getRelation());
        }
        if (relation instanceof Unnest) {
            return Optional.of((Unnest)relation);
        }
        return Optional.empty();
    }

    private Optional<Lateral> getLateral(Relation relation) {
        if (relation instanceof AliasedRelation) {
            return this.getLateral(((AliasedRelation)relation).getRelation());
        }
        if (relation instanceof Lateral) {
            return Optional.of((Lateral)relation);
        }
        return Optional.empty();
    }

    private RelationPlan planLateralJoin(Join join, RelationPlan leftPlan, Lateral lateral) {
        RelationPlan rightPlan = (RelationPlan)this.process((Node)lateral.getQuery(), null);
        PlanBuilder leftPlanBuilder = this.initializePlanBuilder(leftPlan);
        PlanBuilder rightPlanBuilder = this.initializePlanBuilder(rightPlan);
        PlanBuilder planBuilder = this.subqueryPlanner.appendLateralJoin(leftPlanBuilder, rightPlanBuilder, lateral.getQuery(), true, LateralJoinNode.Type.INNER);
        ImmutableList outputVariables = ImmutableList.builder().addAll((Iterable)leftPlan.getRoot().getOutputVariables()).addAll((Iterable)rightPlan.getRoot().getOutputVariables()).build();
        return new RelationPlan(planBuilder.getRoot(), this.analysis.getScope((Node)join), (List<VariableReferenceExpression>)outputVariables);
    }

    private RelationPlan planCrossJoinUnnest(RelationPlan leftPlan, Join joinNode, Unnest node) {
        RelationType unnestOutputDescriptor = this.analysis.getOutputDescriptor((Node)node);
        ImmutableList.Builder unnestedVariablesBuilder = ImmutableList.builder();
        for (Field field : unnestOutputDescriptor.getVisibleFields()) {
            VariableReferenceExpression variable = this.variableAllocator.newVariable(field);
            unnestedVariablesBuilder.add((Object)variable);
        }
        ImmutableList unnestedVariables = unnestedVariablesBuilder.build();
        PlanBuilder planBuilder = this.initializePlanBuilder(leftPlan);
        planBuilder = planBuilder.appendProjections(node.getExpressions(), this.variableAllocator, this.idAllocator);
        TranslationMap translations = planBuilder.getTranslations();
        ProjectNode projectNode = (ProjectNode)planBuilder.getRoot();
        ImmutableMap.Builder unnestVariables = ImmutableMap.builder();
        UnmodifiableIterator unnestedVariablesIterator = unnestedVariables.iterator();
        for (Expression expression : node.getExpressions()) {
            Type type = this.analysis.getType(expression);
            VariableReferenceExpression inputVariable = new VariableReferenceExpression(translations.get(expression).getName(), type);
            if (type instanceof ArrayType) {
                Type elementType = ((ArrayType)type).getElementType();
                if (!SystemSessionProperties.isLegacyUnnest(this.session) && elementType instanceof RowType) {
                    ImmutableList.Builder unnestVariableBuilder = ImmutableList.builder();
                    for (int i = 0; i < ((RowType)elementType).getFields().size(); ++i) {
                        unnestVariableBuilder.add(unnestedVariablesIterator.next());
                    }
                    unnestVariables.put((Object)inputVariable, (Object)unnestVariableBuilder.build());
                    continue;
                }
                unnestVariables.put((Object)inputVariable, (Object)ImmutableList.of((Object)unnestedVariablesIterator.next()));
                continue;
            }
            if (type instanceof MapType) {
                unnestVariables.put((Object)inputVariable, (Object)ImmutableList.of((Object)unnestedVariablesIterator.next(), (Object)unnestedVariablesIterator.next()));
                continue;
            }
            throw new IllegalArgumentException("Unsupported type for UNNEST: " + type);
        }
        Optional<VariableReferenceExpression> ordinalityVariable = node.isWithOrdinality() ? Optional.of(unnestedVariablesIterator.next()) : Optional.empty();
        Preconditions.checkState((!unnestedVariablesIterator.hasNext() ? 1 : 0) != 0, (Object)"Not all output variables were matched with input variables");
        UnnestNode unnestNode = new UnnestNode(this.idAllocator.getNextId(), (PlanNode)projectNode, leftPlan.getFieldMappings(), (Map<VariableReferenceExpression, List<VariableReferenceExpression>>)unnestVariables.build(), ordinalityVariable);
        return new RelationPlan(unnestNode, this.analysis.getScope((Node)joinNode), unnestNode.getOutputVariables());
    }

    protected RelationPlan visitTableSubquery(TableSubquery node, Void context) {
        return (RelationPlan)this.process((Node)node.getQuery(), context);
    }

    protected RelationPlan visitQuery(Query node, Void context) {
        return new QueryPlanner(this.analysis, this.variableAllocator, this.idAllocator, this.lambdaDeclarationToVariableMap, this.metadata, this.session).plan(node);
    }

    protected RelationPlan visitQuerySpecification(QuerySpecification node, Void context) {
        return new QueryPlanner(this.analysis, this.variableAllocator, this.idAllocator, this.lambdaDeclarationToVariableMap, this.metadata, this.session).plan(node);
    }

    protected RelationPlan visitValues(Values node, Void context) {
        Scope scope = this.analysis.getScope((Node)node);
        ImmutableList.Builder outputVariablesBuilder = ImmutableList.builder();
        for (Field field : scope.getRelationType().getVisibleFields()) {
            outputVariablesBuilder.add((Object)this.variableAllocator.newVariable(field));
        }
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        for (Expression row : node.getRows()) {
            ImmutableList.Builder values = ImmutableList.builder();
            if (row instanceof Row) {
                for (Expression item : ((Row)row).getItems()) {
                    values.add((Object)this.rewriteRow(item));
                }
            } else {
                values.add((Object)this.rewriteRow(row));
            }
            rowsBuilder.add((Object)values.build());
        }
        ValuesNode valuesNode = new ValuesNode(this.idAllocator.getNextId(), (List)outputVariablesBuilder.build(), (List)rowsBuilder.build());
        return new RelationPlan((PlanNode)valuesNode, scope, (List<VariableReferenceExpression>)outputVariablesBuilder.build());
    }

    private RowExpression rewriteRow(Expression row) {
        Expression expression = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteDereferenceExpression(DereferenceExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Type baseType = RelationPlanner.this.analysis.getType(node.getBase());
                Type nodeType = RelationPlanner.this.analysis.getType((Expression)node);
                if (TypeUtils.isEnumType((Type)baseType) && TypeUtils.isEnumType((Type)nodeType)) {
                    return new EnumLiteral(nodeType.getTypeSignature().toString(), ExpressionTreeUtils.resolveEnumLiteral(node, nodeType));
                }
                return node;
            }
        }, (Expression)row);
        expression = Coercer.addCoercions(expression, this.analysis);
        expression = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(this.analysis.getParameters(), this.analysis), (Expression)expression);
        return OriginalExpressionUtils.castToRowExpression(expression);
    }

    protected RelationPlan visitUnnest(Unnest node, Void context) {
        Scope scope = this.analysis.getScope((Node)node);
        ImmutableList.Builder outputVariablesBuilder = ImmutableList.builder();
        for (Field field : scope.getRelationType().getVisibleFields()) {
            VariableReferenceExpression variable = this.variableAllocator.newVariable(field);
            outputVariablesBuilder.add((Object)variable);
        }
        ImmutableList unnestedVariables = outputVariablesBuilder.build();
        ImmutableList.Builder argumentVariables = ImmutableList.builder();
        ImmutableList.Builder values = ImmutableList.builder();
        ImmutableMap.Builder unnestVariables = ImmutableMap.builder();
        Iterator unnestedVariablesIterator = unnestedVariables.iterator();
        for (Expression expression : node.getExpressions()) {
            Type type = this.analysis.getType(expression);
            Expression rewritten = Coercer.addCoercions(expression, this.analysis);
            rewritten = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(this.analysis.getParameters(), this.analysis), (Expression)rewritten);
            values.add((Object)OriginalExpressionUtils.castToRowExpression(rewritten));
            VariableReferenceExpression input = this.variableAllocator.newVariable(rewritten, type);
            argumentVariables.add((Object)new VariableReferenceExpression(input.getName(), type));
            if (type instanceof ArrayType) {
                Type elementType = ((ArrayType)type).getElementType();
                if (!SystemSessionProperties.isLegacyUnnest(this.session) && elementType instanceof RowType) {
                    ImmutableList.Builder unnestVariableBuilder = ImmutableList.builder();
                    for (int i = 0; i < ((RowType)elementType).getFields().size(); ++i) {
                        unnestVariableBuilder.add(unnestedVariablesIterator.next());
                    }
                    unnestVariables.put((Object)input, (Object)unnestVariableBuilder.build());
                    continue;
                }
                unnestVariables.put((Object)input, (Object)ImmutableList.of(unnestedVariablesIterator.next()));
                continue;
            }
            if (type instanceof MapType) {
                unnestVariables.put((Object)input, (Object)ImmutableList.of(unnestedVariablesIterator.next(), unnestedVariablesIterator.next()));
                continue;
            }
            throw new IllegalArgumentException("Unsupported type for UNNEST: " + type);
        }
        Optional<VariableReferenceExpression> ordinalityVariable = node.isWithOrdinality() ? Optional.of(unnestedVariablesIterator.next()) : Optional.empty();
        Preconditions.checkState((!unnestedVariablesIterator.hasNext() ? 1 : 0) != 0, (Object)"Not all output variables were matched with input variables");
        ValuesNode valuesNode = new ValuesNode(this.idAllocator.getNextId(), (List)argumentVariables.build(), (List)ImmutableList.of((Object)values.build()));
        UnnestNode unnestNode = new UnnestNode(this.idAllocator.getNextId(), (PlanNode)valuesNode, (List<VariableReferenceExpression>)ImmutableList.of(), (Map<VariableReferenceExpression, List<VariableReferenceExpression>>)unnestVariables.build(), ordinalityVariable);
        return new RelationPlan(unnestNode, scope, (List<VariableReferenceExpression>)unnestedVariables);
    }

    private RelationPlan processAndCoerceIfNecessary(Relation node, Void context) {
        Type[] coerceToTypes = this.analysis.getRelationCoercion(node);
        RelationPlan plan = (RelationPlan)this.process((Node)node, context);
        if (coerceToTypes == null) {
            return plan;
        }
        return this.addCoercions(plan, coerceToTypes);
    }

    private RelationPlan addCoercions(RelationPlan plan, Type[] targetColumnTypes) {
        RelationType oldRelation = plan.getDescriptor();
        List oldVisibleVariables = (List)oldRelation.getVisibleFields().stream().map(oldRelation::indexOf).map(plan.getFieldMappings()::get).collect(ImmutableList.toImmutableList());
        RelationType oldRelationWithVisibleFields = plan.getDescriptor().withOnlyVisibleFields();
        Verify.verify((targetColumnTypes.length == oldVisibleVariables.size() ? 1 : 0) != 0);
        ImmutableList.Builder newVariables = new ImmutableList.Builder();
        Field[] newFields = new Field[targetColumnTypes.length];
        Assignments.Builder assignments = Assignments.builder();
        for (int i = 0; i < targetColumnTypes.length; ++i) {
            VariableReferenceExpression outputVariable;
            Type outputType = targetColumnTypes[i];
            VariableReferenceExpression inputVariable = (VariableReferenceExpression)oldVisibleVariables.get(i);
            if (!outputType.equals(inputVariable.getType())) {
                Cast cast = new Cast((Expression)new SymbolReference(inputVariable.getName()), outputType.getTypeSignature().toString());
                outputVariable = this.variableAllocator.newVariable((Expression)cast, outputType);
                assignments.put(outputVariable, OriginalExpressionUtils.castToRowExpression((Expression)cast));
                newVariables.add((Object)outputVariable);
            } else {
                SymbolReference symbolReference = new SymbolReference(inputVariable.getName());
                outputVariable = this.variableAllocator.newVariable((Expression)symbolReference, outputType);
                assignments.put(outputVariable, OriginalExpressionUtils.castToRowExpression((Expression)symbolReference));
                newVariables.add((Object)outputVariable);
            }
            Field oldField = oldRelationWithVisibleFields.getFieldByIndex(i);
            newFields[i] = new Field(oldField.getRelationAlias(), oldField.getName(), targetColumnTypes[i], oldField.isHidden(), oldField.getOriginTable(), oldField.getOriginColumnName(), oldField.isAliased());
        }
        ProjectNode projectNode = new ProjectNode(this.idAllocator.getNextId(), plan.getRoot(), assignments.build());
        return new RelationPlan((PlanNode)projectNode, Scope.builder().withRelationType(RelationId.anonymous(), new RelationType(newFields)).build(), (List<VariableReferenceExpression>)newVariables.build());
    }

    protected RelationPlan visitUnion(Union node, Void context) {
        Preconditions.checkArgument((!node.getRelations().isEmpty() ? 1 : 0) != 0, (Object)"No relations specified for UNION");
        SetOperationPlan setOperationPlan = this.process((SetOperation)node);
        UnionNode planNode = new UnionNode(this.idAllocator.getNextId(), setOperationPlan.getSources(), setOperationPlan.getOutputVariables(), setOperationPlan.getVariableMapping());
        if (node.isDistinct().orElse(true).booleanValue()) {
            planNode = this.distinct((PlanNode)planNode);
        }
        return new RelationPlan((PlanNode)planNode, this.analysis.getScope((Node)node), planNode.getOutputVariables());
    }

    protected RelationPlan visitIntersect(Intersect node, Void context) {
        Preconditions.checkArgument((!node.getRelations().isEmpty() ? 1 : 0) != 0, (Object)"No relations specified for INTERSECT");
        SetOperationPlan setOperationPlan = this.process((SetOperation)node);
        IntersectNode planNode = new IntersectNode(this.idAllocator.getNextId(), setOperationPlan.getSources(), setOperationPlan.getOutputVariables(), setOperationPlan.getVariableMapping());
        return new RelationPlan((PlanNode)planNode, this.analysis.getScope((Node)node), planNode.getOutputVariables());
    }

    protected RelationPlan visitExcept(Except node, Void context) {
        Preconditions.checkArgument((!node.getRelations().isEmpty() ? 1 : 0) != 0, (Object)"No relations specified for EXCEPT");
        SetOperationPlan setOperationPlan = this.process((SetOperation)node);
        ExceptNode planNode = new ExceptNode(this.idAllocator.getNextId(), setOperationPlan.getSources(), setOperationPlan.getOutputVariables(), setOperationPlan.getVariableMapping());
        return new RelationPlan((PlanNode)planNode, this.analysis.getScope((Node)node), planNode.getOutputVariables());
    }

    private SetOperationPlan process(SetOperation node) {
        List outputs = null;
        ImmutableList.Builder sources = ImmutableList.builder();
        ImmutableListMultimap.Builder variableMapping = ImmutableListMultimap.builder();
        List subPlans = (List)node.getRelations().stream().map(relation -> this.processAndCoerceIfNecessary((Relation)relation, null)).collect(ImmutableList.toImmutableList());
        for (RelationPlan relationPlan : subPlans) {
            int fieldIndex;
            RelationType descriptor;
            List<VariableReferenceExpression> childOutputVariables = relationPlan.getFieldMappings();
            if (outputs == null) {
                descriptor = relationPlan.getDescriptor();
                ImmutableList.Builder outputVariableBuilder = ImmutableList.builder();
                for (Field field : descriptor.getVisibleFields()) {
                    fieldIndex = descriptor.indexOf(field);
                    VariableReferenceExpression variable = childOutputVariables.get(fieldIndex);
                    outputVariableBuilder.add((Object)this.variableAllocator.newVariable(variable));
                }
                outputs = outputVariableBuilder.build();
            }
            Preconditions.checkArgument(((descriptor = relationPlan.getDescriptor()).getVisibleFieldCount() == outputs.size() ? 1 : 0) != 0, (String)"Expected relation to have %s variables but has %s variables", (int)descriptor.getVisibleFieldCount(), (int)outputs.size());
            int fieldId = 0;
            for (Field field : descriptor.getVisibleFields()) {
                fieldIndex = descriptor.indexOf(field);
                variableMapping.put(outputs.get(fieldId), (Object)childOutputVariables.get(fieldIndex));
                ++fieldId;
            }
            sources.add((Object)relationPlan.getRoot());
        }
        return new SetOperationPlan((List)sources.build(), (ListMultimap)variableMapping.build());
    }

    private PlanBuilder initializePlanBuilder(RelationPlan relationPlan) {
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis, this.lambdaDeclarationToVariableMap);
        translations.setFieldMappings(relationPlan.getFieldMappings());
        return new PlanBuilder(translations, relationPlan.getRoot());
    }

    private PlanNode distinct(PlanNode node) {
        return new AggregationNode(this.idAllocator.getNextId(), node, (Map)ImmutableMap.of(), AggregationNode.singleGroupingSet((List)node.getOutputVariables()), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty());
    }

    private static class SetOperationPlan {
        private final List<PlanNode> sources;
        private final List<VariableReferenceExpression> outputVariables;
        private final Map<VariableReferenceExpression, List<VariableReferenceExpression>> variableMapping;

        private SetOperationPlan(List<PlanNode> sources, ListMultimap<VariableReferenceExpression, VariableReferenceExpression> variableMapping) {
            this.sources = sources;
            this.outputVariables = ImmutableList.copyOf((Collection)variableMapping.keySet());
            LinkedHashMap<VariableReferenceExpression, List<VariableReferenceExpression>> mapping = new LinkedHashMap<VariableReferenceExpression, List<VariableReferenceExpression>>();
            variableMapping.asMap().forEach((key, value) -> {
                Preconditions.checkState((boolean)(value instanceof List), (Object)"variableMapping values should be of type List");
                mapping.put((VariableReferenceExpression)key, (List)value);
            });
            this.variableMapping = mapping;
        }

        public List<PlanNode> getSources() {
            return this.sources;
        }

        public List<VariableReferenceExpression> getOutputVariables() {
            return this.outputVariables;
        }

        public Map<VariableReferenceExpression, List<VariableReferenceExpression>> getVariableMapping() {
            return this.variableMapping;
        }
    }
}

