/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.control.WhileLoop;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.JumpInstruction;
import com.facebook.presto.bytecode.instruction.LabelNode;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.project.CursorProcessorOutput;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.gen.BodyCompiler;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CachedInstanceBinder;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CommonSubExpressionRewriter;
import com.facebook.presto.sql.gen.LambdaBytecodeGenerator;
import com.facebook.presto.sql.gen.RowExpressionCompiler;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CursorProcessorCompiler
implements BodyCompiler {
    private static Logger log = Logger.get(CursorProcessorCompiler.class);
    private final Metadata metadata;
    private final boolean isOptimizeCommonSubExpressions;
    private final Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions;

    public CursorProcessorCompiler(Metadata metadata, boolean isOptimizeCommonSubExpressions, Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions) {
        this.metadata = metadata;
        this.isOptimizeCommonSubExpressions = isOptimizeCommonSubExpressions;
        this.sessionFunctions = sessionFunctions;
    }

    @Override
    public void generateMethods(SqlFunctionProperties sqlFunctionProperties, ClassDefinition classDefinition, CallSiteBinder callSiteBinder, RowExpression filter, List<RowExpression> projections) {
        Map<Integer, Map<RowExpression, VariableReferenceExpression>> commonSubExpressionsByLevel;
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(classDefinition, callSiteBinder);
        ImmutableList rowExpressions = ImmutableList.builder().addAll(projections).add((Object)filter).build();
        Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap = LambdaBytecodeGenerator.generateMethodsForLambda(classDefinition, callSiteBinder, cachedInstanceBinder, (List<RowExpression>)rowExpressions, this.metadata, sqlFunctionProperties, this.sessionFunctions, "");
        Object cseFields = ImmutableMap.of();
        RowExpressionCompiler compiler = new RowExpressionCompiler(classDefinition, callSiteBinder, cachedInstanceBinder, CursorProcessorCompiler.fieldReferenceCompiler((Map<VariableReferenceExpression, CommonSubExpressionRewriter.CommonSubExpressionFields>)cseFields), this.metadata, sqlFunctionProperties, this.sessionFunctions, compiledLambdaMap);
        if (this.isOptimizeCommonSubExpressions && !(commonSubExpressionsByLevel = CommonSubExpressionRewriter.collectCSEByLevel((List<? extends RowExpression>)rowExpressions)).isEmpty()) {
            cseFields = CommonSubExpressionRewriter.CommonSubExpressionFields.declareCommonSubExpressionFields(classDefinition, commonSubExpressionsByLevel);
            compiler = new RowExpressionCompiler(classDefinition, callSiteBinder, cachedInstanceBinder, CursorProcessorCompiler.fieldReferenceCompiler((Map<VariableReferenceExpression, CommonSubExpressionRewriter.CommonSubExpressionFields>)cseFields), this.metadata, sqlFunctionProperties, this.sessionFunctions, compiledLambdaMap);
            this.generateCommonSubExpressionMethods(classDefinition, compiler, commonSubExpressionsByLevel, (Map<VariableReferenceExpression, CommonSubExpressionRewriter.CommonSubExpressionFields>)cseFields);
            Map commonSubExpressions = (Map)commonSubExpressionsByLevel.values().stream().flatMap(m -> m.entrySet().stream()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            projections = this.rewriteRowExpressionsWithCSE(projections, commonSubExpressions);
            filter = this.rewriteRowExpressionsWithCSE((List<RowExpression>)ImmutableList.of((Object)filter), commonSubExpressions).get(0);
        }
        CursorProcessorCompiler.generateProcessMethod(classDefinition, projections.size(), (Map<VariableReferenceExpression, CommonSubExpressionRewriter.CommonSubExpressionFields>)cseFields);
        this.generateFilterMethod(classDefinition, compiler, filter);
        for (int i = 0; i < projections.size(); ++i) {
            String methodName = "project_" + i;
            this.generateProjectMethod(classDefinition, compiler, methodName, projections.get(i));
        }
        MethodDefinition constructorDefinition = classDefinition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        BytecodeBlock constructorBody = constructorDefinition.getBody();
        Variable thisVariable = constructorDefinition.getThis();
        constructorBody.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        CommonSubExpressionRewriter.CommonSubExpressionFields.initializeCommonSubExpressionFields(cseFields.values(), thisVariable, constructorBody);
        cachedInstanceBinder.generateInitializations(thisVariable, constructorBody);
        constructorBody.ret();
    }

    List<RowExpression> rewriteRowExpressionsWithCSE(List<RowExpression> rows, Map<RowExpression, VariableReferenceExpression> commonSubExpressions) {
        if (!commonSubExpressions.isEmpty()) {
            rows = (List)rows.stream().map(p -> CommonSubExpressionRewriter.rewriteExpressionWithCSE(p, commonSubExpressions)).collect(ImmutableList.toImmutableList());
            if (log.isDebugEnabled()) {
                log.debug("Extracted %d common sub-expressions", new Object[]{commonSubExpressions.size()});
                commonSubExpressions.entrySet().forEach(entry -> log.debug("\t%s = %s", new Object[]{entry.getValue(), entry.getKey()}));
                log.debug("Rewrote Rows: %s", new Object[]{rows});
            }
        }
        return rows;
    }

    private static void generateProcessMethod(ClassDefinition classDefinition, int projections, Map<VariableReferenceExpression, CommonSubExpressionRewriter.CommonSubExpressionFields> cseFields) {
        Parameter properties = Parameter.arg((String)"properties", SqlFunctionProperties.class);
        Parameter yieldSignal = Parameter.arg((String)"yieldSignal", DriverYieldSignal.class);
        Parameter cursor = Parameter.arg((String)"cursor", RecordCursor.class);
        Parameter pageBuilder = Parameter.arg((String)"pageBuilder", PageBuilder.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "process", ParameterizedType.type(CursorProcessorOutput.class), new Parameter[]{properties, yieldSignal, cursor, pageBuilder});
        Scope scope = method.getScope();
        Variable completedPositionsVariable = scope.declareVariable(Integer.TYPE, "completedPositions");
        Variable finishedVariable = scope.declareVariable(Boolean.TYPE, "finished");
        method.getBody().comment("int completedPositions = 0;").putVariable(completedPositionsVariable, 0).comment("boolean finished = false;").putVariable(finishedVariable, false);
        LabelNode done = new LabelNode("done");
        BytecodeBlock whileFunctionBlock = new BytecodeBlock().comment("if (pageBuilder.isFull() || yieldSignal.isSet()) return new CursorProcessorOutput(completedPositions, false);").append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.or((BytecodeExpression)pageBuilder.invoke("isFull", Boolean.TYPE, new BytecodeExpression[0]), (BytecodeExpression)yieldSignal.invoke("isSet", Boolean.TYPE, new BytecodeExpression[0]))).ifTrue((BytecodeNode)JumpInstruction.jump((LabelNode)done))).comment("if (!cursor.advanceNextPosition()) return new CursorProcessorOutput(completedPositions, true);").append((BytecodeNode)new IfStatement().condition((BytecodeNode)cursor.invoke("advanceNextPosition", Boolean.TYPE, new BytecodeExpression[0])).ifFalse((BytecodeNode)new BytecodeBlock().putVariable(finishedVariable, true).gotoLabel(done)));
        cseFields.values().forEach(field -> whileFunctionBlock.append((BytecodeNode)scope.getThis().setField(field.getEvaluatedField(), BytecodeExpressions.constantBoolean((boolean)false))));
        whileFunctionBlock.comment("do the projection").append((BytecodeNode)CursorProcessorCompiler.createProjectIfStatement(classDefinition, method, properties, cursor, pageBuilder, projections)).comment("completedPositions++;").incrementVariable(completedPositionsVariable, (byte)1);
        WhileLoop whileLoop = new WhileLoop().condition((BytecodeNode)BytecodeExpressions.constantTrue()).body((BytecodeNode)whileFunctionBlock);
        method.getBody().append((BytecodeNode)whileLoop).visitLabel(done).append((BytecodeNode)BytecodeExpressions.newInstance(CursorProcessorOutput.class, (BytecodeExpression[])new BytecodeExpression[]{completedPositionsVariable, finishedVariable}).ret());
    }

    private static IfStatement createProjectIfStatement(ClassDefinition classDefinition, MethodDefinition method, Parameter properties, Parameter cursor, Parameter pageBuilder, int projections) {
        IfStatement ifStatement = new IfStatement();
        ifStatement.condition().append((BytecodeNode)method.getThis()).getVariable((Variable)properties).getVariable((Variable)cursor).invokeVirtual(classDefinition.getType(), "filter", ParameterizedType.type(Boolean.TYPE), new ParameterizedType[]{ParameterizedType.type(SqlFunctionProperties.class), ParameterizedType.type(RecordCursor.class)});
        ifStatement.ifTrue().getVariable((Variable)pageBuilder).invokeVirtual(PageBuilder.class, "declarePosition", Void.TYPE, new Class[0]);
        for (int projectionIndex = 0; projectionIndex < projections; ++projectionIndex) {
            ifStatement.ifTrue().append((BytecodeNode)method.getThis()).getVariable((Variable)properties).getVariable((Variable)cursor);
            ifStatement.ifTrue().getVariable((Variable)pageBuilder).push(projectionIndex).invokeVirtual(PageBuilder.class, "getBlockBuilder", BlockBuilder.class, new Class[]{Integer.TYPE});
            ifStatement.ifTrue().invokeVirtual(classDefinition.getType(), "project_" + projectionIndex, ParameterizedType.type(Void.TYPE), new ParameterizedType[]{ParameterizedType.type(SqlFunctionProperties.class), ParameterizedType.type(RecordCursor.class), ParameterizedType.type(BlockBuilder.class)});
        }
        return ifStatement;
    }

    private void generateFilterMethod(ClassDefinition classDefinition, RowExpressionCompiler compiler, RowExpression filter) {
        Parameter properties = Parameter.arg((String)"properties", SqlFunctionProperties.class);
        Parameter cursor = Parameter.arg((String)"cursor", RecordCursor.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "filter", ParameterizedType.type(Boolean.TYPE), new Parameter[]{properties, cursor});
        method.comment("Filter: %s", new Object[]{filter});
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable wasNullVariable = scope.declareVariable(ParameterizedType.type(Boolean.TYPE), "wasNull");
        LabelNode end = new LabelNode("end");
        body.comment("boolean wasNull = false;").putVariable(wasNullVariable, false).comment("evaluate filter: " + filter).append(compiler.compile(filter, scope, Optional.empty())).comment("if (wasNull) return false;").getVariable(wasNullVariable).ifFalseGoto(end).pop(Boolean.TYPE).push(false).visitLabel(end).retBoolean();
    }

    private void generateProjectMethod(ClassDefinition classDefinition, RowExpressionCompiler compiler, String methodName, RowExpression projection) {
        Parameter properties = Parameter.arg((String)"properties", SqlFunctionProperties.class);
        Parameter cursor = Parameter.arg((String)"cursor", RecordCursor.class);
        Parameter output = Parameter.arg((String)"output", BlockBuilder.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), methodName, ParameterizedType.type(Void.TYPE), new Parameter[]{properties, cursor, output});
        method.comment("Projection: %s", new Object[]{projection.toString()});
        Scope scope = method.getScope();
        Variable wasNullVariable = scope.declareVariable(ParameterizedType.type(Boolean.TYPE), "wasNull");
        method.getBody().comment("boolean wasNull = false;").putVariable(wasNullVariable, false).comment("evaluate projection: " + projection.toString()).append(compiler.compile(projection, scope, Optional.of(output))).ret();
    }

    private List<MethodDefinition> generateCommonSubExpressionMethods(ClassDefinition classDefinition, RowExpressionCompiler compiler, Map<Integer, Map<RowExpression, VariableReferenceExpression>> commonSubExpressionsByLevel, Map<VariableReferenceExpression, CommonSubExpressionRewriter.CommonSubExpressionFields> commonSubExpressionFieldsMap) {
        Parameter properties = Parameter.arg((String)"properties", SqlFunctionProperties.class);
        Parameter cursor = Parameter.arg((String)"cursor", RecordCursor.class);
        ImmutableList.Builder methods = ImmutableList.builder();
        HashMap<VariableReferenceExpression, CommonSubExpressionRewriter.CommonSubExpressionFields> cseMap = new HashMap<VariableReferenceExpression, CommonSubExpressionRewriter.CommonSubExpressionFields>();
        int startLevel = (Integer)commonSubExpressionsByLevel.keySet().stream().reduce(Math::min).get();
        int maxLevel = (Integer)commonSubExpressionsByLevel.keySet().stream().reduce(Math::max).get();
        for (int i = startLevel; i <= maxLevel; ++i) {
            if (!commonSubExpressionsByLevel.containsKey(i)) continue;
            for (Map.Entry<RowExpression, VariableReferenceExpression> entry : commonSubExpressionsByLevel.get(i).entrySet()) {
                RowExpression cse = entry.getKey();
                Class type = Primitives.wrap((Class)cse.getType().getJavaType());
                VariableReferenceExpression cseVariable = entry.getValue();
                CommonSubExpressionRewriter.CommonSubExpressionFields cseFields = commonSubExpressionFieldsMap.get(cseVariable);
                MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PRIVATE}), "get" + cseVariable.getName(), ParameterizedType.type(cseFields.getResultType()), new Parameter[]{properties, cursor});
                method.comment("cse: %s", new Object[]{cse});
                Scope scope = method.getScope();
                BytecodeBlock body = method.getBody();
                Variable thisVariable = method.getThis();
                scope.declareVariable("wasNull", body, BytecodeExpressions.constantFalse());
                IfStatement ifStatement = new IfStatement().condition((BytecodeNode)thisVariable.getField(cseFields.getEvaluatedField())).ifFalse((BytecodeNode)new BytecodeBlock().append((BytecodeNode)thisVariable).append(compiler.compile(cse, scope, Optional.empty())).append(BytecodeUtils.boxPrimitiveIfNecessary(scope, type)).putField(cseFields.getResultField()).append((BytecodeNode)thisVariable.setField(cseFields.getEvaluatedField(), BytecodeExpressions.constantBoolean((boolean)true))));
                body.append((BytecodeNode)ifStatement).append((BytecodeNode)thisVariable).getField(cseFields.getResultField()).retObject();
                methods.add((Object)method);
                cseMap.put(cseVariable, cseFields);
            }
        }
        return methods.build();
    }

    static RowExpressionVisitor<BytecodeNode, Scope> fieldReferenceCompiler(final Map<VariableReferenceExpression, CommonSubExpressionRewriter.CommonSubExpressionFields> variableMap) {
        return new RowExpressionVisitor<BytecodeNode, Scope>(){

            public BytecodeNode visitInputReference(InputReferenceExpression node, Scope scope) {
                int field = node.getField();
                Type type = node.getType();
                Variable wasNullVariable = scope.getVariable("wasNull");
                Variable cursorVariable = scope.getVariable("cursor");
                Class<Object> javaType = type.getJavaType();
                if (!javaType.isPrimitive() && javaType != Slice.class) {
                    javaType = Object.class;
                }
                IfStatement ifStatement = new IfStatement();
                ifStatement.condition().setDescription(String.format("cursor.get%s(%d)", type, field)).getVariable(cursorVariable).push(field).invokeInterface(RecordCursor.class, "isNull", Boolean.TYPE, new Class[]{Integer.TYPE});
                ifStatement.ifTrue().putVariable(wasNullVariable, true).pushJavaDefault(javaType);
                ifStatement.ifFalse().getVariable(cursorVariable).push(field).invokeInterface(RecordCursor.class, "get" + Primitives.wrap(javaType).getSimpleName(), javaType, new Class[]{Integer.TYPE});
                return ifStatement;
            }

            public BytecodeNode visitCall(CallExpression call, Scope scope) {
                throw new UnsupportedOperationException("not yet implemented");
            }

            public BytecodeNode visitConstant(ConstantExpression literal, Scope scope) {
                throw new UnsupportedOperationException("not yet implemented");
            }

            public BytecodeNode visitLambda(LambdaDefinitionExpression lambda, Scope context) {
                throw new UnsupportedOperationException();
            }

            public BytecodeNode visitVariableReference(VariableReferenceExpression reference, Scope context) {
                CommonSubExpressionRewriter.CommonSubExpressionFields fields = (CommonSubExpressionRewriter.CommonSubExpressionFields)variableMap.get(reference);
                return new BytecodeBlock().append((BytecodeNode)context.getThis().invoke(fields.getMethodName(), fields.getResultType(), new BytecodeExpression[]{context.getVariable("properties"), context.getVariable("cursor")})).append((BytecodeNode)BytecodeUtils.unboxPrimitiveIfNecessary(context, Primitives.wrap((Class)reference.getType().getJavaType())));
            }

            public BytecodeNode visitSpecialForm(SpecialFormExpression specialForm, Scope context) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

