/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.ForLoop;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.VariableInstruction;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockBuilderStatus;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.SqlTypeBytecodeExpression;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

public class ArrayMapBytecodeExpression
extends BytecodeExpression {
    private static final AtomicLong NEXT_VARIABLE_ID = new AtomicLong();
    private final BytecodeBlock body = new BytecodeBlock();
    private final String oneLineDescription;

    public ArrayMapBytecodeExpression(Scope scope, CallSiteBinder binder, BytecodeExpression array, Type fromType, Type toType, Function<BytecodeExpression, BytecodeExpression> mapper) {
        super(ParameterizedType.type(Block.class));
        String mapperDescription;
        BytecodeBlock mapElement;
        Variable blockBuilder = scope.declareVariable(BlockBuilder.class, "blockBuilder_" + NEXT_VARIABLE_ID.getAndIncrement());
        this.body.append((BytecodeNode)blockBuilder.set(SqlTypeBytecodeExpression.constantType(binder, toType).invoke("createBlockBuilder", BlockBuilder.class, new BytecodeExpression[]{BytecodeExpressions.constantNull(BlockBuilderStatus.class), array.invoke("getPositionCount", Integer.TYPE, new BytecodeExpression[0])})));
        Variable position = scope.declareVariable(Integer.TYPE, "position_" + NEXT_VARIABLE_ID.getAndIncrement());
        if (fromType instanceof UnknownType) {
            mapElement = new BytecodeBlock().comment("unreachable code");
            mapperDescription = "null";
        } else {
            Variable element = scope.declareVariable(fromType.getJavaType(), "element_" + NEXT_VARIABLE_ID.getAndIncrement());
            Variable newElement = scope.declareVariable(toType.getJavaType(), "newElement_" + NEXT_VARIABLE_ID.getAndIncrement());
            SqlTypeBytecodeExpression elementTypeConstant = SqlTypeBytecodeExpression.constantType(binder, fromType);
            SqlTypeBytecodeExpression newElementTypeConstant = SqlTypeBytecodeExpression.constantType(binder, toType);
            mapElement = new BytecodeBlock().append((BytecodeNode)element.set(elementTypeConstant.getValue(array, (BytecodeExpression)position))).append((BytecodeNode)newElement.set(mapper.apply((BytecodeExpression)element))).append((BytecodeNode)newElementTypeConstant.writeValue((BytecodeExpression)blockBuilder, (BytecodeExpression)newElement));
            mapperDescription = mapper.apply((BytecodeExpression)element).toString();
        }
        this.body.append((BytecodeNode)new ForLoop().initialize((BytecodeNode)position.set(BytecodeExpressions.constantInt((int)0))).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)position, (BytecodeExpression)array.invoke("getPositionCount", Integer.TYPE, new BytecodeExpression[0]))).update((BytecodeNode)VariableInstruction.incrementVariable((Variable)position, (byte)1)).body((BytecodeNode)new IfStatement().condition((BytecodeNode)array.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{position})).ifTrue((BytecodeNode)blockBuilder.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop()).ifFalse((BytecodeNode)mapElement)));
        this.body.append((BytecodeNode)blockBuilder.invoke("build", Block.class, new BytecodeExpression[0]));
        this.oneLineDescription = "arrayMap(" + array + ", element -> " + mapperDescription + ")";
    }

    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        return this.body;
    }

    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    protected String formatOneLine() {
        return this.oneLineDescription;
    }
}

