/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.security.AllowAllAccessControl;
import com.facebook.presto.security.ViewAccessControl;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorMaterializedViewDefinition;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.MaterializedViewStatus;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.StandardWarningCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCodeSupplier;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunction;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.sql.NodeUtils;
import com.facebook.presto.sql.ParsingUtil;
import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.SqlFormatterUtil;
import com.facebook.presto.sql.analyzer.AggregationAnalyzer;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.ExpressionAnalysis;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.FieldId;
import com.facebook.presto.sql.analyzer.MaterializedViewPlanValidator;
import com.facebook.presto.sql.analyzer.PredicateStitcher;
import com.facebook.presto.sql.analyzer.RefreshMaterializedViewPredicateAnalyzer;
import com.facebook.presto.sql.analyzer.RelationId;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.ResolvedField;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.analyzer.ScopeReferenceExtractor;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.analyzer.WindowFunctionValidator;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.ExpressionDeterminismEvaluator;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.tree.AddColumn;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.AlterFunction;
import com.facebook.presto.sql.tree.Analyze;
import com.facebook.presto.sql.tree.Call;
import com.facebook.presto.sql.tree.Commit;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CreateFunction;
import com.facebook.presto.sql.tree.CreateMaterializedView;
import com.facebook.presto.sql.tree.CreateSchema;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateTableAsSelect;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.Cube;
import com.facebook.presto.sql.tree.Deallocate;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Delete;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.DropColumn;
import com.facebook.presto.sql.tree.DropFunction;
import com.facebook.presto.sql.tree.DropMaterializedView;
import com.facebook.presto.sql.tree.DropSchema;
import com.facebook.presto.sql.tree.DropTable;
import com.facebook.presto.sql.tree.DropView;
import com.facebook.presto.sql.tree.Except;
import com.facebook.presto.sql.tree.Execute;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Grant;
import com.facebook.presto.sql.tree.GroupBy;
import com.facebook.presto.sql.tree.GroupingElement;
import com.facebook.presto.sql.tree.GroupingOperation;
import com.facebook.presto.sql.tree.GroupingSets;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.Intersect;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.JoinCriteria;
import com.facebook.presto.sql.tree.JoinOn;
import com.facebook.presto.sql.tree.JoinUsing;
import com.facebook.presto.sql.tree.Lateral;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NaturalJoin;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.Offset;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.Prepare;
import com.facebook.presto.sql.tree.Property;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QueryBody;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.RefreshMaterializedView;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.RenameColumn;
import com.facebook.presto.sql.tree.RenameSchema;
import com.facebook.presto.sql.tree.RenameTable;
import com.facebook.presto.sql.tree.ResetSession;
import com.facebook.presto.sql.tree.Return;
import com.facebook.presto.sql.tree.Revoke;
import com.facebook.presto.sql.tree.Rollback;
import com.facebook.presto.sql.tree.Rollup;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.SetOperation;
import com.facebook.presto.sql.tree.SetSession;
import com.facebook.presto.sql.tree.SimpleGroupBy;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.SqlParameterDeclaration;
import com.facebook.presto.sql.tree.StartTransaction;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.Union;
import com.facebook.presto.sql.tree.Unnest;
import com.facebook.presto.sql.tree.Use;
import com.facebook.presto.sql.tree.Values;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.sql.tree.With;
import com.facebook.presto.sql.tree.WithQuery;
import com.facebook.presto.sql.util.AstUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

class StatementAnalyzer {
    private static final int UNION_DISTINCT_FIELDS_WARNING_THRESHOLD = 3;
    private final Analysis analysis;
    private final Metadata metadata;
    private final Session session;
    private final SqlParser sqlParser;
    private final AccessControl accessControl;
    private final WarningCollector warningCollector;
    private final LiteralEncoder literalEncoder;

    public StatementAnalyzer(Analysis analysis, Metadata metadata, SqlParser sqlParser, AccessControl accessControl, Session session, WarningCollector warningCollector) {
        this.analysis = Objects.requireNonNull(analysis, "analysis is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.literalEncoder = new LiteralEncoder(metadata.getBlockEncodingSerde());
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
    }

    public Scope analyze(Node node, Scope outerQueryScope) {
        return this.analyze(node, Optional.of(outerQueryScope));
    }

    public Scope analyze(Node node, Optional<Scope> outerQueryScope) {
        return new Visitor(outerQueryScope, this.warningCollector).process(node, Optional.empty());
    }

    private static boolean hasScopeAsLocalParent(Scope root, Scope parent) {
        Scope scope = root;
        while (scope.getLocalParent().isPresent()) {
            if (!(scope = scope.getLocalParent().get()).equals(parent)) continue;
            return true;
        }
        return false;
    }

    private class Visitor
    extends DefaultTraversalVisitor<Scope, Optional<Scope>> {
        private final Optional<Scope> outerQueryScope;
        private final WarningCollector warningCollector;

        private Visitor(Optional<Scope> outerQueryScope, WarningCollector warningCollector) {
            this.outerQueryScope = Objects.requireNonNull(outerQueryScope, "outerQueryScope is null");
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        }

        public Scope process(Node node, Optional<Scope> scope) {
            Scope returnScope = (Scope)super.process(node, scope);
            Preconditions.checkState((boolean)returnScope.getOuterQueryParent().equals(this.outerQueryScope), (Object)"result scope should have outer query scope equal with parameter outer query scope");
            if (scope.isPresent()) {
                Preconditions.checkState((boolean)StatementAnalyzer.hasScopeAsLocalParent(returnScope, scope.get()), (Object)"return scope should have context scope as one of ancestors");
            }
            return returnScope;
        }

        private Scope process(Node node, Scope scope) {
            return this.process(node, Optional.of(scope));
        }

        protected Scope visitUse(Use node, Optional<Scope> scope) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "USE statement is not supported", new Object[0]);
        }

        protected Scope visitInsert(Insert insert, Optional<Scope> scope) {
            List insertColumns;
            QualifiedObjectName targetTable = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)insert, insert.getTarget());
            if (StatementAnalyzer.this.metadata.getView(StatementAnalyzer.this.session, targetTable).isPresent()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)insert, "Inserting into views is not supported", new Object[0]);
            }
            if (StatementAnalyzer.this.metadata.getMaterializedView(StatementAnalyzer.this.session, targetTable).isPresent()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)insert, "Inserting into materialized views is not supported", new Object[0]);
            }
            Scope queryScope = this.process((Node)insert.getQuery(), scope);
            StatementAnalyzer.this.analysis.setUpdateType("INSERT");
            Optional<TableHandle> targetTableHandle = StatementAnalyzer.this.metadata.getTableHandle(StatementAnalyzer.this.session, targetTable);
            if (!targetTableHandle.isPresent()) {
                throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)insert, "Table '%s' does not exist", targetTable);
            }
            StatementAnalyzer.this.accessControl.checkCanInsertIntoTable(StatementAnalyzer.this.session.getRequiredTransactionId(), StatementAnalyzer.this.session.getIdentity(), StatementAnalyzer.this.session.getAccessControlContext(), targetTable);
            TableMetadata tableMetadata = StatementAnalyzer.this.metadata.getTableMetadata(StatementAnalyzer.this.session, targetTableHandle.get());
            List tableColumns = (List)tableMetadata.getColumns().stream().filter(column -> !column.isHidden()).map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList());
            if (insert.getColumns().isPresent()) {
                insertColumns = (List)((List)insert.getColumns().get()).stream().map(Identifier::getValue).map(column -> column.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList());
                HashSet<String> columnNames = new HashSet<String>();
                for (String insertColumn2 : insertColumns) {
                    if (!tableColumns.contains(insertColumn2)) {
                        throw new SemanticException(SemanticErrorCode.MISSING_COLUMN, (Node)insert, "Insert column name does not exist in target table: %s", insertColumn2);
                    }
                    if (columnNames.add(insertColumn2)) continue;
                    throw new SemanticException(SemanticErrorCode.DUPLICATE_COLUMN_NAME, (Node)insert, "Insert column name is specified more than once: %s", insertColumn2);
                }
            } else {
                insertColumns = tableColumns;
            }
            List expectedColumns = (List)insertColumns.stream().map(insertColumn -> tableMetadata.getColumn((String)insertColumn)).collect(ImmutableList.toImmutableList());
            this.checkTypesMatchForInsert(insert, queryScope, expectedColumns);
            Map<String, ColumnHandle> columnHandles = StatementAnalyzer.this.metadata.getColumnHandles(StatementAnalyzer.this.session, targetTableHandle.get());
            StatementAnalyzer.this.analysis.setInsert(new Analysis.Insert(targetTableHandle.get(), (List)insertColumns.stream().map(columnHandles::get).collect(ImmutableList.toImmutableList())));
            return this.createAndAssignScope((Node)insert, scope, Field.newUnqualified("rows", (Type)BigintType.BIGINT));
        }

        private void checkTypesMatchForInsert(Insert insert, Scope queryScope, List<ColumnMetadata> expectedColumns) {
            List queryColumnTypes = (List)queryScope.getRelationType().getVisibleFields().stream().map(Field::getType).collect(ImmutableList.toImmutableList());
            String errorMessage = "";
            if (expectedColumns.size() != queryColumnTypes.size()) {
                errorMessage = String.format("Insert query has %d expression(s) but expected %d target column(s). ", queryColumnTypes.size(), expectedColumns.size());
            }
            for (int i = 0; i < Math.max(expectedColumns.size(), queryColumnTypes.size()); ++i) {
                Insert node = insert;
                QueryBody queryBody = insert.getQuery().getQueryBody();
                if (queryBody instanceof Values) {
                    List rows = ((Values)queryBody).getRows();
                    Preconditions.checkState((!rows.isEmpty() ? 1 : 0) != 0, (Object)"Missing column values");
                    node = (Node)rows.get(0);
                    if (node instanceof Row) {
                        int columnIndex = Math.min(i, queryColumnTypes.size() - 1);
                        node = (Node)((Row)rows.get(0)).getItems().get(columnIndex);
                    }
                }
                if (i == expectedColumns.size()) {
                    throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, (Node)node, errorMessage + "Mismatch at column %d", i + 1);
                }
                if (i == queryColumnTypes.size()) {
                    throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, (Node)node, errorMessage + "Mismatch at column %d: '%s'", i + 1, expectedColumns.get(i).getName());
                }
                if (StatementAnalyzer.this.metadata.getFunctionAndTypeManager().canCoerce((Type)queryColumnTypes.get(i), expectedColumns.get(i).getType())) continue;
                if (queryColumnTypes.get(i) instanceof RowType && expectedColumns.get(i).getType() instanceof RowType) {
                    String fieldName = expectedColumns.get(i).getName();
                    List columnRowTypes = ((Type)queryColumnTypes.get(i)).getTypeParameters();
                    List expectedRowFields = ((RowType)expectedColumns.get(i).getType()).getFields();
                    this.checkTypesMatchForNestedStructs((Node)node, errorMessage, i + 1, fieldName, expectedRowFields, columnRowTypes);
                }
                throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, (Node)node, errorMessage + "Mismatch at column %d: '%s' is of type %s but expression is of type %s", i + 1, expectedColumns.get(i).getName(), expectedColumns.get(i).getType(), queryColumnTypes.get(i));
            }
        }

        private void checkTypesMatchForNestedStructs(Node node, String errorMessage, int columnIndex, String fieldName, List<RowType.Field> expectedRowFields, List<Type> columnRowTypes) {
            if (expectedRowFields.size() != columnRowTypes.size()) {
                throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, node, errorMessage + "Mismatch at column %d: '%s' has %d field(s) but expression has %d field(s)", columnIndex, fieldName, expectedRowFields.size(), columnRowTypes.size());
            }
            for (int rowFieldIndex = 0; rowFieldIndex < expectedRowFields.size(); ++rowFieldIndex) {
                if (StatementAnalyzer.this.metadata.getFunctionAndTypeManager().canCoerce(columnRowTypes.get(rowFieldIndex), expectedRowFields.get(rowFieldIndex).getType())) continue;
                fieldName = fieldName + "." + (String)expectedRowFields.get(rowFieldIndex).getName().get();
                if (columnRowTypes.get(rowFieldIndex) instanceof RowType && expectedRowFields.get(rowFieldIndex).getType() instanceof RowType) {
                    this.checkTypesMatchForNestedStructs(node, errorMessage, columnIndex, fieldName, ((RowType)expectedRowFields.get(rowFieldIndex).getType()).getFields(), columnRowTypes.get(rowFieldIndex).getTypeParameters());
                    continue;
                }
                throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, node, errorMessage + "Mismatch at column %d: '%s' is of type %s but expression is of type %s", columnIndex, fieldName, expectedRowFields.get(rowFieldIndex).getType(), columnRowTypes.get(rowFieldIndex));
            }
        }

        protected Scope visitDelete(Delete node, Optional<Scope> scope) {
            Table table = node.getTable();
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)table, table.getName());
            if (StatementAnalyzer.this.metadata.getView(StatementAnalyzer.this.session, tableName).isPresent()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Deleting from views is not supported", new Object[0]);
            }
            if (StatementAnalyzer.this.metadata.getMaterializedView(StatementAnalyzer.this.session, tableName).isPresent()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Deleting from materialized views is not supported", new Object[0]);
            }
            StatementAnalyzer analyzer = new StatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.metadata, StatementAnalyzer.this.sqlParser, new AllowAllAccessControl(), StatementAnalyzer.this.session, this.warningCollector);
            Scope tableScope = analyzer.analyze((Node)table, scope);
            node.getWhere().ifPresent(where -> this.analyzeWhere((Node)node, tableScope, (Expression)where));
            StatementAnalyzer.this.analysis.setUpdateType("DELETE");
            StatementAnalyzer.this.accessControl.checkCanDeleteFromTable(StatementAnalyzer.this.session.getRequiredTransactionId(), StatementAnalyzer.this.session.getIdentity(), StatementAnalyzer.this.session.getAccessControlContext(), tableName);
            return this.createAndAssignScope((Node)node, scope, Field.newUnqualified("rows", (Type)BigintType.BIGINT));
        }

        protected Scope visitAnalyze(Analyze node, Optional<Scope> scope) {
            StatementAnalyzer.this.analysis.setUpdateType("ANALYZE");
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)node, node.getTableName());
            if (StatementAnalyzer.this.metadata.getView(StatementAnalyzer.this.session, tableName).isPresent()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Analyzing views is not supported", new Object[0]);
            }
            this.validateProperties(node.getProperties(), scope);
            ConnectorId connectorId = StatementAnalyzer.this.metadata.getCatalogHandle(StatementAnalyzer.this.session, tableName.getCatalogName()).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog not found: " + tableName.getCatalogName()));
            Map<String, Object> analyzeProperties = StatementAnalyzer.this.metadata.getAnalyzePropertyManager().getProperties(connectorId, connectorId.getCatalogName(), NodeUtils.mapFromProperties(node.getProperties()), StatementAnalyzer.this.session, StatementAnalyzer.this.metadata, StatementAnalyzer.this.analysis.getParameters());
            TableHandle tableHandle = StatementAnalyzer.this.metadata.getTableHandleForStatisticsCollection(StatementAnalyzer.this.session, tableName, analyzeProperties).orElseThrow(() -> new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)node, "Table '%s' does not exist", tableName));
            StatementAnalyzer.this.analysis.addTableColumnReferences(StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session.getIdentity(), (Multimap<QualifiedObjectName, String>)ImmutableMultimap.builder().putAll((Object)tableName, StatementAnalyzer.this.metadata.getColumnHandles(StatementAnalyzer.this.session, tableHandle).keySet()).build());
            try {
                StatementAnalyzer.this.accessControl.checkCanInsertIntoTable(StatementAnalyzer.this.session.getRequiredTransactionId(), StatementAnalyzer.this.session.getIdentity(), StatementAnalyzer.this.session.getAccessControlContext(), tableName);
            }
            catch (AccessDeniedException exception) {
                throw new AccessDeniedException(String.format("Cannot ANALYZE (missing insert privilege) table %s", tableName));
            }
            StatementAnalyzer.this.analysis.setAnalyzeTarget(tableHandle);
            return this.createAndAssignScope((Node)node, scope, Field.newUnqualified("rows", (Type)BigintType.BIGINT));
        }

        protected Scope visitCreateTableAsSelect(CreateTableAsSelect node, Optional<Scope> scope) {
            StatementAnalyzer.this.analysis.setUpdateType("CREATE TABLE");
            QualifiedObjectName targetTable = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)node, node.getName());
            StatementAnalyzer.this.analysis.setCreateTableDestination(targetTable);
            Optional<TableHandle> targetTableHandle = StatementAnalyzer.this.metadata.getTableHandle(StatementAnalyzer.this.session, targetTable);
            if (targetTableHandle.isPresent()) {
                if (node.isNotExists()) {
                    StatementAnalyzer.this.analysis.setCreateTableAsSelectNoOp(true);
                    return this.createAndAssignScope((Node)node, scope, Field.newUnqualified("rows", (Type)BigintType.BIGINT));
                }
                throw new SemanticException(SemanticErrorCode.TABLE_ALREADY_EXISTS, (Node)node, "Destination table '%s' already exists", targetTable);
            }
            this.validateProperties(node.getProperties(), scope);
            StatementAnalyzer.this.analysis.setCreateTableProperties(NodeUtils.mapFromProperties(node.getProperties()));
            node.getColumnAliases().ifPresent(StatementAnalyzer.this.analysis::setCreateTableColumnAliases);
            StatementAnalyzer.this.analysis.setCreateTableComment(node.getComment());
            StatementAnalyzer.this.accessControl.checkCanCreateTable(StatementAnalyzer.this.session.getRequiredTransactionId(), StatementAnalyzer.this.session.getIdentity(), StatementAnalyzer.this.session.getAccessControlContext(), targetTable);
            StatementAnalyzer.this.analysis.setCreateTableAsSelectWithData(node.isWithData());
            Scope queryScope = this.process((Node)node.getQuery(), scope);
            if (node.getColumnAliases().isPresent()) {
                this.validateColumnAliases((List)node.getColumnAliases().get(), queryScope.getRelationType().getVisibleFieldCount());
                for (Field field : queryScope.getRelationType().getVisibleFields()) {
                    if (!field.getType().equals(UnknownType.UNKNOWN)) continue;
                    throw new SemanticException(SemanticErrorCode.COLUMN_TYPE_UNKNOWN, (Node)node, "Column type is unknown at position %s", queryScope.getRelationType().indexOf(field) + 1);
                }
            } else {
                this.validateColumns((Statement)node, queryScope.getRelationType());
            }
            return this.createAndAssignScope((Node)node, scope, Field.newUnqualified("rows", (Type)BigintType.BIGINT));
        }

        protected Scope visitCreateView(CreateView node, Optional<Scope> scope) {
            StatementAnalyzer.this.analysis.setUpdateType("CREATE VIEW");
            QualifiedObjectName viewName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)node, node.getName());
            StatementAnalyzer analyzer = new StatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.metadata, StatementAnalyzer.this.sqlParser, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session, this.warningCollector);
            Scope queryScope = analyzer.analyze((Node)node.getQuery(), scope);
            StatementAnalyzer.this.accessControl.checkCanCreateView(StatementAnalyzer.this.session.getRequiredTransactionId(), StatementAnalyzer.this.session.getIdentity(), StatementAnalyzer.this.session.getAccessControlContext(), viewName);
            this.validateColumns((Statement)node, queryScope.getRelationType());
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitCreateMaterializedView(CreateMaterializedView node, Optional<Scope> scope) {
            StatementAnalyzer.this.analysis.setUpdateType("CREATE MATERIALIZED VIEW");
            QualifiedObjectName viewName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)node, node.getName());
            StatementAnalyzer.this.analysis.setCreateTableDestination(viewName);
            Optional<TableHandle> viewHandle = StatementAnalyzer.this.metadata.getTableHandle(StatementAnalyzer.this.session, viewName);
            if (viewHandle.isPresent()) {
                if (node.isNotExists()) {
                    return this.createAndAssignScope((Node)node, scope);
                }
                throw new SemanticException(SemanticErrorCode.MATERIALIZED_VIEW_ALREADY_EXISTS, (Node)node, "Destination materialized view '%s' already exists", viewName);
            }
            this.validateMaterialziedViewQueryPlan((Statement)node.getQuery());
            this.validateProperties(node.getProperties(), scope);
            StatementAnalyzer.this.analysis.setCreateTableProperties(NodeUtils.mapFromProperties(node.getProperties()));
            StatementAnalyzer.this.analysis.setCreateTableComment(node.getComment());
            StatementAnalyzer.this.accessControl.checkCanCreateTable(StatementAnalyzer.this.session.getRequiredTransactionId(), StatementAnalyzer.this.session.getIdentity(), StatementAnalyzer.this.session.getAccessControlContext(), viewName);
            StatementAnalyzer.this.accessControl.checkCanCreateView(StatementAnalyzer.this.session.getRequiredTransactionId(), StatementAnalyzer.this.session.getIdentity(), StatementAnalyzer.this.session.getAccessControlContext(), viewName);
            Scope queryScope = this.process((Node)node.getQuery(), scope);
            this.validateColumns((Statement)node, queryScope.getRelationType());
            this.validateBaseTables(StatementAnalyzer.this.analysis.getTableNodes(), (Node)node);
            return this.createAndAssignScope((Node)node, scope);
        }

        private void validateMaterialziedViewQueryPlan(Statement query) {
            MaterializedViewPlanValidator validator = new MaterializedViewPlanValidator((Node)query);
            validator.process((Node)query, new MaterializedViewPlanValidator.MaterializedViewPlanValidatorContext());
        }

        protected Scope visitRefreshMaterializedView(RefreshMaterializedView node, Optional<Scope> scope) {
            StatementAnalyzer.this.analysis.setUpdateType("INSERT");
            QualifiedObjectName viewName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)node.getTarget(), node.getTarget().getName());
            ConnectorMaterializedViewDefinition view = StatementAnalyzer.this.metadata.getMaterializedView(StatementAnalyzer.this.session, viewName).orElseThrow(() -> new SemanticException(SemanticErrorCode.MISSING_MATERIALIZED_VIEW, (Node)node, "Materialized view '%s' does not exist", viewName));
            StatementAnalyzer.this.accessControl.checkCanInsertIntoTable(StatementAnalyzer.this.session.getRequiredTransactionId(), StatementAnalyzer.this.session.getIdentity(), StatementAnalyzer.this.session.getAccessControlContext(), viewName);
            Scope viewScope = this.process((Node)node.getTarget(), scope);
            Map<SchemaTableName, Expression> tablePredicates = RefreshMaterializedViewPredicateAnalyzer.extractTablePredicates(viewName, node.getWhere(), viewScope, StatementAnalyzer.this.metadata, StatementAnalyzer.this.session);
            Query viewQuery = this.parseView(view.getOriginalSql(), viewName, (Node)node);
            Query refreshQuery = tablePredicates.containsKey(MetadataUtil.toSchemaTableName(viewName)) ? this.buildQueryWithPredicate(viewQuery, tablePredicates.get(MetadataUtil.toSchemaTableName(viewName))) : viewQuery;
            this.process((Node)refreshQuery, scope);
            TableHandle tableHandle = StatementAnalyzer.this.metadata.getTableHandle(StatementAnalyzer.this.session, viewName).orElseThrow(() -> new SemanticException(SemanticErrorCode.MISSING_MATERIALIZED_VIEW, (Node)node, "Materialized view '%s' does not exist", viewName));
            Map<String, ColumnHandle> columnHandles = StatementAnalyzer.this.metadata.getColumnHandles(StatementAnalyzer.this.session, tableHandle);
            List targetColumnHandles = (List)StatementAnalyzer.this.metadata.getTableMetadata(StatementAnalyzer.this.session, tableHandle).getColumns().stream().filter(column -> !column.isHidden()).map(column -> (ColumnHandle)columnHandles.get(column.getName())).collect(ImmutableList.toImmutableList());
            StatementAnalyzer.this.analysis.setRefreshMaterializedViewAnalysis(new Analysis.RefreshMaterializedViewAnalysis(tableHandle, targetColumnHandles, refreshQuery));
            return this.createAndAssignScope((Node)node, scope, Field.newUnqualified("rows", (Type)BigintType.BIGINT));
        }

        private Optional<RelationType> analyzeBaseTableForRefreshMaterializedView(Table baseTable, Optional<Scope> scope) {
            Preconditions.checkState((boolean)(StatementAnalyzer.this.analysis.getStatement() instanceof RefreshMaterializedView), (Object)"Not analyzing RefreshMaterializedView statement");
            RefreshMaterializedView refreshMaterializedView = (RefreshMaterializedView)StatementAnalyzer.this.analysis.getStatement();
            QualifiedObjectName viewName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)refreshMaterializedView.getTarget(), refreshMaterializedView.getTarget().getName());
            Scope viewScope = this.process((Node)refreshMaterializedView.getTarget(), scope);
            Map<SchemaTableName, Expression> tablePredicates = RefreshMaterializedViewPredicateAnalyzer.extractTablePredicates(viewName, refreshMaterializedView.getWhere(), viewScope, StatementAnalyzer.this.metadata, StatementAnalyzer.this.session);
            SchemaTableName baseTableName = MetadataUtil.toSchemaTableName(MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)baseTable, baseTable.getName()));
            if (tablePredicates.containsKey(baseTableName)) {
                Query tableSubquery = this.buildQueryWithPredicate(baseTable, tablePredicates.get(baseTableName));
                StatementAnalyzer.this.analysis.registerNamedQuery(baseTable, tableSubquery);
                Scope subqueryScope = this.process((Node)tableSubquery, scope);
                return Optional.of(subqueryScope.getRelationType().withAlias(baseTableName.getTableName(), null));
            }
            return Optional.empty();
        }

        private Query buildQueryWithPredicate(Table table, Expression predicate) {
            Query query = QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)table, (Expression)predicate);
            return (Query)StatementAnalyzer.this.sqlParser.createStatement(SqlFormatterUtil.getFormattedSql((Statement)query, StatementAnalyzer.this.sqlParser, Optional.empty()), ParsingUtil.createParsingOptions(StatementAnalyzer.this.session, this.warningCollector));
        }

        private Query buildQueryWithPredicate(Query originalQuery, Expression predicate) {
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new TableSubquery(originalQuery), (Expression)predicate);
        }

        protected Scope visitCreateFunction(CreateFunction node, Optional<Scope> scope) {
            StatementAnalyzer.this.analysis.setUpdateType("CREATE FUNCTION");
            this.checkFunctionName((Statement)node, node.getFunctionName(), node.isTemporary());
            if (node.isTemporary() && node.isReplace()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "REPLACE is not supported for temporary functions", new Object[0]);
            }
            List duplicateParameters = (List)node.getParameters().stream().map(SqlParameterDeclaration::getName).map(Identifier::getValue).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
            if (!duplicateParameters.isEmpty()) {
                throw new SemanticException(SemanticErrorCode.DUPLICATE_PARAMETER_NAME, (Node)node, "Duplicate function parameter name: %s", Joiner.on((String)", ").join((Iterable)duplicateParameters));
            }
            Type returnType = StatementAnalyzer.this.metadata.getType(TypeSignature.parseTypeSignature((String)node.getReturnType()));
            List fields = (List)node.getParameters().stream().map(parameter -> Field.newUnqualified(parameter.getName().getValue(), StatementAnalyzer.this.metadata.getType(TypeSignature.parseTypeSignature((String)parameter.getType())))).collect(ImmutableList.toImmutableList());
            Scope functionScope = Scope.builder().withRelationType(RelationId.anonymous(), new RelationType(fields)).build();
            if (node.getBody() instanceof Return) {
                Expression returnExpression = ((Return)node.getBody()).getExpression();
                Type bodyType = this.analyzeExpression(returnExpression, functionScope).getExpressionTypes().get(NodeRef.of((Node)returnExpression));
                if (!StatementAnalyzer.this.metadata.getFunctionAndTypeManager().canCoerce(bodyType, returnType)) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Function implementation type '%s' does not match declared return type '%s'", bodyType, returnType);
                }
                Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.analysis.getFunctionHandles(), StatementAnalyzer.this.metadata.getFunctionAndTypeManager(), returnExpression, "CREATE FUNCTION body");
                Analyzer.verifyNoExternalFunctions(StatementAnalyzer.this.analysis.getFunctionHandles(), StatementAnalyzer.this.metadata.getFunctionAndTypeManager(), returnExpression, "CREATE FUNCTION body");
            }
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitAlterFunction(AlterFunction node, Optional<Scope> scope) {
            this.checkFunctionName((Statement)node, node.getFunctionName(), false);
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDropFunction(DropFunction node, Optional<Scope> scope) {
            this.checkFunctionName((Statement)node, node.getFunctionName(), node.isTemporary());
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitSetSession(SetSession node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitResetSession(ResetSession node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitAddColumn(AddColumn node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitCreateSchema(CreateSchema node, Optional<Scope> scope) {
            this.validateProperties(node.getProperties(), scope);
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDropSchema(DropSchema node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitRenameSchema(RenameSchema node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitCreateTable(CreateTable node, Optional<Scope> scope) {
            this.validateProperties(node.getProperties(), scope);
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitProperty(Property node, Optional<Scope> scope) {
            ExpressionAnalyzer.createConstantAnalyzer(StatementAnalyzer.this.metadata, StatementAnalyzer.this.session, StatementAnalyzer.this.analysis.getParameters(), this.warningCollector, StatementAnalyzer.this.analysis.isDescribe()).analyze(node.getValue(), this.createScope(scope));
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDropTable(DropTable node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitRenameTable(RenameTable node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitRenameColumn(RenameColumn node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDropColumn(DropColumn node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDropView(DropView node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDropMaterializedView(DropMaterializedView node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitStartTransaction(StartTransaction node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitCommit(Commit node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitRollback(Rollback node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitPrepare(Prepare node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDeallocate(Deallocate node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitExecute(Execute node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitGrant(Grant node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitRevoke(Revoke node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitCall(Call node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        private void validateProperties(List<Property> properties, Optional<Scope> scope) {
            HashSet<String> propertyNames = new HashSet<String>();
            for (Property property : properties) {
                if (propertyNames.add(property.getName().getValue())) continue;
                throw new SemanticException(SemanticErrorCode.DUPLICATE_PROPERTY, (Node)property, "Duplicate property: %s", property.getName().getValue());
            }
            for (Property property : properties) {
                this.process((Node)property, scope);
            }
        }

        private void validateColumns(Statement node, RelationType descriptor) {
            HashSet<String> names = new HashSet<String>();
            for (Field field : descriptor.getVisibleFields()) {
                Optional<String> fieldName = field.getName();
                if (!fieldName.isPresent()) {
                    throw new SemanticException(SemanticErrorCode.COLUMN_NAME_NOT_SPECIFIED, (Node)node, "Column name not specified at position %s", descriptor.indexOf(field) + 1);
                }
                if (!names.add(fieldName.get())) {
                    throw new SemanticException(SemanticErrorCode.DUPLICATE_COLUMN_NAME, (Node)node, "Column name '%s' specified more than once", fieldName.get());
                }
                if (!field.getType().equals(UnknownType.UNKNOWN)) continue;
                throw new SemanticException(SemanticErrorCode.COLUMN_TYPE_UNKNOWN, (Node)node, "Column type is unknown: %s", fieldName.get());
            }
        }

        private void validateColumnAliases(List<Identifier> columnAliases, int sourceColumnSize) {
            if (columnAliases.size() != sourceColumnSize) {
                throw new SemanticException(SemanticErrorCode.MISMATCHED_COLUMN_ALIASES, (Node)columnAliases.get(0), "Column alias list has %s entries but subquery has %s columns", columnAliases.size(), sourceColumnSize);
            }
            HashSet<String> names = new HashSet<String>();
            for (Identifier identifier : columnAliases) {
                if (names.contains(identifier.getValue().toLowerCase(Locale.ENGLISH))) {
                    throw new SemanticException(SemanticErrorCode.DUPLICATE_COLUMN_NAME, (Node)identifier, "Column name '%s' specified more than once", identifier.getValue());
                }
                names.add(identifier.getValue().toLowerCase(Locale.ENGLISH));
            }
        }

        private void validateBaseTables(List<Table> baseTables, Node node) {
            for (Table baseTable : baseTables) {
                QualifiedObjectName baseName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)baseTable, baseTable.getName());
                Optional<ConnectorMaterializedViewDefinition> optionalMaterializedView = StatementAnalyzer.this.metadata.getMaterializedView(StatementAnalyzer.this.session, baseName);
                if (!optionalMaterializedView.isPresent()) continue;
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)baseTable, "%s on a materialized view %s is not supported.", node.getClass().getSimpleName(), baseName);
            }
        }

        protected Scope visitExplain(Explain node, Optional<Scope> scope) throws SemanticException {
            Preconditions.checkState((boolean)node.isAnalyze(), (Object)"Non analyze explain should be rewritten to Query");
            if (node.getOptions().stream().anyMatch(option -> !option.equals((Object)new ExplainType(ExplainType.Type.DISTRIBUTED)))) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "EXPLAIN ANALYZE only supports TYPE DISTRIBUTED option", new Object[0]);
            }
            this.process((Node)node.getStatement(), scope);
            StatementAnalyzer.this.analysis.setUpdateType(null);
            return this.createAndAssignScope((Node)node, scope, Field.newUnqualified("Query Plan", (Type)VarcharType.VARCHAR));
        }

        protected Scope visitQuery(Query node, Optional<Scope> scope) {
            Scope withScope = this.analyzeWith(node, scope);
            Scope queryBodyScope = this.process((Node)node.getQueryBody(), withScope);
            List<Expression> orderByExpressions = Collections.emptyList();
            if (node.getOrderBy().isPresent()) {
                orderByExpressions = this.analyzeOrderBy((Node)node, NodeUtils.getSortItemsFromOrderBy(node.getOrderBy()), queryBodyScope);
                if (queryBodyScope.getOuterQueryParent().isPresent() && !node.getLimit().isPresent()) {
                    StatementAnalyzer.this.analysis.markRedundantOrderBy((OrderBy)node.getOrderBy().get());
                    this.warningCollector.add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.REDUNDANT_ORDER_BY, "ORDER BY in subquery may have no effect"));
                }
            }
            StatementAnalyzer.this.analysis.setOrderByExpressions((Node)node, orderByExpressions);
            if (node.getOffset().isPresent()) {
                this.analyzeOffset((Offset)node.getOffset().get());
            }
            StatementAnalyzer.this.analysis.setOutputExpressions((Node)node, this.descriptorToFields(queryBodyScope));
            Scope queryScope = Scope.builder().withParent(withScope).withRelationType(RelationId.of((Node)node), queryBodyScope.getRelationType()).build();
            StatementAnalyzer.this.analysis.setScope((Node)node, queryScope);
            return queryScope;
        }

        protected Scope visitUnnest(Unnest node, Optional<Scope> scope) {
            ImmutableList.Builder outputFields = ImmutableList.builder();
            for (Expression expression : node.getExpressions()) {
                ExpressionAnalysis expressionAnalysis = this.analyzeExpression(expression, this.createScope(scope));
                Type expressionType = expressionAnalysis.getType(expression);
                if (expressionType instanceof ArrayType) {
                    Type elementType = ((ArrayType)expressionType).getElementType();
                    if (!SystemSessionProperties.isLegacyUnnest(StatementAnalyzer.this.session) && elementType instanceof RowType) {
                        ((RowType)elementType).getFields().stream().map(field -> Field.newUnqualified(field.getName(), field.getType())).forEach(arg_0 -> ((ImmutableList.Builder)outputFields).add(arg_0));
                        continue;
                    }
                    outputFields.add((Object)Field.newUnqualified(Optional.empty(), elementType));
                    continue;
                }
                if (expressionType instanceof MapType) {
                    outputFields.add((Object)Field.newUnqualified(Optional.empty(), ((MapType)expressionType).getKeyType()));
                    outputFields.add((Object)Field.newUnqualified(Optional.empty(), ((MapType)expressionType).getValueType()));
                    continue;
                }
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Cannot unnest type: " + expressionType);
            }
            if (node.isWithOrdinality()) {
                outputFields.add((Object)Field.newUnqualified(Optional.empty(), (Type)BigintType.BIGINT));
            }
            return this.createAndAssignScope((Node)node, scope, (List<Field>)outputFields.build());
        }

        protected Scope visitLateral(Lateral node, Optional<Scope> scope) {
            StatementAnalyzer analyzer = new StatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.metadata, StatementAnalyzer.this.sqlParser, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session, this.warningCollector);
            Scope queryScope = analyzer.analyze((Node)node.getQuery(), scope);
            return this.createAndAssignScope((Node)node, scope, queryScope.getRelationType());
        }

        protected Scope visitTable(Table table, Optional<Scope> scope) {
            Table view;
            Optional<TableHandle> tableHandle;
            String name;
            if (!table.getName().getPrefix().isPresent()) {
                name = table.getName().getSuffix();
                Optional<WithQuery> withQuery = this.createScope(scope).getNamedQuery(name);
                if (withQuery.isPresent()) {
                    List fields;
                    Query query = withQuery.get().getQuery();
                    StatementAnalyzer.this.analysis.registerNamedQuery(table, query);
                    RelationType queryDescriptor = StatementAnalyzer.this.analysis.getOutputDescriptor((Node)query);
                    Optional columnNames = withQuery.get().getColumnNames();
                    if (columnNames.isPresent()) {
                        ImmutableList.Builder fieldBuilder = ImmutableList.builder();
                        Iterator<Field> visibleFieldsIterator = queryDescriptor.getVisibleFields().iterator();
                        for (Identifier columnName : (List)columnNames.get()) {
                            Field inputField = visibleFieldsIterator.next();
                            fieldBuilder.add((Object)Field.newQualified(QualifiedName.of((String)name), Optional.of(columnName.getValue()), inputField.getType(), false, inputField.getOriginTable(), inputField.getOriginColumnName(), inputField.isAliased()));
                        }
                        fields = fieldBuilder.build();
                    } else {
                        fields = (List)queryDescriptor.getAllFields().stream().map(field -> Field.newQualified(QualifiedName.of((String)name), field.getName(), field.getType(), field.isHidden(), field.getOriginTable(), field.getOriginColumnName(), field.isAliased())).collect(ImmutableList.toImmutableList());
                    }
                    return this.createAndAssignScope((Node)table, scope, fields);
                }
            }
            if ((name = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)table, table.getName())).getObjectName().isEmpty()) {
                throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)table, "Table name is empty", new Object[0]);
            }
            if (name.getSchemaName().isEmpty()) {
                throw new SemanticException(SemanticErrorCode.MISSING_SCHEMA, (Node)table, "Schema name is empty", new Object[0]);
            }
            StatementAnalyzer.this.analysis.addEmptyColumnReferencesForTable(StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session.getIdentity(), (QualifiedObjectName)name);
            Optional<ViewDefinition> optionalView = StatementAnalyzer.this.metadata.getView(StatementAnalyzer.this.session, (QualifiedObjectName)name);
            if (optionalView.isPresent()) {
                return this.processView(table, scope, (QualifiedObjectName)name, optionalView);
            }
            Optional<ConnectorMaterializedViewDefinition> optionalMaterializedView = StatementAnalyzer.this.metadata.getMaterializedView(StatementAnalyzer.this.session, (QualifiedObjectName)name);
            Statement statement = StatementAnalyzer.this.analysis.getStatement();
            if (SystemSessionProperties.isMaterializedViewDataConsistencyEnabled(StatementAnalyzer.this.session) && optionalMaterializedView.isPresent() && statement instanceof Query) {
                MaterializedViewStatus materializedViewStatus;
                Analysis.MaterializedViewAnalysisState materializedViewAnalysisState = StatementAnalyzer.this.analysis.getMaterializedViewAnalysisState(table);
                QualifiedObjectName materializedViewName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)table, table.getName());
                if (materializedViewAnalysisState.isNotVisited() && !(materializedViewStatus = StatementAnalyzer.this.metadata.getMaterializedViewStatus(StatementAnalyzer.this.session, materializedViewName)).isFullyMaterialized()) {
                    return this.processMaterializedView(table, materializedViewName, scope, (QualifiedObjectName)name, optionalMaterializedView.get(), materializedViewStatus);
                }
                if (materializedViewAnalysisState.isVisited()) {
                    throw new SemanticException(SemanticErrorCode.MATERIALIZED_VIEW_IS_RECURSIVE, (Node)table, "Materialized view is recursive", new Object[0]);
                }
            }
            if (!(tableHandle = StatementAnalyzer.this.metadata.getTableHandle(StatementAnalyzer.this.session, (QualifiedObjectName)name)).isPresent()) {
                if (!StatementAnalyzer.this.metadata.getCatalogHandle(StatementAnalyzer.this.session, name.getCatalogName()).isPresent()) {
                    throw new SemanticException(SemanticErrorCode.MISSING_CATALOG, (Node)table, "Catalog %s does not exist", name.getCatalogName());
                }
                if (!StatementAnalyzer.this.metadata.schemaExists(StatementAnalyzer.this.session, new CatalogSchemaName(name.getCatalogName(), name.getSchemaName()))) {
                    throw new SemanticException(SemanticErrorCode.MISSING_SCHEMA, (Node)table, "Schema %s does not exist", name.getSchemaName());
                }
                throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)table, "Table %s does not exist", name);
            }
            TableMetadata tableMetadata = StatementAnalyzer.this.metadata.getTableMetadata(StatementAnalyzer.this.session, tableHandle.get());
            Map<String, ColumnHandle> columnHandles = StatementAnalyzer.this.metadata.getColumnHandles(StatementAnalyzer.this.session, tableHandle.get());
            ImmutableList.Builder fields = ImmutableList.builder();
            for (ColumnMetadata column : tableMetadata.getColumns()) {
                Field field2 = Field.newQualified(table.getName(), Optional.of(column.getName()), column.getType(), column.isHidden(), Optional.of(name), Optional.of(column.getName()), false);
                fields.add((Object)field2);
                ColumnHandle columnHandle = columnHandles.get(column.getName());
                Preconditions.checkArgument((columnHandle != null ? 1 : 0) != 0, (String)"Unknown field %s", (Object)field2);
                StatementAnalyzer.this.analysis.setColumn(field2, columnHandle);
            }
            StatementAnalyzer.this.analysis.registerTable(table, tableHandle.get());
            if (statement instanceof RefreshMaterializedView && !table.equals((Object)(view = ((RefreshMaterializedView)statement).getTarget())) && !StatementAnalyzer.this.analysis.hasTableRegisteredForMaterializedView(view, table)) {
                StatementAnalyzer.this.analysis.registerTableForMaterializedView(view, table);
                Optional<RelationType> descriptor = this.analyzeBaseTableForRefreshMaterializedView(table, scope);
                StatementAnalyzer.this.analysis.unregisterTableForMaterializedView(view, table);
                if (descriptor.isPresent()) {
                    return this.createAndAssignScope((Node)table, scope, descriptor.get());
                }
            }
            return this.createAndAssignScope((Node)table, scope, (List<Field>)fields.build());
        }

        private Scope processView(Table table, Optional<Scope> scope, QualifiedObjectName name, Optional<ViewDefinition> optionalView) {
            Statement statement = StatementAnalyzer.this.analysis.getStatement();
            if (statement instanceof CreateView) {
                CreateView viewStatement = (CreateView)statement;
                QualifiedObjectName viewNameFromStatement = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)viewStatement, viewStatement.getName());
                if (viewStatement.isReplace() && viewNameFromStatement.equals((Object)name)) {
                    throw new SemanticException(SemanticErrorCode.VIEW_IS_RECURSIVE, (Node)table, "Statement would create a recursive view", new Object[0]);
                }
            }
            if (StatementAnalyzer.this.analysis.hasTableInView(table)) {
                throw new SemanticException(SemanticErrorCode.VIEW_IS_RECURSIVE, (Node)table, "View is recursive", new Object[0]);
            }
            ViewDefinition view = optionalView.get();
            Query query = this.parseView(view.getOriginalSql(), name, (Node)table);
            StatementAnalyzer.this.analysis.registerNamedQuery(table, query);
            StatementAnalyzer.this.analysis.registerTableForView(table);
            RelationType descriptor = this.analyzeView(query, name, view.getCatalog(), view.getSchema(), view.getOwner(), table);
            StatementAnalyzer.this.analysis.unregisterTableForView();
            if (this.isViewStale(view.getColumns(), descriptor.getVisibleFields())) {
                throw new SemanticException(SemanticErrorCode.VIEW_IS_STALE, (Node)table, "View '%s' is stale; it must be re-created", name);
            }
            List outputFields = (List)view.getColumns().stream().map(column -> Field.newQualified(table.getName(), Optional.of(column.getName()), column.getType(), false, Optional.of(name), Optional.of(column.getName()), false)).collect(ImmutableList.toImmutableList());
            StatementAnalyzer.this.analysis.addRelationCoercion((Relation)table, (Type[])outputFields.stream().map(Field::getType).toArray(Type[]::new));
            return this.createAndAssignScope((Node)table, scope, outputFields);
        }

        private Scope processMaterializedView(Table materializedView, QualifiedObjectName materializedViewObjectName, Optional<Scope> scope, QualifiedObjectName materializedViewQualifiedObjectName, ConnectorMaterializedViewDefinition materializedViewDefinition, MaterializedViewStatus materializedViewStatus) {
            this.validateMaterialziedViewQueryPlan(StatementAnalyzer.this.sqlParser.createStatement(materializedViewDefinition.getOriginalSql(), ParsingUtil.createParsingOptions(StatementAnalyzer.this.session, this.warningCollector)));
            String newSql = this.getMaterializedViewSQL(materializedView, materializedViewDefinition, materializedViewStatus);
            Query query = (Query)StatementAnalyzer.this.sqlParser.createStatement(newSql, ParsingUtil.createParsingOptions(StatementAnalyzer.this.session, this.warningCollector));
            StatementAnalyzer.this.analysis.registerNamedQuery(materializedView, query);
            StatementAnalyzer.this.analysis.registerMaterializedViewForAnalysis(materializedView);
            RelationType relationType = this.analyzeView(query, materializedViewQualifiedObjectName, Optional.of(materializedViewObjectName.getCatalogName()), Optional.of(materializedViewDefinition.getSchema()), materializedViewDefinition.getOwner(), materializedView);
            StatementAnalyzer.this.analysis.unregisterMaterializedViewForAnalysis(materializedView);
            return this.createAndAssignScope((Node)materializedView, scope, relationType);
        }

        private String getMaterializedViewSQL(Table materializedView, ConnectorMaterializedViewDefinition connectorMaterializedViewDefinition, MaterializedViewStatus materializedViewStatus) {
            String materializedViewCreateSql = connectorMaterializedViewDefinition.getOriginalSql();
            if (materializedViewStatus.isNotMaterialized()) {
                return materializedViewCreateSql;
            }
            Preconditions.checkState((boolean)materializedViewStatus.isPartiallyMaterialized(), (Object)("materialized view status is " + materializedViewStatus));
            Statement createSqlStatement = StatementAnalyzer.this.sqlParser.createStatement(materializedViewCreateSql, ParsingUtil.createParsingOptions(StatementAnalyzer.this.session, this.warningCollector));
            Map<SchemaTableName, Expression> partitionPredicates = this.generatePartitionPredicate(materializedViewStatus.getPartitionsFromBaseTables());
            Query predicateStitchedQuery = (Query)new PredicateStitcher(StatementAnalyzer.this.session, partitionPredicates).process((Node)createSqlStatement, new PredicateStitcher.PredicateStitcherContext());
            QuerySpecification materializedViewQuerySpecification = new QuerySpecification(QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), Optional.of(materializedView), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
            Union union = new Union((List)ImmutableList.of((Object)predicateStitchedQuery.getQueryBody(), (Object)materializedViewQuerySpecification), Optional.of(Boolean.FALSE));
            Query unionQuery = new Query(predicateStitchedQuery.getWith(), (QueryBody)union, predicateStitchedQuery.getOrderBy(), predicateStitchedQuery.getOffset(), predicateStitchedQuery.getLimit());
            return SqlFormatterUtil.getFormattedSql((Statement)unionQuery, StatementAnalyzer.this.sqlParser, Optional.empty());
        }

        private Map<SchemaTableName, Expression> generatePartitionPredicate(Map<SchemaTableName, MaterializedViewStatus.MaterializedDataPredicates> partitionsFromBaseTables) {
            HashMap<SchemaTableName, Expression> partitionPredicates = new HashMap<SchemaTableName, Expression>();
            for (SchemaTableName baseTable : partitionsFromBaseTables.keySet()) {
                MaterializedViewStatus.MaterializedDataPredicates predicatesInfo = partitionsFromBaseTables.get(baseTable);
                List partitionKeys = predicatesInfo.getColumnNames();
                ImmutableList keyExpressions = (ImmutableList)partitionKeys.stream().map(Identifier::new).collect(ImmutableList.toImmutableList());
                List predicateDisjuncts = predicatesInfo.getPredicateDisjuncts();
                LogicalBinaryExpression disjunct = null;
                for (TupleDomain predicateDisjunct : predicateDisjuncts) {
                    LogicalBinaryExpression conjunct = null;
                    Iterator keyExpressionsIterator = keyExpressions.stream().iterator();
                    Map predicateKeyValue = (Map)TupleDomain.extractFixedValues((TupleDomain)predicateDisjunct).orElseThrow(() -> new IllegalStateException("predicateKeyValue is not present!"));
                    for (String key : partitionKeys) {
                        IsNullPredicate expression;
                        NullableValue nullableValue = (NullableValue)predicateKeyValue.get(key);
                        if (nullableValue.isNull()) {
                            expression = new IsNullPredicate((Expression)keyExpressionsIterator.next());
                        } else {
                            Expression valueExpression = StatementAnalyzer.this.literalEncoder.toExpression(nullableValue.getValue(), nullableValue.getType(), false);
                            expression = new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)keyExpressionsIterator.next(), valueExpression);
                        }
                        conjunct = conjunct == null ? expression : new LogicalBinaryExpression(LogicalBinaryExpression.Operator.AND, (Expression)conjunct, (Expression)expression);
                    }
                    disjunct = conjunct == null ? disjunct : (disjunct == null ? conjunct : new LogicalBinaryExpression(LogicalBinaryExpression.Operator.OR, (Expression)disjunct, (Expression)conjunct));
                }
                if (disjunct == null) continue;
                partitionPredicates.put(baseTable, (Expression)disjunct);
            }
            return partitionPredicates;
        }

        protected Scope visitAliasedRelation(AliasedRelation relation, Optional<Scope> scope) {
            int totalColumns;
            Scope relationScope = this.process((Node)relation.getRelation(), scope);
            RelationType relationType = relationScope.getRelationType();
            if (relation.getColumnNames() != null && (totalColumns = relationType.getVisibleFieldCount()) != relation.getColumnNames().size()) {
                throw new SemanticException(SemanticErrorCode.MISMATCHED_COLUMN_ALIASES, (Node)relation, "Column alias list has %s entries but '%s' has %s columns available", relation.getColumnNames().size(), relation.getAlias(), totalColumns);
            }
            List aliases = null;
            if (relation.getColumnNames() != null) {
                aliases = relation.getColumnNames().stream().map(Identifier::getValue).collect(Collectors.toList());
            }
            RelationType descriptor = relationType.withAlias(relation.getAlias().getValue(), aliases);
            return this.createAndAssignScope((Node)relation, scope, descriptor);
        }

        protected Scope visitSampledRelation(SampledRelation relation, Optional<Scope> scope) {
            if (!VariablesExtractor.extractNames(relation.getSamplePercentage(), StatementAnalyzer.this.analysis.getColumnReferences()).isEmpty()) {
                throw new SemanticException(SemanticErrorCode.NON_NUMERIC_SAMPLE_PERCENTAGE, (Node)relation.getSamplePercentage(), "Sample percentage cannot contain column references", new Object[0]);
            }
            Map<NodeRef<Expression>, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(StatementAnalyzer.this.session, StatementAnalyzer.this.metadata, StatementAnalyzer.this.sqlParser, TypeProvider.empty(), relation.getSamplePercentage(), StatementAnalyzer.this.analysis.getParameters(), this.warningCollector, StatementAnalyzer.this.analysis.isDescribe());
            ExpressionInterpreter samplePercentageEval = ExpressionInterpreter.expressionOptimizer(relation.getSamplePercentage(), StatementAnalyzer.this.metadata, StatementAnalyzer.this.session, expressionTypes);
            Object samplePercentageObject = samplePercentageEval.optimize(symbol -> {
                throw new SemanticException(SemanticErrorCode.NON_NUMERIC_SAMPLE_PERCENTAGE, (Node)relation.getSamplePercentage(), "Sample percentage cannot contain column references", new Object[0]);
            });
            if (!(samplePercentageObject instanceof Number)) {
                throw new SemanticException(SemanticErrorCode.NON_NUMERIC_SAMPLE_PERCENTAGE, (Node)relation.getSamplePercentage(), "Sample percentage should evaluate to a numeric expression", new Object[0]);
            }
            double samplePercentageValue = ((Number)samplePercentageObject).doubleValue();
            if (samplePercentageValue < 0.0) {
                throw new SemanticException(SemanticErrorCode.SAMPLE_PERCENTAGE_OUT_OF_RANGE, (Node)relation.getSamplePercentage(), "Sample percentage must be greater than or equal to 0", new Object[0]);
            }
            if (samplePercentageValue > 100.0) {
                throw new SemanticException(SemanticErrorCode.SAMPLE_PERCENTAGE_OUT_OF_RANGE, (Node)relation.getSamplePercentage(), "Sample percentage must be less than or equal to 100", new Object[0]);
            }
            StatementAnalyzer.this.analysis.setSampleRatio(relation, samplePercentageValue / 100.0);
            Scope relationScope = this.process((Node)relation.getRelation(), scope);
            return this.createAndAssignScope((Node)relation, scope, relationScope.getRelationType());
        }

        protected Scope visitTableSubquery(TableSubquery node, Optional<Scope> scope) {
            StatementAnalyzer analyzer = new StatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.metadata, StatementAnalyzer.this.sqlParser, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session, this.warningCollector);
            Scope queryScope = analyzer.analyze((Node)node.getQuery(), scope);
            return this.createAndAssignScope((Node)node, scope, queryScope.getRelationType());
        }

        protected Scope visitQuerySpecification(QuerySpecification node, Optional<Scope> scope) {
            Scope sourceScope = this.analyzeFrom(node, scope);
            node.getWhere().ifPresent(where -> this.analyzeWhere((Node)node, sourceScope, (Expression)where));
            List<Expression> outputExpressions = this.analyzeSelect(node, sourceScope);
            List<Expression> groupByExpressions = this.analyzeGroupBy(node, sourceScope, outputExpressions);
            this.analyzeHaving(node, sourceScope);
            Scope outputScope = this.computeAndAssignOutputScope(node, scope, sourceScope);
            List<Expression> orderByExpressions = Collections.emptyList();
            Optional<Object> orderByScope = Optional.empty();
            if (node.getOrderBy().isPresent()) {
                if (node.getSelect().isDistinct()) {
                    this.verifySelectDistinct(node, outputExpressions);
                }
                OrderBy orderBy = (OrderBy)node.getOrderBy().get();
                orderByScope = Optional.of(this.computeAndAssignOrderByScope(orderBy, sourceScope, outputScope));
                orderByExpressions = this.analyzeOrderBy((Node)node, orderBy.getSortItems(), (Scope)orderByScope.get());
                if (sourceScope.getOuterQueryParent().isPresent() && !node.getLimit().isPresent()) {
                    StatementAnalyzer.this.analysis.markRedundantOrderBy(orderBy);
                    this.warningCollector.add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.REDUNDANT_ORDER_BY, "ORDER BY in subquery may have no effect"));
                }
            }
            if (node.getOffset().isPresent()) {
                this.analyzeOffset((Offset)node.getOffset().get());
            }
            StatementAnalyzer.this.analysis.setOrderByExpressions((Node)node, orderByExpressions);
            ArrayList<Expression> sourceExpressions = new ArrayList<Expression>(outputExpressions);
            node.getHaving().ifPresent(sourceExpressions::add);
            this.analyzeGroupingOperations(node, sourceExpressions, orderByExpressions);
            List<FunctionCall> aggregates = this.analyzeAggregations(node, sourceExpressions, orderByExpressions);
            if (!aggregates.isEmpty() && groupByExpressions.isEmpty()) {
                StatementAnalyzer.this.analysis.setGroupByExpressions(node, (List<Expression>)ImmutableList.of());
            }
            this.verifyAggregations(node, sourceScope, orderByScope, groupByExpressions, sourceExpressions, orderByExpressions);
            this.analyzeWindowFunctions(node, outputExpressions, orderByExpressions);
            if (StatementAnalyzer.this.analysis.isAggregation(node) && node.getOrderBy().isPresent()) {
                List<GroupingOperation> orderByGroupingOperations = ExpressionTreeUtils.extractExpressions(orderByExpressions, GroupingOperation.class);
                List<FunctionCall> orderByAggregations = ExpressionTreeUtils.extractAggregateFunctions(StatementAnalyzer.this.analysis.getFunctionHandles(), orderByExpressions, StatementAnalyzer.this.metadata.getFunctionAndTypeManager());
                this.computeAndAssignOrderByScopeWithAggregation((OrderBy)node.getOrderBy().get(), sourceScope, outputScope, orderByAggregations, groupByExpressions, orderByGroupingOperations);
            }
            return outputScope;
        }

        protected Scope visitSetOperation(SetOperation node, Optional<Scope> scope) {
            int i;
            Preconditions.checkState((node.getRelations().size() >= 2 ? 1 : 0) != 0);
            List relationScopes = (List)node.getRelations().stream().map(relation -> {
                Scope relationScope = this.process((Node)relation, scope);
                return this.createAndAssignScope((Node)relation, scope, relationScope.getRelationType().withOnlyVisibleFields());
            }).collect(ImmutableList.toImmutableList());
            Type[] outputFieldTypes = (Type[])((Scope)relationScopes.get(0)).getRelationType().getVisibleFields().stream().map(Field::getType).toArray(Type[]::new);
            int outputFieldSize = outputFieldTypes.length;
            if (this.isExpensiveUnionDistinct(node, outputFieldTypes)) {
                this.warningCollector.add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.PERFORMANCE_WARNING, String.format("UNION DISTINCT query should consider avoiding double/real/complex types and reducing the number of visible fields (%d) to %d", outputFieldSize, 3)));
            }
            for (Scope relationScope : relationScopes) {
                RelationType relationType = relationScope.getRelationType();
                int descFieldSize = relationType.getVisibleFields().size();
                String setOperationName = node.getClass().getSimpleName().toUpperCase(Locale.ENGLISH);
                if (outputFieldSize != descFieldSize) {
                    throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, (Node)node, "%s query has different number of fields: %d, %d", setOperationName, outputFieldSize, descFieldSize);
                }
                for (int i2 = 0; i2 < descFieldSize; ++i2) {
                    Type descFieldType = relationType.getFieldByIndex(i2).getType();
                    Optional<Type> commonSuperType = StatementAnalyzer.this.metadata.getFunctionAndTypeManager().getCommonSuperType(outputFieldTypes[i2], descFieldType);
                    if (!commonSuperType.isPresent()) {
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "column %d in %s query has incompatible types: %s, %s", i2 + 1, setOperationName, outputFieldTypes[i2].getDisplayName(), descFieldType.getDisplayName());
                    }
                    outputFieldTypes[i2] = commonSuperType.get();
                }
            }
            Field[] outputDescriptorFields = new Field[outputFieldTypes.length];
            RelationType firstDescriptor = ((Scope)relationScopes.get(0)).getRelationType().withOnlyVisibleFields();
            for (i = 0; i < outputFieldTypes.length; ++i) {
                Field oldField = firstDescriptor.getFieldByIndex(i);
                outputDescriptorFields[i] = new Field(oldField.getRelationAlias(), oldField.getName(), outputFieldTypes[i], oldField.isHidden(), oldField.getOriginTable(), oldField.getOriginColumnName(), oldField.isAliased());
            }
            block3: for (i = 0; i < node.getRelations().size(); ++i) {
                Relation relation2 = (Relation)node.getRelations().get(i);
                Scope relationScope = (Scope)relationScopes.get(i);
                RelationType relationType = relationScope.getRelationType();
                for (int j = 0; j < relationType.getVisibleFields().size(); ++j) {
                    Type outputFieldType = outputFieldTypes[j];
                    Type descFieldType = relationType.getFieldByIndex(j).getType();
                    if (outputFieldType.equals(descFieldType)) continue;
                    StatementAnalyzer.this.analysis.addRelationCoercion(relation2, outputFieldTypes);
                    continue block3;
                }
            }
            return this.createAndAssignScope((Node)node, scope, outputDescriptorFields);
        }

        private boolean isExpensiveUnionDistinct(SetOperation setOperation, Type[] outputTypes) {
            return setOperation instanceof Union && setOperation.isDistinct().orElse(false) != false && outputTypes.length > 3 && Arrays.stream(outputTypes).anyMatch(type -> type instanceof RealType || type instanceof DoubleType || type instanceof MapType || type instanceof ArrayType || type instanceof RowType);
        }

        protected Scope visitUnion(Union node, Optional<Scope> scope) {
            if (!node.isDistinct().isPresent()) {
                this.warningCollector.add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.PERFORMANCE_WARNING, "UNION specified without ALL or DISTINCT keyword is equivalent to UNION DISTINCT, which is computationally expensive. Consider using UNION ALL when possible, or specifically add the keyword DISTINCT if absolutely necessary"));
            }
            return this.visitSetOperation((SetOperation)node, scope);
        }

        protected Scope visitIntersect(Intersect node, Optional<Scope> scope) {
            if (!node.isDistinct().orElse(true).booleanValue()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "INTERSECT ALL not yet implemented", new Object[0]);
            }
            return this.visitSetOperation((SetOperation)node, scope);
        }

        protected Scope visitExcept(Except node, Optional<Scope> scope) {
            if (!node.isDistinct().orElse(true).booleanValue()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "EXCEPT ALL not yet implemented", new Object[0]);
            }
            return this.visitSetOperation((SetOperation)node, scope);
        }

        protected Scope visitJoin(Join node, Optional<Scope> scope) {
            ExpressionAnalysis expressionAnalysis;
            Expression expression;
            JoinCriteria criteria = node.getCriteria().orElse(null);
            if (criteria instanceof NaturalJoin) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Natural join not supported", new Object[0]);
            }
            Scope left = this.process((Node)node.getLeft(), scope);
            Scope right = this.process((Node)node.getRight(), this.isLateralRelation(node.getRight()) ? Optional.of(left) : scope);
            if (criteria instanceof JoinUsing) {
                return this.analyzeJoinUsing(node, ((JoinUsing)criteria).getColumns(), scope, left, right);
            }
            Scope output = this.createAndAssignScope((Node)node, scope, left.getRelationType().joinWith(right.getRelationType()));
            if (node.getType() == Join.Type.CROSS || node.getType() == Join.Type.IMPLICIT) {
                return output;
            }
            if (criteria instanceof JoinOn) {
                expression = ((JoinOn)criteria).getExpression();
                expressionAnalysis = this.analyzeExpression(expression, output);
                Type clauseType = expressionAnalysis.getType(expression);
                if (!clauseType.equals(BooleanType.BOOLEAN)) {
                    if (!clauseType.equals(UnknownType.UNKNOWN)) {
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)expression, "JOIN ON clause must evaluate to a boolean: actual type %s", clauseType);
                    }
                    StatementAnalyzer.this.analysis.addCoercion(expression, (Type)BooleanType.BOOLEAN, false);
                }
                if (expression instanceof LogicalBinaryExpression && ((LogicalBinaryExpression)expression).getOperator() == LogicalBinaryExpression.Operator.OR) {
                    String warningMessage = this.createWarningMessage((Node)expression, "JOIN conditions with an OR can cause performance issues as it may lead to a cross join with filter");
                    this.warningCollector.add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.PERFORMANCE_WARNING, warningMessage));
                }
            } else {
                throw new UnsupportedOperationException("unsupported join criteria: " + criteria.getClass().getName());
            }
            Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.analysis.getFunctionHandles(), StatementAnalyzer.this.metadata.getFunctionAndTypeManager(), expression, "JOIN clause");
            StatementAnalyzer.this.analysis.recordSubqueries((Node)node, expressionAnalysis);
            StatementAnalyzer.this.analysis.setJoinCriteria(node, expression);
            return output;
        }

        private String createWarningMessage(Node node, String description) {
            NodeLocation nodeLocation = (NodeLocation)node.getLocation().get();
            return String.format("line %s:%s: %s", nodeLocation.getLineNumber(), nodeLocation.getColumnNumber(), description);
        }

        private Scope analyzeJoinUsing(Join node, List<Identifier> columns, Optional<Scope> scope, Scope left, Scope right) {
            ArrayList<Field> joinFields = new ArrayList<Field>();
            ArrayList<Integer> leftJoinFields = new ArrayList<Integer>();
            ArrayList<Integer> rightJoinFields = new ArrayList<Integer>();
            HashSet<Identifier> seen = new HashSet<Identifier>();
            for (Identifier column : columns) {
                if (!seen.add(column)) {
                    throw new SemanticException(SemanticErrorCode.DUPLICATE_COLUMN_NAME, (Node)column, "Column '%s' appears multiple times in USING clause", column.getValue());
                }
                Optional<ResolvedField> leftField = left.tryResolveField((Expression)column);
                Optional<ResolvedField> rightField = right.tryResolveField((Expression)column);
                if (!leftField.isPresent()) {
                    throw new SemanticException(SemanticErrorCode.MISSING_ATTRIBUTE, (Node)column, "Column '%s' is missing from left side of join", column.getValue());
                }
                if (!rightField.isPresent()) {
                    throw new SemanticException(SemanticErrorCode.MISSING_ATTRIBUTE, (Node)column, "Column '%s' is missing from right side of join", column.getValue());
                }
                try {
                    StatementAnalyzer.this.metadata.getFunctionAndTypeManager().resolveOperator(OperatorType.EQUAL, TypeSignatureProvider.fromTypes(leftField.get().getType(), rightField.get().getType()));
                }
                catch (OperatorNotFoundException e) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)column, "%s", e.getMessage());
                }
                Optional<Type> type = StatementAnalyzer.this.metadata.getFunctionAndTypeManager().getCommonSuperType(leftField.get().getType(), rightField.get().getType());
                StatementAnalyzer.this.analysis.addTypes((Map<NodeRef<Expression>, Type>)ImmutableMap.of((Object)NodeRef.of((Node)column), (Object)type.get()));
                joinFields.add(Field.newUnqualified(column.getValue(), type.get()));
                leftJoinFields.add(leftField.get().getRelationFieldIndex());
                rightJoinFields.add(rightField.get().getRelationFieldIndex());
                StatementAnalyzer.this.analysis.addColumnReference((NodeRef<Expression>)NodeRef.of((Node)column), FieldId.from(leftField.get()));
                StatementAnalyzer.this.analysis.addColumnReference((NodeRef<Expression>)NodeRef.of((Node)column), FieldId.from(rightField.get()));
                if (leftField.get().getField().getOriginTable().isPresent() && leftField.get().getField().getOriginColumnName().isPresent()) {
                    StatementAnalyzer.this.analysis.addTableColumnReferences(StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session.getIdentity(), (Multimap<QualifiedObjectName, String>)ImmutableMultimap.of((Object)leftField.get().getField().getOriginTable().get(), (Object)leftField.get().getField().getOriginColumnName().get()));
                }
                if (!rightField.get().getField().getOriginTable().isPresent() || !rightField.get().getField().getOriginColumnName().isPresent()) continue;
                StatementAnalyzer.this.analysis.addTableColumnReferences(StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session.getIdentity(), (Multimap<QualifiedObjectName, String>)ImmutableMultimap.of((Object)rightField.get().getField().getOriginTable().get(), (Object)rightField.get().getField().getOriginColumnName().get()));
            }
            ImmutableList.Builder outputs = ImmutableList.builder();
            outputs.addAll(joinFields);
            ImmutableList.Builder leftFields = ImmutableList.builder();
            for (int i = 0; i < left.getRelationType().getAllFieldCount(); ++i) {
                if (leftJoinFields.contains(i)) continue;
                outputs.add((Object)left.getRelationType().getFieldByIndex(i));
                leftFields.add((Object)i);
            }
            ImmutableList.Builder rightFields = ImmutableList.builder();
            for (int i = 0; i < right.getRelationType().getAllFieldCount(); ++i) {
                if (rightJoinFields.contains(i)) continue;
                outputs.add((Object)right.getRelationType().getFieldByIndex(i));
                rightFields.add((Object)i);
            }
            StatementAnalyzer.this.analysis.setJoinUsing(node, new Analysis.JoinUsingAnalysis(leftJoinFields, rightJoinFields, (List<Integer>)leftFields.build(), (List<Integer>)rightFields.build()));
            return this.createAndAssignScope((Node)node, scope, new RelationType((List<Field>)outputs.build()));
        }

        private boolean isLateralRelation(Relation node) {
            if (node instanceof AliasedRelation) {
                return this.isLateralRelation(((AliasedRelation)node).getRelation());
            }
            return node instanceof Unnest || node instanceof Lateral;
        }

        protected Scope visitValues(Values node, Optional<Scope> scope) {
            Preconditions.checkState((node.getRows().size() >= 1 ? 1 : 0) != 0);
            List rowTypes = (List)node.getRows().stream().map(row -> this.analyzeExpression((Expression)row, this.createScope(scope)).getType((Expression)row)).map(type -> {
                if (type instanceof RowType) {
                    return type.getTypeParameters();
                }
                return ImmutableList.of((Object)type);
            }).collect(ImmutableList.toImmutableList());
            ArrayList<Type> fieldTypes = new ArrayList<Type>((Collection)rowTypes.iterator().next());
            for (List rowType : rowTypes) {
                if (rowType.size() != fieldTypes.size()) {
                    throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, (Node)node, "Values rows have mismatched types: %s vs %s", rowTypes.get(0), rowType);
                }
                for (int i = 0; i < rowType.size(); ++i) {
                    Type fieldType = (Type)rowType.get(i);
                    Type superType = (Type)fieldTypes.get(i);
                    Optional<Type> commonSuperType = StatementAnalyzer.this.metadata.getFunctionAndTypeManager().getCommonSuperType(fieldType, superType);
                    if (!commonSuperType.isPresent()) {
                        throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, (Node)node, "Values rows have mismatched types: %s vs %s", rowTypes.get(0), rowType);
                    }
                    fieldTypes.set(i, commonSuperType.get());
                }
            }
            for (Expression row2 : node.getRows()) {
                Type expectedType;
                if (row2 instanceof Row) {
                    List items = ((Row)row2).getItems();
                    for (int i = 0; i < items.size(); ++i) {
                        Type expectedType2 = (Type)fieldTypes.get(i);
                        Expression item = (Expression)items.get(i);
                        Type actualType = StatementAnalyzer.this.analysis.getType(item);
                        if (actualType.equals(expectedType2)) continue;
                        StatementAnalyzer.this.analysis.addCoercion(item, expectedType2, StatementAnalyzer.this.metadata.getFunctionAndTypeManager().isTypeOnlyCoercion(actualType, expectedType2));
                    }
                    continue;
                }
                Type actualType = StatementAnalyzer.this.analysis.getType(row2);
                if (actualType.equals(expectedType = (Type)fieldTypes.get(0))) continue;
                StatementAnalyzer.this.analysis.addCoercion(row2, expectedType, StatementAnalyzer.this.metadata.getFunctionAndTypeManager().isTypeOnlyCoercion(actualType, expectedType));
            }
            List fields = (List)fieldTypes.stream().map(valueType -> Field.newUnqualified(Optional.empty(), valueType)).collect(ImmutableList.toImmutableList());
            return this.createAndAssignScope((Node)node, scope, fields);
        }

        private void analyzeWindowFunctions(QuerySpecification node, List<Expression> outputExpressions, List<Expression> orderByExpressions) {
            StatementAnalyzer.this.analysis.setWindowFunctions(node, this.analyzeWindowFunctions(node, outputExpressions));
            if (node.getOrderBy().isPresent()) {
                StatementAnalyzer.this.analysis.setOrderByWindowFunctions((OrderBy)node.getOrderBy().get(), this.analyzeWindowFunctions(node, orderByExpressions));
            }
        }

        private List<FunctionCall> analyzeWindowFunctions(QuerySpecification node, List<Expression> expressions) {
            for (Expression expression : expressions) {
                new WindowFunctionValidator(StatementAnalyzer.this.metadata.getFunctionAndTypeManager()).process((Node)expression, StatementAnalyzer.this.analysis);
            }
            List<FunctionCall> windowFunctions = ExpressionTreeUtils.extractWindowFunctions(expressions);
            for (FunctionCall windowFunction : windowFunctions) {
                FunctionKind kind;
                if (windowFunction.getFilter().isPresent()) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "FILTER is not yet supported for window functions", new Object[0]);
                }
                if (windowFunction.getOrderBy().isPresent()) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)windowFunction, "Window function with ORDER BY is not supported", new Object[0]);
                }
                Window window = (Window)windowFunction.getWindow().get();
                if (window.getOrderBy().filter(orderBy -> orderBy.getSortItems().stream().anyMatch(item -> item.getSortKey() instanceof Literal)).isPresent()) {
                    if (SystemSessionProperties.isAllowWindowOrderByLiterals(StatementAnalyzer.this.session)) {
                        this.warningCollector.add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.PERFORMANCE_WARNING, String.format("ORDER BY literals/constants with window function: '%s' is unnecessary and expensive. If you intend to ORDER BY using ordinals, please use the actual expression instead of the ordinal", windowFunction)));
                    } else {
                        throw new SemanticException(SemanticErrorCode.WINDOW_FUNCTION_ORDERBY_LITERAL, (Node)node, "ORDER BY literals/constants with window function: '%s' is unnecessary and expensive. If you intend to ORDER BY using ordinals, please use the actual expression instead of the ordinal", windowFunction);
                    }
                }
                ImmutableList.Builder toExtract = ImmutableList.builder();
                toExtract.addAll((Iterable)windowFunction.getArguments());
                toExtract.addAll((Iterable)window.getPartitionBy());
                window.getOrderBy().ifPresent(orderBy -> toExtract.addAll((Iterable)orderBy.getSortItems()));
                window.getFrame().ifPresent(arg_0 -> ((ImmutableList.Builder)toExtract).add(arg_0));
                List<FunctionCall> nestedWindowFunctions = ExpressionTreeUtils.extractWindowFunctions((Iterable<? extends Node>)toExtract.build());
                if (!nestedWindowFunctions.isEmpty()) {
                    throw new SemanticException(SemanticErrorCode.NESTED_WINDOW, (Node)node, "Cannot nest window functions inside window function '%s': %s", windowFunction, windowFunctions);
                }
                if (windowFunction.isDistinct()) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "DISTINCT in window function parameters not yet supported: %s", windowFunction);
                }
                if (window.getFrame().isPresent()) {
                    this.analyzeWindowFrame((WindowFrame)window.getFrame().get());
                }
                if ((kind = StatementAnalyzer.this.metadata.getFunctionAndTypeManager().getFunctionMetadata(StatementAnalyzer.this.analysis.getFunctionHandle(windowFunction)).getFunctionKind()) == FunctionKind.AGGREGATE || kind == FunctionKind.WINDOW) continue;
                throw new SemanticException(SemanticErrorCode.MUST_BE_WINDOW_FUNCTION, (Node)node, "Not a window function: %s", windowFunction.getName());
            }
            return windowFunctions;
        }

        private void analyzeWindowFrame(WindowFrame frame) {
            FrameBound.Type startType = frame.getStart().getType();
            FrameBound.Type endType = frame.getEnd().orElse(new FrameBound(FrameBound.Type.CURRENT_ROW)).getType();
            if (startType == FrameBound.Type.UNBOUNDED_FOLLOWING) {
                throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame start cannot be UNBOUNDED FOLLOWING", new Object[0]);
            }
            if (endType == FrameBound.Type.UNBOUNDED_PRECEDING) {
                throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame end cannot be UNBOUNDED PRECEDING", new Object[0]);
            }
            if (startType == FrameBound.Type.CURRENT_ROW && endType == FrameBound.Type.PRECEDING) {
                throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame starting from CURRENT ROW cannot end with PRECEDING", new Object[0]);
            }
            if (startType == FrameBound.Type.FOLLOWING && endType == FrameBound.Type.PRECEDING) {
                throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame starting from FOLLOWING cannot end with PRECEDING", new Object[0]);
            }
            if (startType == FrameBound.Type.FOLLOWING && endType == FrameBound.Type.CURRENT_ROW) {
                throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame starting from FOLLOWING cannot end with CURRENT ROW", new Object[0]);
            }
            if (frame.getType() == WindowFrame.Type.RANGE && (startType == FrameBound.Type.PRECEDING || endType == FrameBound.Type.PRECEDING)) {
                throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame RANGE PRECEDING is only supported with UNBOUNDED", new Object[0]);
            }
            if (frame.getType() == WindowFrame.Type.RANGE && (startType == FrameBound.Type.FOLLOWING || endType == FrameBound.Type.FOLLOWING)) {
                throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame RANGE FOLLOWING is only supported with UNBOUNDED", new Object[0]);
            }
        }

        private void analyzeHaving(QuerySpecification node, Scope scope) {
            if (node.getHaving().isPresent()) {
                Expression predicate = (Expression)node.getHaving().get();
                ExpressionAnalysis expressionAnalysis = this.analyzeExpression(predicate, scope);
                expressionAnalysis.getWindowFunctions().stream().findFirst().ifPresent(function -> {
                    throw new SemanticException(SemanticErrorCode.NESTED_WINDOW, function.getNode(), "HAVING clause cannot contain window functions", new Object[0]);
                });
                StatementAnalyzer.this.analysis.recordSubqueries((Node)node, expressionAnalysis);
                Type predicateType = expressionAnalysis.getType(predicate);
                if (!predicateType.equals(BooleanType.BOOLEAN) && !predicateType.equals(UnknownType.UNKNOWN)) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)predicate, "HAVING clause must evaluate to a boolean: actual type %s", predicateType);
                }
                StatementAnalyzer.this.analysis.setHaving(node, predicate);
            }
        }

        private Multimap<QualifiedName, Expression> extractNamedOutputExpressions(Select node) {
            ImmutableMultimap.Builder assignments = ImmutableMultimap.builder();
            for (SelectItem item : node.getSelectItems()) {
                if (!(item instanceof SingleColumn)) continue;
                SingleColumn column = (SingleColumn)item;
                Optional alias = column.getAlias();
                if (alias.isPresent()) {
                    assignments.put((Object)QualifiedName.of((String)((Identifier)alias.get()).getValue()), (Object)column.getExpression());
                    continue;
                }
                if (!(column.getExpression() instanceof Identifier)) continue;
                assignments.put((Object)QualifiedName.of((String)((Identifier)column.getExpression()).getValue()), (Object)column.getExpression());
            }
            return assignments.build();
        }

        private void checkFunctionName(Statement node, QualifiedName functionName, boolean isTemporary) {
            if (isTemporary) {
                if (functionName.getParts().size() != 1) {
                    throw new SemanticException(SemanticErrorCode.INVALID_FUNCTION_NAME, (Node)node, "Temporary functions cannot be qualified.", new Object[0]);
                }
                List builtInFunctionNames = StatementAnalyzer.this.metadata.getFunctionAndTypeManager().listBuiltInFunctions().stream().map(SqlFunction::getSignature).map(Signature::getName).map(QualifiedObjectName::getObjectName).collect(Collectors.toList());
                if (builtInFunctionNames.contains(functionName.toString())) {
                    throw new SemanticException(SemanticErrorCode.INVALID_FUNCTION_NAME, (Node)node, String.format("Function %s is already registered as a built-in function.", functionName), new Object[0]);
                }
            } else if (functionName.getParts().size() != 3) {
                throw new SemanticException(SemanticErrorCode.INVALID_FUNCTION_NAME, (Node)node, String.format("Function name should be in the form of catalog.schema.function_name, found: %s", functionName), new Object[0]);
            }
        }

        private void checkGroupingSetsCount(GroupBy node) {
            int crossProduct = 1;
            for (GroupingElement element : node.getGroupingElements()) {
                try {
                    int product;
                    if (element instanceof SimpleGroupBy) {
                        product = 1;
                    } else if (element instanceof Cube) {
                        int exponent = element.getExpressions().size();
                        if (exponent > 30) {
                            throw new ArithmeticException();
                        }
                        product = 1 << exponent;
                    } else if (element instanceof Rollup) {
                        product = element.getExpressions().size() + 1;
                    } else if (element instanceof GroupingSets) {
                        product = ((GroupingSets)element).getSets().size();
                    } else {
                        throw new UnsupportedOperationException("Unsupported grouping element type: " + element.getClass().getName());
                    }
                    crossProduct = Math.multiplyExact(crossProduct, product);
                }
                catch (ArithmeticException e) {
                    throw new SemanticException(SemanticErrorCode.TOO_MANY_GROUPING_SETS, (Node)node, "GROUP BY has more than %s grouping sets but can contain at most %s", Integer.MAX_VALUE, SystemSessionProperties.getMaxGroupingSets(StatementAnalyzer.this.session));
                }
                if (crossProduct <= SystemSessionProperties.getMaxGroupingSets(StatementAnalyzer.this.session)) continue;
                throw new SemanticException(SemanticErrorCode.TOO_MANY_GROUPING_SETS, (Node)node, "GROUP BY has %s grouping sets but can contain at most %s", crossProduct, SystemSessionProperties.getMaxGroupingSets(StatementAnalyzer.this.session));
            }
        }

        private List<Expression> analyzeGroupBy(QuerySpecification node, Scope scope, List<Expression> outputExpressions) {
            if (node.getGroupBy().isPresent()) {
                ImmutableList.Builder cubes = ImmutableList.builder();
                ImmutableList.Builder rollups = ImmutableList.builder();
                ImmutableList.Builder sets = ImmutableList.builder();
                ImmutableList.Builder complexExpressions = ImmutableList.builder();
                ImmutableList.Builder groupingExpressions = ImmutableList.builder();
                this.checkGroupingSetsCount((GroupBy)node.getGroupBy().get());
                for (GroupingElement groupingElement : ((GroupBy)node.getGroupBy().get()).getGroupingElements()) {
                    if (groupingElement instanceof SimpleGroupBy) {
                        for (Expression column : groupingElement.getExpressions()) {
                            if (column instanceof LongLiteral) {
                                long ordinal = ((LongLiteral)column).getValue();
                                if (ordinal < 1L || ordinal > (long)outputExpressions.size()) {
                                    throw new SemanticException(SemanticErrorCode.INVALID_ORDINAL, (Node)column, "GROUP BY position %s is not in select list", ordinal);
                                }
                                column = outputExpressions.get(Math.toIntExact(ordinal - 1L));
                            } else {
                                this.analyzeExpression(column, scope);
                            }
                            if (StatementAnalyzer.this.analysis.getColumnReferenceFields().containsKey((Object)NodeRef.of((Node)column))) {
                                sets.add((Object)ImmutableList.of((Object)ImmutableSet.copyOf((Collection)StatementAnalyzer.this.analysis.getColumnReferenceFields().get((Object)NodeRef.of((Node)column)))));
                            } else {
                                Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.analysis.getFunctionHandles(), StatementAnalyzer.this.metadata.getFunctionAndTypeManager(), column, "GROUP BY clause");
                                StatementAnalyzer.this.analysis.recordSubqueries((Node)node, this.analyzeExpression(column, scope));
                                complexExpressions.add((Object)column);
                            }
                            groupingExpressions.add((Object)column);
                        }
                        continue;
                    }
                    for (Expression column : groupingElement.getExpressions()) {
                        this.analyzeExpression(column, scope);
                        if (!StatementAnalyzer.this.analysis.getColumnReferences().contains(NodeRef.of((Node)column))) {
                            throw new SemanticException(SemanticErrorCode.MUST_BE_COLUMN_REFERENCE, (Node)column, "GROUP BY expression must be a column reference: %s", column);
                        }
                        groupingExpressions.add((Object)column);
                    }
                    if (groupingElement instanceof Cube) {
                        Set cube = (Set)groupingElement.getExpressions().stream().map(NodeRef::of).map(arg_0 -> StatementAnalyzer.this.analysis.getColumnReferenceFields().get(arg_0)).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
                        cubes.add((Object)cube);
                        continue;
                    }
                    if (groupingElement instanceof Rollup) {
                        List rollup = (List)groupingElement.getExpressions().stream().map(NodeRef::of).map(arg_0 -> StatementAnalyzer.this.analysis.getColumnReferenceFields().get(arg_0)).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
                        rollups.add((Object)rollup);
                        continue;
                    }
                    if (!(groupingElement instanceof GroupingSets)) continue;
                    List groupingSets = (List)((GroupingSets)groupingElement).getSets().stream().map(set -> (ImmutableSet)set.stream().map(NodeRef::of).map(arg_0 -> StatementAnalyzer.this.analysis.getColumnReferenceFields().get(arg_0)).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet())).collect(ImmutableList.toImmutableList());
                    sets.add((Object)groupingSets);
                }
                ImmutableList expressions = groupingExpressions.build();
                for (Expression expression : expressions) {
                    Type type = StatementAnalyzer.this.analysis.getType(expression);
                    if (type.isComparable()) continue;
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "%s is not comparable, and therefore cannot be used in GROUP BY", type);
                }
                StatementAnalyzer.this.analysis.setGroupByExpressions(node, (List<Expression>)expressions);
                StatementAnalyzer.this.analysis.setGroupingSets(node, new Analysis.GroupingSetAnalysis((List<Set<FieldId>>)cubes.build(), (List<List<FieldId>>)rollups.build(), (List<List<Set<FieldId>>>)sets.build(), (List<Expression>)complexExpressions.build()));
                return expressions;
            }
            return ImmutableList.of();
        }

        /*
         * WARNING - void declaration
         */
        private Scope computeAndAssignOutputScope(QuerySpecification node, Optional<Scope> scope, Scope sourceScope) {
            ImmutableList.Builder outputFields = ImmutableList.builder();
            for (SelectItem item : node.getSelect().getSelectItems()) {
                if (item instanceof AllColumns) {
                    Optional starPrefix = ((AllColumns)item).getPrefix();
                    for (Field field : sourceScope.getRelationType().resolveFieldsWithPrefix(starPrefix)) {
                        outputFields.add((Object)Field.newUnqualified(field.getName(), field.getType(), field.getOriginTable(), field.getOriginColumnName(), false));
                    }
                    continue;
                }
                if (item instanceof SingleColumn) {
                    void var9_13;
                    List<Field> matchingFields;
                    SingleColumn column = (SingleColumn)item;
                    Expression expression = column.getExpression();
                    Optional optional = column.getAlias();
                    Optional<QualifiedObjectName> originTable = Optional.empty();
                    Optional<String> originColumn = Optional.empty();
                    QualifiedName name = null;
                    if (expression instanceof Identifier) {
                        name = QualifiedName.of((String)((Identifier)expression).getValue());
                    } else if (expression instanceof DereferenceExpression) {
                        name = DereferenceExpression.getQualifiedName((DereferenceExpression)((DereferenceExpression)expression));
                    }
                    if (name != null && !(matchingFields = sourceScope.getRelationType().resolveFields(name)).isEmpty()) {
                        originTable = matchingFields.get(0).getOriginTable();
                        originColumn = matchingFields.get(0).getOriginColumnName();
                    }
                    if (!optional.isPresent() && name != null) {
                        Optional<Identifier> optional2 = Optional.of(new Identifier((String)Iterables.getLast((Iterable)name.getOriginalParts())));
                    }
                    outputFields.add((Object)Field.newUnqualified(var9_13.map(Identifier::getValue), StatementAnalyzer.this.analysis.getType(expression), originTable, originColumn, column.getAlias().isPresent()));
                    continue;
                }
                throw new IllegalArgumentException("Unsupported SelectItem type: " + item.getClass().getName());
            }
            return this.createAndAssignScope((Node)node, scope, (List<Field>)outputFields.build());
        }

        private Scope computeAndAssignOrderByScope(OrderBy node, Scope sourceScope, Scope outputScope) {
            Scope orderByScope = Scope.builder().withParent(sourceScope).withRelationType(outputScope.getRelationId(), outputScope.getRelationType()).build();
            StatementAnalyzer.this.analysis.setScope((Node)node, orderByScope);
            return orderByScope;
        }

        private Scope computeAndAssignOrderByScopeWithAggregation(OrderBy node, Scope sourceScope, Scope outputScope, List<FunctionCall> aggregations, List<Expression> groupByExpressions, List<GroupingOperation> groupingOperations) {
            ImmutableList.Builder orderByAggregationExpressionsBuilder = ImmutableList.builder().addAll(groupByExpressions).addAll(aggregations).addAll(groupingOperations);
            List orderByExpressionsReferencingOutputScope = (List)AstUtils.preOrder((Node)node).filter(Expression.class::isInstance).map(Expression.class::cast).filter(expression -> ScopeReferenceExtractor.hasReferencesToScope((Node)expression, StatementAnalyzer.this.analysis, outputScope)).collect(ImmutableList.toImmutableList());
            List orderByAggregationExpressions = (List)orderByAggregationExpressionsBuilder.build().stream().filter(expression -> !orderByExpressionsReferencingOutputScope.contains(expression) || StatementAnalyzer.this.analysis.isColumnReference((Expression)expression)).collect(ImmutableList.toImmutableList());
            HashSet seen = new HashSet();
            List orderByAggregationSourceFields = (List)orderByAggregationExpressions.stream().map(expression -> {
                Optional<Field> sourceField = sourceScope.tryResolveField((Expression)expression).filter(resolvedField -> seen.add(resolvedField.getField())).map(ResolvedField::getField);
                return sourceField.orElse(Field.newUnqualified(Optional.empty(), StatementAnalyzer.this.analysis.getType((Expression)expression)));
            }).collect(ImmutableList.toImmutableList());
            Scope orderByAggregationScope = Scope.builder().withRelationType(RelationId.anonymous(), new RelationType(orderByAggregationSourceFields)).build();
            Scope orderByScope = Scope.builder().withParent(orderByAggregationScope).withRelationType(outputScope.getRelationId(), outputScope.getRelationType()).build();
            StatementAnalyzer.this.analysis.setScope((Node)node, orderByScope);
            StatementAnalyzer.this.analysis.setOrderByAggregates(node, orderByAggregationExpressions);
            return orderByScope;
        }

        private List<Expression> analyzeSelect(QuerySpecification node, Scope scope) {
            ImmutableList.Builder outputExpressionBuilder = ImmutableList.builder();
            for (SelectItem item : node.getSelect().getSelectItems()) {
                if (item instanceof AllColumns) {
                    Optional starPrefix = ((AllColumns)item).getPrefix();
                    RelationType relationType = scope.getRelationType();
                    List<Field> fields = relationType.resolveFieldsWithPrefix(starPrefix);
                    if (fields.isEmpty()) {
                        if (starPrefix.isPresent()) {
                            throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)item, "Table '%s' not found", starPrefix.get());
                        }
                        if (!node.getFrom().isPresent()) {
                            throw new SemanticException(SemanticErrorCode.WILDCARD_WITHOUT_FROM, (Node)item, "SELECT * not allowed in queries without FROM clause", new Object[0]);
                        }
                        throw new SemanticException(SemanticErrorCode.COLUMN_NAME_NOT_SPECIFIED, (Node)item, "SELECT * not allowed from relation that has no columns", new Object[0]);
                    }
                    for (Field field : fields) {
                        int fieldIndex = relationType.indexOf(field);
                        FieldReference expression = new FieldReference(fieldIndex);
                        outputExpressionBuilder.add((Object)expression);
                        ExpressionAnalysis expressionAnalysis = this.analyzeExpression((Expression)expression, scope);
                        Type type = expressionAnalysis.getType((Expression)expression);
                        if (!node.getSelect().isDistinct() || type.isComparable()) continue;
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getSelect(), "DISTINCT can only be applied to comparable types (actual: %s)", type);
                    }
                    continue;
                }
                if (item instanceof SingleColumn) {
                    SingleColumn column = (SingleColumn)item;
                    ExpressionAnalysis expressionAnalysis = this.analyzeExpression(column.getExpression(), scope);
                    StatementAnalyzer.this.analysis.recordSubqueries((Node)node, expressionAnalysis);
                    outputExpressionBuilder.add((Object)column.getExpression());
                    Type type = expressionAnalysis.getType(column.getExpression());
                    if (!node.getSelect().isDistinct() || type.isComparable()) continue;
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getSelect(), "DISTINCT can only be applied to comparable types (actual: %s): %s", type, column.getExpression());
                }
                throw new IllegalArgumentException("Unsupported SelectItem type: " + item.getClass().getName());
            }
            ImmutableList result = outputExpressionBuilder.build();
            StatementAnalyzer.this.analysis.setOutputExpressions((Node)node, (List<Expression>)result);
            return result;
        }

        public void analyzeWhere(Node node, Scope scope, Expression predicate) {
            ExpressionAnalysis expressionAnalysis = this.analyzeExpression(predicate, scope);
            Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.analysis.getFunctionHandles(), StatementAnalyzer.this.metadata.getFunctionAndTypeManager(), predicate, "WHERE clause");
            StatementAnalyzer.this.analysis.recordSubqueries(node, expressionAnalysis);
            Type predicateType = expressionAnalysis.getType(predicate);
            if (!predicateType.equals(BooleanType.BOOLEAN)) {
                if (!predicateType.equals(UnknownType.UNKNOWN)) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)predicate, "WHERE clause must evaluate to a boolean: actual type %s", predicateType);
                }
                StatementAnalyzer.this.analysis.addCoercion(predicate, (Type)BooleanType.BOOLEAN, false);
            }
            StatementAnalyzer.this.analysis.setWhere(node, predicate);
        }

        private Scope analyzeFrom(QuerySpecification node, Optional<Scope> scope) {
            if (node.getFrom().isPresent()) {
                return this.process((Node)node.getFrom().get(), scope);
            }
            return this.createScope(scope);
        }

        private void analyzeGroupingOperations(QuerySpecification node, List<Expression> outputExpressions, List<Expression> orderByExpressions) {
            boolean isGroupingOperationPresent;
            List<GroupingOperation> groupingOperations = ExpressionTreeUtils.extractExpressions(Iterables.concat(outputExpressions, orderByExpressions), GroupingOperation.class);
            boolean bl = isGroupingOperationPresent = !groupingOperations.isEmpty();
            if (isGroupingOperationPresent && !node.getGroupBy().isPresent()) {
                throw new SemanticException(SemanticErrorCode.INVALID_PROCEDURE_ARGUMENTS, (Node)node, "A GROUPING() operation can only be used with a corresponding GROUPING SET/CUBE/ROLLUP/GROUP BY clause", new Object[0]);
            }
            StatementAnalyzer.this.analysis.setGroupingOperations(node, groupingOperations);
        }

        private List<FunctionCall> analyzeAggregations(QuerySpecification node, List<Expression> outputExpressions, List<Expression> orderByExpressions) {
            List<FunctionCall> aggregates = ExpressionTreeUtils.extractAggregateFunctions(StatementAnalyzer.this.analysis.getFunctionHandles(), Iterables.concat(outputExpressions, orderByExpressions), StatementAnalyzer.this.metadata.getFunctionAndTypeManager());
            StatementAnalyzer.this.analysis.setAggregates(node, aggregates);
            return aggregates;
        }

        private void verifyAggregations(QuerySpecification node, Scope sourceScope, Optional<Scope> orderByScope, List<Expression> groupByExpressions, List<Expression> outputExpressions, List<Expression> orderByExpressions) {
            Preconditions.checkState((orderByExpressions.isEmpty() || orderByScope.isPresent() ? 1 : 0) != 0, (Object)"non-empty orderByExpressions list without orderByScope provided");
            if (StatementAnalyzer.this.analysis.isAggregation(node)) {
                List distinctGroupingColumns = (List)groupByExpressions.stream().distinct().collect(ImmutableList.toImmutableList());
                for (Expression expression : outputExpressions) {
                    AggregationAnalyzer.verifySourceAggregations(distinctGroupingColumns, sourceScope, expression, StatementAnalyzer.this.metadata, StatementAnalyzer.this.analysis, this.warningCollector);
                }
                for (Expression expression : orderByExpressions) {
                    AggregationAnalyzer.verifyOrderByAggregations(distinctGroupingColumns, sourceScope, orderByScope.get(), expression, StatementAnalyzer.this.metadata, StatementAnalyzer.this.analysis, this.warningCollector);
                }
            }
        }

        private RelationType analyzeView(Query query, QualifiedObjectName name, Optional<String> catalog, Optional<String> schema, Optional<String> owner, Table node) {
            try {
                AccessControl viewAccessControl;
                Identity identity;
                if (owner.isPresent() && !owner.get().equals(StatementAnalyzer.this.session.getIdentity().getUser())) {
                    identity = new Identity(owner.get(), Optional.empty());
                    viewAccessControl = new ViewAccessControl(StatementAnalyzer.this.accessControl);
                } else {
                    identity = StatementAnalyzer.this.session.getIdentity();
                    viewAccessControl = StatementAnalyzer.this.accessControl;
                }
                Session viewSession = Session.builder(StatementAnalyzer.this.metadata.getSessionPropertyManager()).setQueryId(StatementAnalyzer.this.session.getQueryId()).setTransactionId(StatementAnalyzer.this.session.getTransactionId().orElse(null)).setIdentity(identity).setSource(StatementAnalyzer.this.session.getSource().orElse(null)).setCatalog(catalog.orElse(null)).setSchema(schema.orElse(null)).setTimeZoneKey(StatementAnalyzer.this.session.getTimeZoneKey()).setLocale(StatementAnalyzer.this.session.getLocale()).setRemoteUserAddress(StatementAnalyzer.this.session.getRemoteUserAddress().orElse(null)).setUserAgent(StatementAnalyzer.this.session.getUserAgent().orElse(null)).setClientInfo(StatementAnalyzer.this.session.getClientInfo().orElse(null)).setStartTime(StatementAnalyzer.this.session.getStartTime()).build();
                StatementAnalyzer analyzer = new StatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.metadata, StatementAnalyzer.this.sqlParser, viewAccessControl, viewSession, this.warningCollector);
                Scope queryScope = analyzer.analyze((Node)query, Scope.create());
                return queryScope.getRelationType().withAlias(name.getObjectName(), null);
            }
            catch (RuntimeException e) {
                Throwables.throwIfInstanceOf((Throwable)e, PrestoException.class);
                throw new SemanticException(SemanticErrorCode.VIEW_ANALYSIS_ERROR, (Node)node, "Failed analyzing stored view '%s': %s", name, e.getMessage());
            }
        }

        private Query parseView(String view, QualifiedObjectName name, Node node) {
            try {
                return (Query)StatementAnalyzer.this.sqlParser.createStatement(view, ParsingUtil.createParsingOptions(StatementAnalyzer.this.session, this.warningCollector));
            }
            catch (ParsingException e) {
                throw new SemanticException(SemanticErrorCode.VIEW_PARSE_ERROR, node, "Failed parsing stored view '%s': %s", name, e.getMessage());
            }
        }

        private boolean isViewStale(List<ViewDefinition.ViewColumn> columns, Collection<Field> fields) {
            if (columns.size() != fields.size()) {
                return true;
            }
            ImmutableList fieldList = ImmutableList.copyOf(fields);
            for (int i = 0; i < columns.size(); ++i) {
                ViewDefinition.ViewColumn column = columns.get(i);
                Field field = (Field)fieldList.get(i);
                if (column.getName().equalsIgnoreCase(field.getName().orElse(null)) && StatementAnalyzer.this.metadata.getFunctionAndTypeManager().canCoerce(field.getType(), column.getType())) continue;
                return true;
            }
            return false;
        }

        private ExpressionAnalysis analyzeExpression(Expression expression, Scope scope) {
            return ExpressionAnalyzer.analyzeExpression(StatementAnalyzer.this.session, StatementAnalyzer.this.metadata, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.sqlParser, scope, StatementAnalyzer.this.analysis, expression, this.warningCollector);
        }

        private List<Expression> descriptorToFields(Scope scope) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int fieldIndex = 0; fieldIndex < scope.getRelationType().getAllFieldCount(); ++fieldIndex) {
                FieldReference expression = new FieldReference(fieldIndex);
                builder.add((Object)expression);
                this.analyzeExpression((Expression)expression, scope);
            }
            return builder.build();
        }

        private Scope analyzeWith(Query node, Optional<Scope> scope) {
            if (!node.getWith().isPresent()) {
                return this.createScope(scope);
            }
            With with = (With)node.getWith().get();
            if (with.isRecursive()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)with, "Recursive WITH queries are not supported", new Object[0]);
            }
            Scope.Builder withScopeBuilder = this.scopeBuilder(scope);
            for (WithQuery withQuery : with.getQueries()) {
                Query query = withQuery.getQuery();
                this.process((Node)query, withScopeBuilder.build());
                String name = withQuery.getName().getValue().toLowerCase(Locale.ENGLISH);
                if (withScopeBuilder.containsNamedQuery(name)) {
                    throw new SemanticException(SemanticErrorCode.DUPLICATE_RELATION, (Node)withQuery, "WITH query name '%s' specified more than once", name);
                }
                if (withQuery.getColumnNames().isPresent()) {
                    List columnNames = (List)withQuery.getColumnNames().get();
                    RelationType queryDescriptor = StatementAnalyzer.this.analysis.getOutputDescriptor((Node)query);
                    if (columnNames.size() != queryDescriptor.getVisibleFieldCount()) {
                        throw new SemanticException(SemanticErrorCode.MISMATCHED_COLUMN_ALIASES, (Node)withQuery, "WITH column alias list has %s entries but WITH query(%s) has %s columns", columnNames.size(), name, queryDescriptor.getVisibleFieldCount());
                    }
                }
                withScopeBuilder.withNamedQuery(name, withQuery);
            }
            Scope withScope = withScopeBuilder.build();
            StatementAnalyzer.this.analysis.setScope((Node)with, withScope);
            return withScope;
        }

        private void analyzeOffset(Offset node) {
            long rowCount;
            try {
                rowCount = Long.parseLong(node.getRowCount());
            }
            catch (NumberFormatException e) {
                throw new SemanticException(SemanticErrorCode.INVALID_OFFSET_ROW_COUNT, (Node)node, "Invalid OFFSET row count: %s", node.getRowCount());
            }
            if (rowCount < 0L) {
                throw new SemanticException(SemanticErrorCode.INVALID_OFFSET_ROW_COUNT, (Node)node, "OFFSET row count must be greater or equal to 0 (actual value: %s)", rowCount);
            }
            StatementAnalyzer.this.analysis.setOffset(node, rowCount);
        }

        private void verifySelectDistinct(QuerySpecification node, List<Expression> outputExpressions) {
            for (SortItem item : ((OrderBy)node.getOrderBy().get()).getSortItems()) {
                Expression expression = item.getSortKey();
                if (expression instanceof LongLiteral) continue;
                Expression rewrittenOrderByExpression = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new OrderByExpressionRewriter(this.extractNamedOutputExpressions(node.getSelect())), (Expression)expression);
                int index = outputExpressions.indexOf(rewrittenOrderByExpression);
                if (index == -1) {
                    throw new SemanticException(SemanticErrorCode.ORDER_BY_MUST_BE_IN_SELECT, (Node)node.getSelect(), "For SELECT DISTINCT, ORDER BY expressions must appear in select list", new Object[0]);
                }
                if (ExpressionDeterminismEvaluator.isDeterministic(expression)) continue;
                throw new SemanticException(SemanticErrorCode.NONDETERMINISTIC_ORDER_BY_EXPRESSION_WITH_SELECT_DISTINCT, (Node)expression, "Non deterministic ORDER BY expression is not supported with SELECT DISTINCT", new Object[0]);
            }
        }

        private List<Expression> analyzeOrderBy(Node node, List<SortItem> sortItems, Scope orderByScope) {
            ImmutableList.Builder orderByFieldsBuilder = ImmutableList.builder();
            for (SortItem item : sortItems) {
                Expression expression = item.getSortKey();
                if (expression instanceof LongLiteral) {
                    long ordinal = ((LongLiteral)expression).getValue();
                    if (ordinal < 1L || ordinal > (long)orderByScope.getRelationType().getVisibleFieldCount()) {
                        throw new SemanticException(SemanticErrorCode.INVALID_ORDINAL, (Node)expression, "ORDER BY position %s is not in select list", ordinal);
                    }
                    expression = new FieldReference(Math.toIntExact(ordinal - 1L));
                }
                ExpressionAnalysis expressionAnalysis = this.analyzeExpression(expression, orderByScope);
                StatementAnalyzer.this.analysis.recordSubqueries(node, expressionAnalysis);
                Type type = StatementAnalyzer.this.analysis.getType(expression);
                if (!type.isOrderable()) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, node, "Type %s is not orderable, and therefore cannot be used in ORDER BY: %s", type, expression);
                }
                orderByFieldsBuilder.add((Object)expression);
            }
            ImmutableList orderByFields = orderByFieldsBuilder.build();
            return orderByFields;
        }

        private Scope createAndAssignScope(Node node, Optional<Scope> parentScope) {
            return this.createAndAssignScope(node, parentScope, Collections.emptyList());
        }

        private Scope createAndAssignScope(Node node, Optional<Scope> parentScope, Field ... fields) {
            return this.createAndAssignScope(node, parentScope, new RelationType(fields));
        }

        private Scope createAndAssignScope(Node node, Optional<Scope> parentScope, List<Field> fields) {
            return this.createAndAssignScope(node, parentScope, new RelationType(fields));
        }

        private Scope createAndAssignScope(Node node, Optional<Scope> parentScope, RelationType relationType) {
            Scope scope = this.scopeBuilder(parentScope).withRelationType(RelationId.of(node), relationType).build();
            StatementAnalyzer.this.analysis.setScope(node, scope);
            return scope;
        }

        private Scope createScope(Optional<Scope> parentScope) {
            return this.scopeBuilder(parentScope).build();
        }

        private Scope.Builder scopeBuilder(Optional<Scope> parentScope) {
            Scope.Builder scopeBuilder = Scope.builder();
            if (parentScope.isPresent()) {
                scopeBuilder.withParent(parentScope.get());
            } else if (this.outerQueryScope.isPresent()) {
                scopeBuilder.withOuterQueryParent(this.outerQueryScope.get());
            }
            return scopeBuilder;
        }

        private class OrderByExpressionRewriter
        extends ExpressionRewriter<Void> {
            private final Multimap<QualifiedName, Expression> assignments;

            public OrderByExpressionRewriter(Multimap<QualifiedName, Expression> assignments) {
                this.assignments = assignments;
            }

            public Expression rewriteIdentifier(Identifier reference, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                QualifiedName name = QualifiedName.of((String)reference.getValue());
                Set expressions = this.assignments.get((Object)name).stream().collect(Collectors.toSet());
                if (expressions.size() > 1) {
                    throw new SemanticException(SemanticErrorCode.AMBIGUOUS_ATTRIBUTE, (Node)reference, "'%s' in ORDER BY is ambiguous", name);
                }
                if (expressions.size() == 1) {
                    return (Expression)Iterables.getOnlyElement(expressions);
                }
                return reference;
            }
        }
    }
}

