/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ConnectorMaterializedViewDefinition;
import com.facebook.presto.spi.MaterializedViewNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.sql.analyzer.ResolvedField;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.SemanticExceptions;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.Node;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class RefreshMaterializedViewPredicateAnalyzer {
    private RefreshMaterializedViewPredicateAnalyzer() {
    }

    public static Map<SchemaTableName, Expression> extractTablePredicates(QualifiedObjectName viewName, Expression originalPredicate, Scope viewScope, Metadata metadata, Session session) {
        ConnectorMaterializedViewDefinition viewDefinition = metadata.getMaterializedView(session, viewName).orElseThrow(() -> new MaterializedViewNotFoundException(MetadataUtil.toSchemaTableName(viewName)));
        Visitor visitor = new Visitor(viewDefinition, viewScope);
        visitor.process((Node)originalPredicate);
        return visitor.getTablePredicates();
    }

    private static class Visitor
    extends DefaultTraversalVisitor<Void, Void> {
        private final ImmutableMultimap.Builder<SchemaTableName, Expression> tablePredicatesBuilder = ImmutableMultimap.builder();
        private final ConnectorMaterializedViewDefinition viewDefinition;
        private final Scope viewScope;

        private Visitor(ConnectorMaterializedViewDefinition viewDefinition, Scope viewScope) {
            this.viewDefinition = Objects.requireNonNull(viewDefinition, "viewDefinition is null");
            this.viewScope = Objects.requireNonNull(viewScope, "viewScope is null");
        }

        public Map<SchemaTableName, Expression> getTablePredicates() {
            ImmutableMap.Builder tableConjuncts = ImmutableMap.builder();
            this.tablePredicatesBuilder.build().asMap().forEach((table, predicateCollection) -> {
                Optional conjunctOptional = predicateCollection.stream().reduce((left, right) -> new LogicalBinaryExpression(LogicalBinaryExpression.Operator.AND, left, right));
                conjunctOptional.ifPresent(conjunct -> tableConjuncts.put(table, conjunct));
            });
            return tableConjuncts.build();
        }

        public Void process(Node node, @Nullable Void context) {
            if (!(node instanceof ComparisonExpression) && !(node instanceof LogicalBinaryExpression)) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, node, "Only column specifications connected by logical AND are supported in WHERE clause.", new Object[0]);
            }
            return (Void)super.process(node, null);
        }

        protected Void visitExpression(Expression node, Void context) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Only column specifications connected by logical AND are supported in WHERE clause.", new Object[0]);
        }

        protected Void visitLogicalBinaryExpression(LogicalBinaryExpression node, Void context) {
            if (!LogicalBinaryExpression.Operator.AND.equals((Object)node.getOperator())) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Only logical AND is supported in WHERE clause.", new Object[0]);
            }
            if (!(node.getLeft() instanceof ComparisonExpression) && !(node.getLeft() instanceof LogicalBinaryExpression)) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node.getLeft(), "Only column specifications connected by logical AND are supported in WHERE clause.", new Object[0]);
            }
            if (!(node.getRight() instanceof ComparisonExpression) && !(node.getRight() instanceof LogicalBinaryExpression)) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node.getRight(), "Only column specifications connected by logical AND are supported in WHERE clause.", new Object[0]);
            }
            return (Void)super.visitLogicalBinaryExpression(node, null);
        }

        protected Void visitComparisonExpression(ComparisonExpression node, Void context) {
            if (!(node.getLeft() instanceof Identifier) && !(node.getLeft() instanceof DereferenceExpression)) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node.getLeft(), "Only columns specified on literals are supported in WHERE clause.", new Object[0]);
            }
            if (!(node.getRight() instanceof Literal)) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node.getRight(), "Only columns specified on literals are supported in WHERE clause.", new Object[0]);
            }
            ResolvedField resolvedField = this.viewScope.tryResolveField(node.getLeft()).orElseThrow(() -> SemanticExceptions.missingAttributeException(node.getLeft()));
            String column = resolvedField.getField().getOriginColumnName().orElseThrow(() -> SemanticExceptions.missingAttributeException(node.getLeft()));
            if (!this.viewDefinition.getValidRefreshColumns().orElse(Collections.emptyList()).contains(column)) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node.getLeft(), "Refresh materialized view by column %s is not supported.", node.getLeft().toString());
            }
            Map baseTableColumns = (Map)this.viewDefinition.getColumnMappingsAsMap().get(column);
            if (baseTableColumns != null) {
                for (SchemaTableName baseTable : baseTableColumns.keySet()) {
                    this.tablePredicatesBuilder.put((Object)baseTable, (Object)new ComparisonExpression(node.getOperator(), (Expression)new Identifier((String)baseTableColumns.get(baseTable)), node.getRight()));
                }
            } else {
                SchemaTableName viewName = new SchemaTableName(this.viewDefinition.getSchema(), this.viewDefinition.getTable());
                this.tablePredicatesBuilder.put((Object)viewName, (Object)node);
            }
            return null;
        }
    }
}

