/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.DomainTranslator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.ExpressionAnalysis;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.MaterializedViewInformationExtractor;
import com.facebook.presto.sql.analyzer.RelationId;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.facebook.presto.sql.relational.RowExpressionDomainTranslator;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GroupBy;
import com.facebook.presto.sql.tree.GroupingElement;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QueryBody;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.SimpleGroupBy;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.Table;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class MaterializedViewQueryOptimizer
extends AstVisitor<Node, Void> {
    private static final Logger logger = Logger.get(MaterializedViewQueryOptimizer.class);
    private final Metadata metadata;
    private final Session session;
    private final SqlParser sqlParser;
    private final AccessControl accessControl;
    private final RowExpressionDomainTranslator domainTranslator;
    private final Table materializedView;
    private final Query materializedViewQuery;
    private final LogicalRowExpressions logicalRowExpressions;
    private final Set<QualifiedName> supportedFunctionCalls = ImmutableSet.of((Object)QualifiedName.of((String)"MIN"), (Object)QualifiedName.of((String)"MAX"), (Object)QualifiedName.of((String)"SUM"));
    private MaterializedViewInformationExtractor.MaterializedViewInfo materializedViewInfo;

    public MaterializedViewQueryOptimizer(Metadata metadata, Session session, SqlParser sqlParser, AccessControl accessControl, RowExpressionDomainTranslator domainTranslator, Table materializedView, Query materializedViewQuery) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sql parser is null");
        this.accessControl = Objects.requireNonNull(accessControl, "access control is null");
        this.domainTranslator = Objects.requireNonNull(domainTranslator, "row expression domain translator is null");
        this.materializedView = Objects.requireNonNull(materializedView, "materialized view is null");
        this.materializedViewQuery = Objects.requireNonNull(materializedViewQuery, "materialized view query is null");
        FunctionAndTypeManager functionAndTypeManager = metadata.getFunctionAndTypeManager();
        this.logicalRowExpressions = new LogicalRowExpressions((DeterminismEvaluator)new RowExpressionDeterminismEvaluator(functionAndTypeManager), (StandardFunctionResolution)new FunctionResolution(functionAndTypeManager), (FunctionMetadataManager)functionAndTypeManager);
    }

    public Node rewrite(Node node) {
        try {
            MaterializedViewInformationExtractor materializedViewInformationExtractor = new MaterializedViewInformationExtractor();
            materializedViewInformationExtractor.process((Node)this.materializedViewQuery);
            this.materializedViewInfo = materializedViewInformationExtractor.getMaterializedViewInfo();
            return (Node)this.process(node);
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage());
            return node;
        }
    }

    protected Node visitNode(Node node, Void context) {
        return node;
    }

    protected Node visitQuery(Query node, Void context) {
        return new Query(node.getWith(), (QueryBody)this.process((Node)node.getQueryBody(), context), node.getOrderBy(), node.getOffset(), node.getLimit());
    }

    protected Node visitQuerySpecification(QuerySpecification node, Void context) {
        if (!node.getFrom().isPresent()) {
            throw new IllegalStateException("Query with no From clause is not rewritable by materialized view");
        }
        if (this.materializedViewInfo.getGroupBy().isPresent() && !node.getGroupBy().isPresent()) {
            throw new IllegalStateException("Query with no groupBy clause is not rewritable by materialized view with groupBy clause");
        }
        if (node.getHaving().isPresent()) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Having clause is not supported in query optimizer", new Object[0]);
        }
        if (this.materializedViewInfo.getWhereClause().isPresent()) {
            if (!node.getWhere().isPresent()) {
                throw new IllegalStateException("Query with no where clause is not rewritable by materialized view with where clause");
            }
            if (!(node.getFrom().get() instanceof Table)) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Relation other than Table is not supported in query optimizer", new Object[0]);
            }
            Table baseTable = (Table)node.getFrom().get();
            QualifiedObjectName baseTableName = MetadataUtil.createQualifiedObjectName(this.session, (Node)baseTable, baseTable.getName());
            Optional<TableHandle> tableHandle = this.metadata.getTableHandle(this.session, baseTableName);
            if (!tableHandle.isPresent()) {
                throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)node, "Table does not exist", new Object[0]);
            }
            ImmutableList.Builder fields = ImmutableList.builder();
            for (ColumnHandle columnHandle : this.metadata.getColumnHandles(this.session, tableHandle.get()).values()) {
                ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(this.session, tableHandle.get(), columnHandle);
                fields.add((Object)Field.newUnqualified(columnMetadata.getName(), columnMetadata.getType()));
            }
            Scope scope = Scope.builder().withRelationType(RelationId.anonymous(), new RelationType((List<Field>)fields.build())).build();
            RowExpression materializedViewWhereCondition = this.convertToRowExpression(this.materializedViewInfo.getWhereClause().get(), scope);
            RowExpression baseQueryWhereCondition = this.convertToRowExpression((Expression)node.getWhere().get(), scope);
            RowExpression rewriteLogicExpression = LogicalRowExpressions.and((RowExpression[])new RowExpression[]{baseQueryWhereCondition, Expressions.call("not", new FunctionResolution(this.metadata.getFunctionAndTypeManager()).notFunction(), materializedViewWhereCondition.getType(), materializedViewWhereCondition)});
            RowExpression disjunctiveNormalForm = this.logicalRowExpressions.convertToDisjunctiveNormalForm(rewriteLogicExpression);
            DomainTranslator.ExtractionResult result = this.domainTranslator.fromPredicate(this.session.toConnectorSession(), disjunctiveNormalForm, DomainTranslator.BASIC_COLUMN_EXTRACTOR);
            if (!result.getTupleDomain().equals((Object)TupleDomain.none())) {
                throw new IllegalStateException("View filter condition does not contain base query's filter condition");
            }
        }
        return new QuerySpecification((Select)this.process((Node)node.getSelect(), context), node.getFrom().map(from -> (Relation)this.process((Node)from, context)), node.getWhere().map(where -> (Expression)this.process((Node)where, context)), node.getGroupBy().map(groupBy -> (GroupBy)this.process((Node)groupBy, context)), node.getHaving().map(having -> (Expression)this.process((Node)having, context)), node.getOrderBy().map(orderBy -> (OrderBy)this.process((Node)orderBy, context)), node.getOffset(), node.getLimit());
    }

    protected Node visitSelect(Select node, Void context) {
        if (this.materializedViewInfo.isDistinct() && !node.isDistinct()) {
            throw new IllegalStateException("Materialized view has distinct and base query does not");
        }
        ImmutableList.Builder rewrittenSelectItems = ImmutableList.builder();
        for (SelectItem selectItem : node.getSelectItems()) {
            rewrittenSelectItems.add((Object)((SelectItem)this.process((Node)selectItem, context)));
        }
        return new Select(node.isDistinct(), (List)rewrittenSelectItems.build());
    }

    protected Node visitSingleColumn(SingleColumn node, Void context) {
        return new SingleColumn((Expression)this.process((Node)node.getExpression(), context), node.getAlias());
    }

    protected Node visitAllColumns(AllColumns node, Void context) {
        throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "All columns rewrite is not supported in query optimizer", new Object[0]);
    }

    protected Node visitArithmeticBinary(ArithmeticBinaryExpression node, Void context) {
        return new ArithmeticBinaryExpression(node.getOperator(), (Expression)this.process((Node)node.getLeft(), context), (Expression)this.process((Node)node.getRight(), context));
    }

    protected Node visitIdentifier(Identifier node, Void context) {
        if (!this.materializedViewInfo.getBaseToViewColumnMap().containsKey(node)) {
            throw new IllegalStateException("Materialized view definition does not contain mapping for the column: " + node.getValue());
        }
        return new Identifier(this.materializedViewInfo.getBaseToViewColumnMap().get(node).getValue(), node.isDelimited());
    }

    protected Node visitFunctionCall(FunctionCall node, Void context) {
        if (!this.supportedFunctionCalls.contains(node.getName())) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, node.getName() + " function is not supported in query optimizer", new Object[0]);
        }
        ImmutableList.Builder rewrittenArguments = ImmutableList.builder();
        if (this.materializedViewInfo.getBaseToViewColumnMap().containsKey(node)) {
            rewrittenArguments.add((Object)this.materializedViewInfo.getBaseToViewColumnMap().get(node));
        } else {
            for (Expression argument : node.getArguments()) {
                rewrittenArguments.add((Object)((Expression)this.process((Node)argument, context)));
            }
        }
        return new FunctionCall(node.getName(), node.getWindow(), node.getFilter(), node.getOrderBy(), node.isDistinct(), node.isIgnoreNulls(), (List)rewrittenArguments.build());
    }

    protected Node visitRelation(Relation node, Void context) {
        if (this.materializedViewInfo.getBaseTable().isPresent() && node.equals((Object)this.materializedViewInfo.getBaseTable().get())) {
            return this.materializedView;
        }
        throw new IllegalStateException("Mismatching table or non-supporting relation format in base query");
    }

    protected Node visitLogicalBinaryExpression(LogicalBinaryExpression node, Void context) {
        return new LogicalBinaryExpression(node.getOperator(), (Expression)this.process((Node)node.getLeft(), context), (Expression)this.process((Node)node.getRight(), context));
    }

    protected Node visitComparisonExpression(ComparisonExpression node, Void context) {
        return new ComparisonExpression(node.getOperator(), (Expression)this.process((Node)node.getLeft(), context), (Expression)this.process((Node)node.getRight(), context));
    }

    protected Node visitGroupBy(GroupBy node, Void context) {
        ImmutableList.Builder rewrittenGroupBy = ImmutableList.builder();
        for (GroupingElement element : node.getGroupingElements()) {
            if (this.materializedViewInfo.getGroupBy().isPresent() && !this.materializedViewInfo.getGroupBy().get().contains(element)) {
                throw new IllegalStateException(String.format("Grouping element %s is not present in materialized view groupBy field", element));
            }
            rewrittenGroupBy.add((Object)((GroupingElement)this.process((Node)element, context)));
        }
        return new GroupBy(node.isDistinct(), (List)rewrittenGroupBy.build());
    }

    protected Node visitOrderBy(OrderBy node, Void context) {
        ImmutableList.Builder rewrittenOrderBy = ImmutableList.builder();
        for (SortItem sortItem : node.getSortItems()) {
            if (!this.materializedViewInfo.getBaseToViewColumnMap().containsKey(sortItem.getSortKey())) {
                throw new IllegalStateException(String.format("Sort key %s is not present in materialized view select fields", sortItem.getSortKey()));
            }
            rewrittenOrderBy.add((Object)((SortItem)this.process((Node)sortItem, context)));
        }
        return new OrderBy((List)rewrittenOrderBy.build());
    }

    protected Node visitSortItem(SortItem node, Void context) {
        return new SortItem((Expression)this.process((Node)node.getSortKey(), context), node.getOrdering(), node.getNullOrdering());
    }

    protected Node visitSimpleGroupBy(SimpleGroupBy node, Void context) {
        ImmutableList.Builder rewrittenSimpleGroupBy = ImmutableList.builder();
        for (Expression column : node.getExpressions()) {
            rewrittenSimpleGroupBy.add((Object)((Expression)this.process((Node)column, context)));
        }
        return new SimpleGroupBy((List)rewrittenSimpleGroupBy.build());
    }

    private RowExpression convertToRowExpression(Expression expression, Scope scope) {
        ExpressionAnalysis expressionAnalysis = ExpressionAnalyzer.analyzeExpression(this.session, this.metadata, this.accessControl, this.sqlParser, scope, new Analysis(null, (List<Expression>)ImmutableList.of(), false), expression, WarningCollector.NOOP);
        return SqlToRowExpressionTranslator.translate(expression, expressionAnalysis.getExpressionTypes(), (Map<VariableReferenceExpression, Integer>)ImmutableMap.of(), this.metadata.getFunctionAndTypeManager(), this.session);
    }
}

