/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.JoinCriteria;
import com.facebook.presto.sql.tree.JoinOn;
import com.facebook.presto.sql.tree.JoinUsing;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Unnest;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class MaterializedViewPlanValidator
extends DefaultTraversalVisitor<Void, MaterializedViewPlanValidatorContext> {
    private final Node query;

    public MaterializedViewPlanValidator(Node query) {
        this.query = Objects.requireNonNull(query, "query is null");
    }

    protected Void visitJoin(Join node, MaterializedViewPlanValidatorContext context) {
        context.getJoinNodes().add(node);
        if (context.getJoinNodes().size() > 1) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, this.query, "More than one join in materialized view is not supported yet.", new Object[0]);
        }
        switch (node.getType()) {
            case INNER: {
                if (!node.getType().equals((Object)Join.Type.INNER)) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Only inner join is supported for materialized view.", new Object[0]);
                }
                if (!node.getCriteria().isPresent()) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Join with no criteria is not supported for materialized view.", new Object[0]);
                }
                JoinCriteria joinCriteria = (JoinCriteria)node.getCriteria().get();
                if (!(joinCriteria instanceof JoinOn) && !(joinCriteria instanceof JoinUsing)) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Only join-on and join-using are supported for materialized view.", new Object[0]);
                }
                context.setProcessingJoinNode(true);
                if (joinCriteria instanceof JoinOn) {
                    this.process((Node)((JoinOn)joinCriteria).getExpression(), context);
                }
                context.setProcessingJoinNode(false);
                break;
            }
            case CROSS: {
                if (!(node.getRight() instanceof AliasedRelation)) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Only cross join with unnest is supported for materialized view.", new Object[0]);
                }
                AliasedRelation right = (AliasedRelation)node.getRight();
                if (!(right.getRelation() instanceof Unnest)) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Only cross join with unnest is supported for materialized view.", new Object[0]);
                }
                this.process((Node)node.getLeft(), context);
                break;
            }
            default: {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Only inner join is supported for materialized view.", new Object[0]);
            }
        }
        return null;
    }

    protected Void visitLogicalBinaryExpression(LogicalBinaryExpression node, MaterializedViewPlanValidatorContext context) {
        if (!context.isProcessingJoinNode()) {
            return null;
        }
        if (!node.getOperator().equals((Object)LogicalBinaryExpression.Operator.AND)) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Only AND operator is supported for join criteria for materialized view.", new Object[0]);
        }
        return (Void)super.visitLogicalBinaryExpression(node, (Object)context);
    }

    protected Void visitComparisonExpression(ComparisonExpression node, MaterializedViewPlanValidatorContext context) {
        if (!context.isProcessingJoinNode()) {
            return (Void)super.visitComparisonExpression(node, (Object)context);
        }
        if (!node.getOperator().equals((Object)ComparisonExpression.Operator.EQUAL)) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Only EQUAL join is supported for materialized view.", new Object[0]);
        }
        return (Void)super.visitComparisonExpression(node, (Object)context);
    }

    protected static final class MaterializedViewPlanValidatorContext {
        private final Set<Join> joinNodes = new HashSet<Join>();
        private boolean isProcessingJoinNode;

        public Set<Join> getJoinNodes() {
            return this.joinNodes;
        }

        public void setProcessingJoinNode(boolean processingJoinNode) {
            this.isProcessingJoinNode = processingJoinNode;
        }

        public boolean isProcessingJoinNode() {
            return this.isProcessingJoinNode;
        }
    }
}

