/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.GroupBy;
import com.facebook.presto.sql.tree.GroupingElement;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.Table;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class MaterializedViewInformationExtractor
extends DefaultTraversalVisitor<Void, Void> {
    private final MaterializedViewInfo materializedViewInfo = new MaterializedViewInfo();

    protected Void visitQuerySpecification(QuerySpecification node, Void context) {
        if (node.getLimit().isPresent()) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Limit clause is not supported in query optimizer", new Object[0]);
        }
        if (node.getHaving().isPresent()) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Having clause is not supported in query optimizer", new Object[0]);
        }
        this.materializedViewInfo.setWhereClause(node.getWhere());
        return (Void)super.visitQuerySpecification(node, (Object)context);
    }

    protected Void visitSelect(Select node, Void context) {
        super.visitSelect(node, (Object)context);
        this.materializedViewInfo.setDistinct(node.isDistinct());
        return null;
    }

    protected Void visitRelation(Relation node, Void context) {
        if (!(node instanceof Table)) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Relation other than Table is not supported in query optimizer", new Object[0]);
        }
        if (this.materializedViewInfo.getBaseTable().isPresent()) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Only support single table rewrite in query optimizer", new Object[0]);
        }
        this.materializedViewInfo.setBaseTable(Optional.of(node));
        return null;
    }

    protected Void visitSingleColumn(SingleColumn node, Void context) {
        Expression baseColumnName = node.getExpression();
        this.materializedViewInfo.addBaseToViewColumn(baseColumnName, node.getAlias().orElse(new Identifier(baseColumnName.toString())));
        return null;
    }

    protected Void visitAllColumns(AllColumns node, Void context) {
        throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "All columns materialized view is not supported in query optimizer", new Object[0]);
    }

    protected Void visitGroupBy(GroupBy node, Void context) {
        this.materializedViewInfo.setGroupBy(Optional.of(ImmutableSet.copyOf((Collection)node.getGroupingElements())));
        return null;
    }

    public MaterializedViewInfo getMaterializedViewInfo() {
        return this.materializedViewInfo;
    }

    public static final class MaterializedViewInfo {
        private final Map<Expression, Identifier> baseToViewColumnMap = new HashMap<Expression, Identifier>();
        private Optional<Relation> baseTable = Optional.empty();
        private Optional<Expression> whereClause = Optional.empty();
        private Optional<Set<GroupingElement>> groupBy = Optional.empty();
        private boolean isDistinct;

        private void addBaseToViewColumn(Expression key, Identifier value) {
            this.baseToViewColumnMap.put(key, value);
        }

        private void setGroupBy(Optional<Set<GroupingElement>> groupBy) {
            Preconditions.checkState((!this.groupBy.isPresent() ? 1 : 0) != 0);
            this.groupBy = groupBy;
        }

        private void setBaseTable(Optional<Relation> baseTable) {
            Preconditions.checkState((!this.baseTable.isPresent() ? 1 : 0) != 0);
            this.baseTable = baseTable;
        }

        private void setWhereClause(Optional<Expression> whereClause) {
            Preconditions.checkState((!this.whereClause.isPresent() ? 1 : 0) != 0);
            this.whereClause = whereClause;
        }

        private void setDistinct(boolean state) {
            this.isDistinct = state;
        }

        public Optional<Relation> getBaseTable() {
            return this.baseTable;
        }

        public Map<Expression, Identifier> getBaseToViewColumnMap() {
            return ImmutableMap.copyOf(this.baseToViewColumnMap);
        }

        public Optional<Set<GroupingElement>> getGroupBy() {
            return this.groupBy;
        }

        public Optional<Expression> getWhereClause() {
            return this.whereClause;
        }

        public boolean isDistinct() {
            return this.isDistinct;
        }
    }
}

