/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Table;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class MaterializedViewCandidateExtractor
extends DefaultTraversalVisitor<Void, Void> {
    private final Set<QualifiedObjectName> tableNames = new HashSet<QualifiedObjectName>();
    private final Metadata metadata;
    private final Session session;

    public MaterializedViewCandidateExtractor(Session session, Metadata metadata) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    protected Void visitTable(Table node, Void context) {
        this.tableNames.add(MetadataUtil.createQualifiedObjectName(this.session, (Node)node, node.getName()));
        return null;
    }

    public Set<QualifiedObjectName> getMaterializedViewCandidates() {
        HashSet<QualifiedObjectName> materializedViewCandidates = new HashSet<QualifiedObjectName>();
        for (QualifiedObjectName baseTable : this.tableNames) {
            List<QualifiedObjectName> materializedViews = this.metadata.getReferencedMaterializedViews(this.session, baseTable);
            if (materializedViewCandidates.isEmpty()) {
                materializedViewCandidates.addAll(materializedViews);
            } else {
                materializedViewCandidates.retainAll(materializedViews);
            }
            if (!materializedViewCandidates.isEmpty()) continue;
            return materializedViewCandidates;
        }
        return materializedViewCandidates;
    }
}

