/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.protocol;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ConnectorSession;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

class RowIterable
implements Iterable<List<Object>> {
    private final ConnectorSession session;
    private final List<Type> types;
    private final Page page;

    public RowIterable(ConnectorSession session, List<Type> types, Page page) {
        this.session = session;
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.page = Objects.requireNonNull(page, "page is null");
    }

    @Override
    public Iterator<List<Object>> iterator() {
        return new RowIterator(this.session, this.types, this.page);
    }

    private static class RowIterator
    extends AbstractIterator<List<Object>> {
        private final ConnectorSession session;
        private final List<Type> types;
        private final Page page;
        private int position = -1;

        private RowIterator(ConnectorSession session, List<Type> types, Page page) {
            this.session = session;
            this.types = types;
            this.page = page;
        }

        protected List<Object> computeNext() {
            ++this.position;
            if (this.position >= this.page.getPositionCount()) {
                return (List)this.endOfData();
            }
            ArrayList<Object> values = new ArrayList<Object>(this.page.getChannelCount());
            for (int channel = 0; channel < this.page.getChannelCount(); ++channel) {
                Type type = this.types.get(channel);
                Block block = this.page.getBlock(channel);
                values.add(type.getObjectValue(this.session.getSqlFunctionProperties(), block, this.position));
            }
            return Collections.unmodifiableList(values);
        }
    }
}

