/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.server.ServerConfig;
import com.google.common.base.Throwables;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

public class ThrowableMapper
implements ExceptionMapper<Throwable> {
    private static final Logger log = Logger.get(ThrowableMapper.class);
    private final boolean includeExceptionInResponse;
    @Context
    private HttpServletRequest request;

    @Inject
    public ThrowableMapper(ServerConfig config) {
        this.includeExceptionInResponse = config.isIncludeExceptionInResponse();
    }

    public Response toResponse(Throwable throwable) {
        if (throwable instanceof WebApplicationException) {
            return ((WebApplicationException)throwable).getResponse();
        }
        log.warn(throwable, "Request failed for %s", new Object[]{this.request.getRequestURI()});
        Response.ResponseBuilder responseBuilder = Response.serverError().header("Content-Type", (Object)"text/plain");
        if (this.includeExceptionInResponse) {
            responseBuilder.entity((Object)Throwables.getStackTraceAsString((Throwable)throwable));
        } else {
            responseBuilder.entity((Object)"Exception processing request");
        }
        return responseBuilder.build();
    }
}

