/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.execution.resourceGroups.ResourceGroupManager;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.resourcemanager.ResourceManagerProxy;
import com.facebook.presto.server.ServerConfig;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1/resourceGroupState")
@RolesAllowed(value={"admin"})
public class ResourceGroupStateInfoResource {
    private final ResourceGroupManager<?> resourceGroupManager;
    private final boolean resourceManagerEnabled;
    private final InternalNodeManager internalNodeManager;
    private final Optional<ResourceManagerProxy> proxyHelper;

    @Inject
    public ResourceGroupStateInfoResource(ServerConfig serverConfig, ResourceGroupManager<?> resourceGroupManager, InternalNodeManager internalNodeManager, Optional<ResourceManagerProxy> proxyHelper) {
        this.resourceManagerEnabled = Objects.requireNonNull(serverConfig, "serverConfig is null").isResourceManagerEnabled();
        this.resourceGroupManager = Objects.requireNonNull(resourceGroupManager, "resourceGroupManager is null");
        this.internalNodeManager = Objects.requireNonNull(internalNodeManager, "internalNodeManager is null");
        this.proxyHelper = Objects.requireNonNull(proxyHelper, "proxyHelper is null");
    }

    @GET
    @Produces(value={"application/json"})
    @Encoded
    @Path(value="{resourceGroupId: .+}")
    public void getResourceGroupInfos(@PathParam(value="resourceGroupId") String resourceGroupIdString, @QueryParam(value="includeQueryInfo") @DefaultValue(value="true") boolean includeQueryInfo, @QueryParam(value="includeLocalInfoOnly") @DefaultValue(value="false") boolean includeLocalInfoOnly, @QueryParam(value="summarizeSubgroups") @DefaultValue(value="true") boolean summarizeSubgroups, @QueryParam(value="includeStaticSubgroupsOnly") @DefaultValue(value="false") boolean includeStaticSubgroupsOnly, @HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @Context UriInfo uriInfo, @Context HttpServletRequest servletRequest, @Suspended AsyncResponse asyncResponse) {
        if (this.resourceManagerEnabled && !includeLocalInfoOnly) {
            this.proxyResourceGroupInfoResponse(servletRequest, asyncResponse, xForwardedProto, uriInfo);
            return;
        }
        if (!Strings.isNullOrEmpty((String)resourceGroupIdString)) {
            try {
                asyncResponse.resume((Object)Response.ok().entity((Object)this.resourceGroupManager.getResourceGroupInfo(new ResourceGroupId((List)Arrays.stream(resourceGroupIdString.split("/")).map(ResourceGroupStateInfoResource::urlDecode).collect(ImmutableList.toImmutableList())), includeQueryInfo, summarizeSubgroups, includeStaticSubgroupsOnly)).build());
            }
            catch (IllegalArgumentException | NoSuchElementException e) {
                asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
            }
        }
        asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
    }

    private static String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
    }

    private void proxyResourceGroupInfoResponse(HttpServletRequest servletRequest, AsyncResponse asyncResponse, String xForwardedProto, UriInfo uriInfo) {
        try {
            Preconditions.checkState((boolean)this.proxyHelper.isPresent());
            Iterator<InternalNode> resourceManagers = this.internalNodeManager.getResourceManagers().iterator();
            if (!resourceManagers.hasNext()) {
                asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build());
                return;
            }
            InternalNode resourceManagerNode = resourceManagers.next();
            String scheme = Strings.isNullOrEmpty((String)xForwardedProto) ? uriInfo.getRequestUri().getScheme() : xForwardedProto;
            URI uri = uriInfo.getRequestUriBuilder().scheme(scheme).host(resourceManagerNode.getHostAndPort().toInetAddress().getHostName()).port(resourceManagerNode.getInternalUri().getPort()).build(new Object[0]);
            this.proxyHelper.get().performRequest(servletRequest, asyncResponse, uri);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)e);
        }
    }
}

