/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourcemanager;

import com.facebook.drift.client.DriftClient;
import com.facebook.presto.execution.resourceGroups.ResourceGroupRuntimeInfo;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.resourcemanager.ForResourceManager;
import com.facebook.presto.resourcemanager.ResourceGroupService;
import com.facebook.presto.resourcemanager.ResourceManagerClient;
import com.facebook.presto.resourcemanager.ResourceManagerInconsistentException;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class ResourceManagerResourceGroupService
implements ResourceGroupService {
    private final DriftClient<ResourceManagerClient> resourceManagerClient;
    private final InternalNodeManager internalNodeManager;
    private final Cache<InternalNode, List<ResourceGroupRuntimeInfo>> cache;
    private final Executor executor = Executors.newCachedThreadPool();

    @Inject
    public ResourceManagerResourceGroupService(@ForResourceManager DriftClient<ResourceManagerClient> resourceManagerClient, InternalNodeManager internalNodeManager) {
        this.resourceManagerClient = Objects.requireNonNull(resourceManagerClient, "resourceManagerService is null");
        this.internalNodeManager = Objects.requireNonNull(internalNodeManager, "internalNodeManager is null");
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).refreshAfterWrite(1L, TimeUnit.SECONDS).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<InternalNode, List<ResourceGroupRuntimeInfo>>(){

            public List<ResourceGroupRuntimeInfo> load(InternalNode internalNode) throws ResourceManagerInconsistentException {
                return ResourceManagerResourceGroupService.this.getResourceGroupInfos(internalNode);
            }
        }, (Executor)this.executor));
    }

    @Override
    public List<ResourceGroupRuntimeInfo> getResourceGroupInfo() throws ResourceManagerInconsistentException {
        try {
            InternalNode currentNode = this.internalNodeManager.getCurrentNode();
            return (List)this.cache.get((Object)currentNode, () -> this.getResourceGroupInfos(currentNode));
        }
        catch (ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), ResourceManagerInconsistentException.class);
            throw new RuntimeException(e.getCause());
        }
    }

    private List<ResourceGroupRuntimeInfo> getResourceGroupInfos(InternalNode internalNode) throws ResourceManagerInconsistentException {
        return ((ResourceManagerClient)this.resourceManagerClient.get()).getResourceGroupInfo(internalNode.getNodeIdentifier());
    }
}

