/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourcemanager;

import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.resourcemanager.ResourceManagerClusterStateProvider;
import com.facebook.presto.resourcemanager.ResourceManagerProxy;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.spi.QueryId;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1/query")
@RolesAllowed(value={"user", "admin"})
public class DistributedQueryResource {
    private final ResourceManagerClusterStateProvider clusterStateProvider;
    private final ResourceManagerProxy proxyHelper;

    @Inject
    public DistributedQueryResource(ResourceManagerClusterStateProvider clusterStateProvider, ResourceManagerProxy proxyHelper) {
        this.clusterStateProvider = Objects.requireNonNull(clusterStateProvider, "nodeStateManager is null");
        this.proxyHelper = Objects.requireNonNull(proxyHelper, "proxyHelper is null");
    }

    @GET
    public Response getAllQueryInfo(@QueryParam(value="state") String stateFilter) {
        ImmutableList queries;
        QueryState expectedState;
        QueryState queryState = expectedState = stateFilter == null ? null : QueryState.valueOf(stateFilter.toUpperCase(Locale.ENGLISH));
        if (stateFilter == null) {
            queries = this.clusterStateProvider.getClusterQueries();
        } else {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (BasicQueryInfo queryInfo : this.clusterStateProvider.getClusterQueries()) {
                if (queryInfo.getState() != expectedState) continue;
                builder.add((Object)queryInfo);
            }
            queries = builder.build();
        }
        return Response.ok(queries).build();
    }

    @GET
    @Path(value="{queryId}")
    public void getQueryInfo(@PathParam(value="queryId") QueryId queryId, @HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @Context UriInfo uriInfo, @Context HttpServletRequest servletRequest, @Suspended AsyncResponse asyncResponse) {
        this.proxyResponse(servletRequest, asyncResponse, uriInfo, queryId);
    }

    @DELETE
    @Path(value="{queryId}")
    public void cancelQuery(@PathParam(value="queryId") QueryId queryId, @HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @Context UriInfo uriInfo, @Context HttpServletRequest servletRequest, @Suspended AsyncResponse asyncResponse) {
        this.proxyResponse(servletRequest, asyncResponse, uriInfo, queryId);
    }

    @PUT
    @Path(value="{queryId}/killed")
    public void killQuery(@PathParam(value="queryId") QueryId queryId, String message, @HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @Context UriInfo uriInfo, @Context HttpServletRequest servletRequest, @Suspended AsyncResponse asyncResponse) {
        this.proxyResponse(servletRequest, asyncResponse, uriInfo, queryId);
    }

    @PUT
    @Path(value="{queryId}/preempted")
    public void preemptQuery(@PathParam(value="queryId") QueryId queryId, String message, @HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @Context UriInfo uriInfo, @Context HttpServletRequest servletRequest, @Suspended AsyncResponse asyncResponse) {
        this.proxyResponse(servletRequest, asyncResponse, uriInfo, queryId);
    }

    private void proxyResponse(HttpServletRequest servletRequest, AsyncResponse asyncResponse, UriInfo uriInfo, QueryId queryId) {
        Optional<BasicQueryInfo> queryInfo = this.clusterStateProvider.getClusterQueries().stream().filter(query -> query.getQueryId().equals((Object)queryId)).findFirst();
        if (!queryInfo.isPresent()) {
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).build());
            return;
        }
        this.proxyHelper.performRequest(servletRequest, asyncResponse, HttpUriBuilder.uriBuilderFrom((URI)queryInfo.get().getSelf()).replacePath(uriInfo.getPath()).build());
    }
}

