/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.FixedWidthType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.operator.scalar.DateTimeFunctions;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.type.DateTimeOperators;
import com.facebook.presto.util.Failures;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.concurrent.TimeUnit;

public final class SequenceFunction {
    private static final long MAX_RESULT_ENTRIES = 10000L;
    private static final Slice MONTH = Slices.utf8Slice((String)"month");

    private SequenceFunction() {
    }

    @Description(value="Sequence function to generate synthetic arrays")
    @ScalarFunction(value="sequence")
    @SqlType(value="array(bigint)")
    public static Block sequence(@SqlType(value="bigint") long start, @SqlType(value="bigint") long stop, @SqlType(value="bigint") long step) {
        return SequenceFunction.fixedWidthSequence(start, stop, step, (FixedWidthType)BigintType.BIGINT);
    }

    @ScalarFunction(value="sequence")
    @SqlType(value="array(bigint)")
    public static Block sequenceDefaultStep(@SqlType(value="bigint") long start, @SqlType(value="bigint") long stop) {
        return SequenceFunction.fixedWidthSequence(start, stop, stop >= start ? 1L : -1L, (FixedWidthType)BigintType.BIGINT);
    }

    @ScalarFunction(value="sequence")
    @SqlType(value="array(date)")
    public static Block sequenceDateDefaultStep(@SqlType(value="date") long start, @SqlType(value="date") long stop) {
        return SequenceFunction.fixedWidthSequence(start, stop, stop >= start ? 1L : -1L, (FixedWidthType)DateType.DATE);
    }

    @ScalarFunction(value="sequence")
    @SqlType(value="array(date)")
    public static Block sequenceDateDayToSecond(@SqlType(value="date") long start, @SqlType(value="date") long stop, @SqlType(value="interval day to second") long step) {
        Failures.checkCondition(step % TimeUnit.DAYS.toMillis(1L) == 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "sequence step must be a day interval if start and end values are dates", new Object[0]);
        return SequenceFunction.fixedWidthSequence(start, stop, step / TimeUnit.DAYS.toMillis(1L), (FixedWidthType)DateType.DATE);
    }

    @ScalarFunction(value="sequence")
    @SqlType(value="array(date)")
    public static Block sequenceDateYearToMonth(SqlFunctionProperties properties, @SqlType(value="date") long start, @SqlType(value="date") long stop, @SqlType(value="interval year to month") long step) {
        SequenceFunction.checkValidStep(start, stop, step);
        int length = Math.toIntExact(DateTimeFunctions.diffDate(properties, MONTH, start, stop) / step + 1L);
        SequenceFunction.checkMaxEntry(length);
        BlockBuilder blockBuilder = DateType.DATE.createBlockBuilder(null, length);
        int value = 0;
        for (int i = 0; i < length; ++i) {
            DateType.DATE.writeLong(blockBuilder, DateTimeOperators.datePlusIntervalYearToMonth(start, value));
            value = (int)((long)value + step);
        }
        return blockBuilder.build();
    }

    @ScalarFunction(value="sequence")
    @SqlType(value="array(timestamp)")
    public static Block sequenceTimestampDayToSecond(@SqlType(value="timestamp") long start, @SqlType(value="timestamp") long stop, @SqlType(value="interval day to second") long step) {
        return SequenceFunction.fixedWidthSequence(start, stop, step, (FixedWidthType)TimestampType.TIMESTAMP);
    }

    @ScalarFunction(value="sequence")
    @SqlType(value="array(timestamp)")
    public static Block sequenceTimestampYearToMonth(SqlFunctionProperties properties, @SqlType(value="timestamp") long start, @SqlType(value="timestamp") long stop, @SqlType(value="interval year to month") long step) {
        SequenceFunction.checkValidStep(start, stop, step);
        int length = Math.toIntExact(DateTimeFunctions.diffTimestamp(properties, MONTH, start, stop) / step + 1L);
        SequenceFunction.checkMaxEntry(length);
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, length);
        int value = 0;
        for (int i = 0; i < length; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, DateTimeOperators.timestampPlusIntervalYearToMonth(properties, start, value));
            value = (int)((long)value + step);
        }
        return blockBuilder.build();
    }

    private static Block fixedWidthSequence(long start, long stop, long step, FixedWidthType type) {
        SequenceFunction.checkValidStep(start, stop, step);
        int length = Math.toIntExact((stop - start) / step + 1L);
        SequenceFunction.checkMaxEntry(length);
        BlockBuilder blockBuilder = type.createBlockBuilder(null, length);
        long i = 0L;
        long value = start;
        while (i < (long)length) {
            type.writeLong(blockBuilder, value);
            ++i;
            value += step;
        }
        return blockBuilder.build();
    }

    private static void checkValidStep(long start, long stop, long step) {
        Failures.checkCondition(step != 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "step must not be zero", new Object[0]);
        Failures.checkCondition(step > 0L ? stop >= start : stop <= start, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "sequence stop value should be greater than or equal to start value if step is greater than zero otherwise stop should be less than or equal to start", new Object[0]);
    }

    private static void checkMaxEntry(int length) {
        Failures.checkCondition((long)length <= 10000L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "result of sequence function must not have more than 10000 entries", new Object[0]);
    }
}

