/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.RowComparisonOperator;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;

public final class RowLessThanOperator
extends RowComparisonOperator {
    public static final RowLessThanOperator ROW_LESS_THAN = new RowLessThanOperator();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(RowLessThanOperator.class, "less", RowType.class, List.class, Block.class, Block.class);

    private RowLessThanOperator() {
        super(OperatorType.LESS_THAN);
    }

    @Override
    public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Type type = boundVariables.getTypeVariable("T");
        return new BuiltInScalarFunctionImplementation(false, (List<BuiltInScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(BuiltInScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL), (Object)BuiltInScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(BuiltInScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), METHOD_HANDLE.bindTo(type).bindTo(this.getMethodHandles((RowType)type, functionAndTypeManager, OperatorType.LESS_THAN)));
    }

    public static boolean less(RowType rowType, List<MethodHandle> lessThanFunctions, Block leftRow, Block rightRow) {
        int compareResult = RowLessThanOperator.compare(rowType, lessThanFunctions, leftRow, rightRow);
        return compareResult > 0;
    }
}

